/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;

public class XSDException
extends Exception {
    private int errId = 0;
    private String[] errParams;
    private int nparam;
    private XMLElement node;
    private XMLError defaultErr = new XMLError();

    XSDException() {
        super("XMLSchema Error");
    }

    XSDException(int n, String string) {
        super("");
        this.errId = n;
        this.errParams = new String[1];
        this.errParams[0] = string;
        this.nparam = 1;
    }

    XSDException(int n, String string, String string2) {
        super("");
        this.errId = n;
        this.errParams = new String[2];
        this.errParams[0] = string;
        this.errParams[1] = string2;
        this.nparam = 2;
    }

    XSDException(int n, String string, String string2, String string3) {
        super("");
        this.errId = n;
        this.errParams = new String[3];
        this.errParams[0] = string;
        this.errParams[1] = string2;
        this.errParams[2] = string3;
        this.nparam = 3;
    }

    XSDException(int n, String string, XMLElement xMLElement) {
        super("");
        this.errId = n;
        this.errParams = new String[1];
        this.errParams[0] = string;
        this.nparam = 1;
        this.node = xMLElement;
    }

    XSDException(String string) {
        super(string);
    }

    int getErrorId() {
        return this.errId;
    }

    XMLElement getErrorNode() {
        return this.node;
    }

    String getErrorPara1() {
        return this.errParams[0];
    }

    String getErrorPara2() {
        return this.errParams[1];
    }

    public String getMessage() {
        if (this.errId == 0) {
            return super.getMessage();
        }
        return this.getMessage(this.defaultErr);
    }

    public String getMessage(XMLError xMLError) {
        if (this.errId == 0) {
            return super.getMessage();
        }
        switch (this.nparam) {
            case 0: {
                return xMLError.getMessage0(this.errId);
            }
            case 1: {
                return xMLError.getMessage1(this.errId, this.errParams[0]);
            }
            case 2: {
                return xMLError.getMessage2(this.errId, this.errParams[0], this.errParams[1]);
            }
            case 3: {
                return xMLError.getMessage3(this.errId, this.errParams[0], this.errParams[1], this.errParams[2]);
            }
            case 4: {
                return xMLError.getMessage4(this.errId, this.errParams[0], this.errParams[1], this.errParams[2], this.errParams[3]);
            }
            case 5: {
                return xMLError.getMessage5(this.errId, this.errParams[0], this.errParams[1], this.errParams[2], this.errParams[3], this.errParams[4]);
            }
        }
        return super.getMessage();
    }
}

