/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDTypeConstants;

public class XSDSimpleType
extends XSDNode
implements XSDParticleNode,
XSDTypeConstants {
    boolean bAbstract;
    XSDSimpleType base;
    XSDSimpleType itemType;
    Vector members;
    String variety;
    int basicType;
    XSDConstrainingFacet[] facets;
    boolean[] isNewFacet;
    XSDConstrainingFacet enumFacet;
    boolean isOrdered;
    boolean isBounded;
    boolean isFinite;
    static Hashtable builtInTypes;
    static XSDSimpleType urType;

    public XSDSimpleType() {
        this.nodeType = 2;
        this.variety = "#undef";
        this.base = null;
        this.isNewFacet = new boolean[13];
        this.facets = new XSDConstrainingFacet[13];
    }

    public XSDSimpleType(int n, String string) {
        this.name = string;
        this.nodeType = 2;
        this.basicType = n;
        this.variety = "atomic";
        this.base = urType;
        this.isNewFacet = new boolean[13];
        this.facets = new XSDConstrainingFacet[13];
    }

    public static XSDSimpleType derivedFrom(XSDSimpleType xSDSimpleType, String string, String string2) throws XSDException {
        XSDSimpleType xSDSimpleType2 = new XSDSimpleType(xSDSimpleType.basicType, string);
        xSDSimpleType2.base = xSDSimpleType;
        if (string2 == "list") {
            xSDSimpleType2.variety = "list";
            xSDSimpleType2.isOrdered = false;
            xSDSimpleType2.itemType = xSDSimpleType;
        } else if (string2 == "union") {
            xSDSimpleType2.variety = "union";
            xSDSimpleType2.isOrdered = false;
        } else {
            xSDSimpleType2.isBounded = xSDSimpleType.isBounded;
            xSDSimpleType2.isFinite = xSDSimpleType.isFinite;
            xSDSimpleType2.isOrdered = xSDSimpleType.isOrdered;
            int n = 0;
            while (n < 13) {
                xSDSimpleType2.facets[n] = xSDSimpleType.facets[n];
                ++n;
            }
            xSDSimpleType2.variety = xSDSimpleType.variety;
            xSDSimpleType2.members = xSDSimpleType.members;
            xSDSimpleType2.itemType = xSDSimpleType.itemType;
        }
        return xSDSimpleType2;
    }

    public XSDSimpleType getBase() {
        return this.base;
    }

    public int getBasicType() {
        return this.basicType;
    }

    public static Hashtable getBuiltInDatatypes() throws XSDException {
        if (builtInTypes == null) {
            builtInTypes = new Hashtable();
            XSDSimpleType.init(builtInTypes);
        }
        return builtInTypes;
    }

    int getFacetId(String string) throws XSDException {
        if (string == XSDTypeConstants.MININCLUSIVE) {
            return 1;
        }
        if (string == XSDTypeConstants.MINEXCLUSIVE) {
            return 2;
        }
        if (string == XSDTypeConstants.MAXINCLUSIVE) {
            return 3;
        }
        if (string == XSDTypeConstants.MAXEXCLUSIVE) {
            return 4;
        }
        if (string == "precision") {
            return 5;
        }
        if (string == "scale") {
            return 6;
        }
        if (string == XSDTypeConstants.TOTAL_DIGITS) {
            return 5;
        }
        if (string == XSDTypeConstants.FRACTION_DIGITS) {
            return 6;
        }
        if (string == XSDTypeConstants.LENGTH) {
            return 7;
        }
        if (string == XSDTypeConstants.MAXLENGTH) {
            return 8;
        }
        if (string == XSDTypeConstants.MINLENGTH) {
            return 9;
        }
        if (string == XSDTypeConstants.ENUMERATION) {
            return 10;
        }
        if (string == XSDTypeConstants.PATTERN) {
            return 11;
        }
        if (string == XSDTypeConstants.WHITESPACE) {
            return 12;
        }
        if (string == "encoding" || string == "period" || string == XSDTypeConstants.DURATION) {
            return 0;
        }
        throw new XSDException(2900, "05");
    }

    public XSDConstrainingFacet[] getFacets() {
        return this.facets;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public int getMinOccurs() {
        return 1;
    }

    public String getVariety() {
        return this.variety;
    }

    static void init(Hashtable hashtable) throws XSDException {
        urType = new XSDSimpleType(0, XSDTypeConstants.ANY_SIMPLE);
        hashtable.put(XSDTypeConstants.ANY_SIMPLE, urType);
        hashtable.put(XSDTypeConstants.STRING, new XSDSimpleType(1, XSDTypeConstants.STRING));
        hashtable.put(XSDTypeConstants.BOOLEAN, new XSDSimpleType(2, XSDTypeConstants.BOOLEAN));
        hashtable.put(XSDTypeConstants.FLOAT, new XSDSimpleType(3, XSDTypeConstants.FLOAT));
        hashtable.put(XSDTypeConstants.DOUBLE, new XSDSimpleType(4, XSDTypeConstants.DOUBLE));
        hashtable.put(XSDTypeConstants.DECIMAL, new XSDSimpleType(5, XSDTypeConstants.DECIMAL));
        hashtable.put(XSDTypeConstants.DURATION, new XSDSimpleType(6, XSDTypeConstants.DURATION));
        hashtable.put(XSDTypeConstants.DATE_TIME, new XSDSimpleType(7, XSDTypeConstants.DATE_TIME));
        hashtable.put(XSDTypeConstants.TIME, new XSDSimpleType(8, XSDTypeConstants.TIME));
        hashtable.put(XSDTypeConstants.DATE, new XSDSimpleType(9, XSDTypeConstants.DATE));
        hashtable.put(XSDTypeConstants.GYEAR_MONTH, new XSDSimpleType(10, XSDTypeConstants.GYEAR_MONTH));
        hashtable.put(XSDTypeConstants.GYEAR, new XSDSimpleType(11, XSDTypeConstants.GYEAR));
        hashtable.put(XSDTypeConstants.GMONTH_DAY, new XSDSimpleType(13, XSDTypeConstants.GMONTH_DAY));
        hashtable.put(XSDTypeConstants.GDAY, new XSDSimpleType(14, XSDTypeConstants.GDAY));
        hashtable.put(XSDTypeConstants.GMONTH, new XSDSimpleType(12, XSDTypeConstants.GMONTH));
        hashtable.put(XSDTypeConstants.HEX_BINARY, new XSDSimpleType(15, XSDTypeConstants.HEX_BINARY));
        hashtable.put(XSDTypeConstants.BASE64_BINARY, new XSDSimpleType(16, XSDTypeConstants.BASE64_BINARY));
        hashtable.put(XSDTypeConstants.ANY_URI, new XSDSimpleType(17, XSDTypeConstants.ANY_URI));
        hashtable.put(XSDTypeConstants.QNAME, new XSDSimpleType(18, XSDTypeConstants.QNAME));
        hashtable.put(XSDTypeConstants.SNOTATION, new XSDSimpleType(19, XSDTypeConstants.SNOTATION));
        try {
            XSDSimpleType xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.STRING);
            XSDSimpleType xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "normalizedString", "restriction");
            hashtable.put("normalizedString", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("normalizedString");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "token", "restriction");
            hashtable.put("token", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("token");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "language", "restriction");
            xSDSimpleType2.setFacet(11, "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
            hashtable.put("language", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("token");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "NMTOKEN", "restriction");
            xSDSimpleType2.setFacet(11, "\\c+");
            hashtable.put("NMTOKEN", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("token");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "Name", "restriction");
            xSDSimpleType2.setFacet(11, "\\i\\c*");
            hashtable.put("Name", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.DECIMAL);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "integer", "restriction");
            xSDSimpleType2.setFacet(6, "0");
            hashtable.put("integer", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("Name");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "NCName", "restriction");
            xSDSimpleType2.setFacet(11, "[\\i-[:]][\\c-[:]]*");
            hashtable.put("NCName", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("NCName");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "ID", "restriction");
            hashtable.put("ID", xSDSimpleType2);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "IDREF", "restriction");
            hashtable.put("IDREF", xSDSimpleType2);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "ENTITY", "restriction");
            hashtable.put("ENTITY", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("integer");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "nonPositiveInteger", "restriction");
            xSDSimpleType2.setFacet(3, "0");
            hashtable.put("nonPositiveInteger", xSDSimpleType2);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "long", "restriction");
            xSDSimpleType2.setFacet(1, "-9223372036854775808");
            xSDSimpleType2.setFacet(3, "9223372036854775807");
            hashtable.put("long", xSDSimpleType2);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "nonNegativeInteger", "restriction");
            xSDSimpleType2.setFacet(1, "0");
            hashtable.put("nonNegativeInteger", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("nonPositiveInteger");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "negativeInteger", "restriction");
            xSDSimpleType2.setFacet(3, "-1");
            hashtable.put("negativeInteger", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("long");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "int", "restriction");
            xSDSimpleType2.setFacet(1, "-2147483648");
            xSDSimpleType2.setFacet(3, "2147483647");
            hashtable.put("int", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("int");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "short", "restriction");
            xSDSimpleType2.setFacet(1, "-32768");
            xSDSimpleType2.setFacet(3, "32767");
            hashtable.put("short", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("short");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "byte", "restriction");
            xSDSimpleType2.setFacet(1, "-128");
            xSDSimpleType2.setFacet(3, "127");
            hashtable.put("byte", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("nonNegativeInteger");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "unsignedLong", "restriction");
            xSDSimpleType2.setFacet(3, "18446744073709551615");
            hashtable.put("unsignedLong", xSDSimpleType2);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "positiveInteger", "restriction");
            xSDSimpleType2.setFacet(1, "1");
            hashtable.put("positiveInteger", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("unsignedLong");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "unsignedInt", "restriction");
            xSDSimpleType2.setFacet(3, "4294967295");
            hashtable.put("unsignedInt", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("unsignedInt");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "unsignedShort", "restriction");
            xSDSimpleType2.setFacet(3, "65535");
            hashtable.put("unsignedShort", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("unsignedShort");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "unsignedByte", "restriction");
            xSDSimpleType2.setFacet(3, "255");
            hashtable.put("unsignedByte", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("NMTOKEN");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "NMTOKENS", "list");
            hashtable.put("NMTOKENS", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("IDREF");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "IDREFS", "list");
            hashtable.put("IDREFS", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get("ENTITY");
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "ENTITIES", "list");
            hashtable.put("ENTITIES", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.DURATION);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "byte", "restriction");
            hashtable.put("timeDuration", hashtable.get(XSDTypeConstants.DURATION));
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.DATE_TIME);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "recurringDuration", "restriction");
            hashtable.put("recurringDuration", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.DATE_TIME);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "timeInstant", "restriction");
            hashtable.put("timeInstant", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.ANY_URI);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "uriReference", "restriction");
            hashtable.put("uriReference", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.STRING);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "CDATA", "restriction");
            hashtable.put("CDATA", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.DURATION);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "timePeriod", "restriction");
            hashtable.put("timePeriod", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.GYEAR);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "year", "restriction");
            hashtable.put("year", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.GYEAR);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "century", "restriction");
            hashtable.put("century", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.GMONTH);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "month", "restriction");
            hashtable.put("month", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.GDAY);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "recurringDay", "restriction");
            hashtable.put("recurringDay", xSDSimpleType2);
            xSDSimpleType = (XSDSimpleType)hashtable.get(XSDTypeConstants.GMONTH_DAY);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(xSDSimpleType, "recurringDate", "restriction");
            hashtable.put("recurringDate", xSDSimpleType2);
            xSDSimpleType2 = XSDSimpleType.derivedFrom(urType, "binary", "restriction");
            hashtable.put("binary", xSDSimpleType2);
        }
        catch (XSDException xSDException) {
            throw xSDException;
        }
        catch (Exception exception) {
            throw new XSDException(2900, "08");
        }
    }

    public boolean isAbstract() {
        return this.bAbstract;
    }

    void print(int n) {
        this.printSTag(n);
        if (this.bAbstract) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "abstract = true");
        } else {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "abstract = false");
        }
        if (this.variety != "#undef") {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "variety = " + this.variety);
        }
        this.printSTagEnd(n);
        int n2 = 0;
        while (n2 < 13) {
            if (this.facets[n2] != null) {
                System.out.print(XSDNode.indent(n + 3));
                System.out.print("<" + XSDTypeConstants.sFacets[n2] + " ");
                System.out.println("value = " + this.facets[n2].print() + "/>");
            }
            ++n2;
        }
        this.printETag(n);
    }

    private String processWS(String string) {
        if (this.variety != "atomic" || this.name == XSDTypeConstants.sTypes[1]) {
            return string;
        }
        if (this.basicType == 1 && this.facets[12] == null) {
            return string;
        }
        String string2 = "#undef";
        if (this.facets[12] != null) {
            string2 = this.facets[12].getLexicalValue();
        }
        if (string2 == "preserve") {
            return string;
        }
        String string3 = string.replace('\t', ' ');
        string3 = string3.replace('\n', ' ');
        string3 = string3.replace('\r', ' ');
        if (string2 == "replace") {
            return string3;
        }
        string3 = string3.trim();
        char[] cArray = string3.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < string3.length()) {
            if (cArray[n2] != ' ' || !bl) {
                cArray[n++] = cArray[n2];
                bl = cArray[n2] == ' ';
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    private void setFacet(int n, String string) throws Exception {
        if (this.isNewFacet[n] && n != 10) {
            throw new XSDException(2204, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
        }
        if (this.facets[n] != null && this.facets[n].isFixed) {
            throw new XSDException(2204, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
        }
        XSDConstrainingFacet xSDConstrainingFacet = new XSDConstrainingFacet(n);
        xSDConstrainingFacet.setValue(string, this.basicType);
        switch (n) {
            case 1: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 2: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 3: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) <= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 4: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) <= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 7: {
                if (this.facets[n] != null) {
                    throw new XSDException(2204, XSDTypeConstants.sFacets[n], XSDTypeConstants.sFacets[n]);
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 8: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) <= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 9: {
                if (this.facets[n] != null && this.facets[n].compareTo(xSDConstrainingFacet) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 10: {
                if (!this.isNewFacet[n]) {
                    if (this.facets[n] != null) {
                        this.enumFacet = this.facets[n];
                        this.facets[n] = null;
                    }
                    this.isNewFacet[n] = true;
                }
                XSDDataValue xSDDataValue = new XSDDataValue(this.basicType, string);
                if (this.enumFacet != null && !this.enumFacet.includeEnum(xSDDataValue)) {
                    return;
                }
                if (this.facets[n] == null) {
                    this.facets[n] = xSDConstrainingFacet;
                    break;
                }
                this.facets[n].addEnumeration(xSDDataValue);
                break;
            }
            case 11: {
                if (!this.isNewFacet[n] && this.facets[n] != null) {
                    xSDConstrainingFacet.mergePattern(this.facets[n]);
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 5: {
                if (this.facets[n] != null && xSDConstrainingFacet.compareTo(this.facets[n]) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 6: {
                if (this.facets[n] != null && xSDConstrainingFacet.compareTo(this.facets[n]) >= 0) {
                    return;
                }
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
                break;
            }
            case 12: {
                this.facets[n] = xSDConstrainingFacet;
                this.isNewFacet[n] = true;
            }
        }
    }

    public void setFacet(String string, String string2) throws XSDException {
        if (string.equals("period") || string.equals(XSDTypeConstants.DURATION)) {
            return;
        }
        int n = this.getFacetId(string.intern());
        try {
            this.setFacet(n, string2);
        }
        catch (XSDException xSDException) {
            throw xSDException;
        }
        catch (Exception exception) {
            throw new XSDException(2202, string2, this.name, string);
        }
    }

    public void setMaxOccurs(int n) {
    }

    public void setMinOccurs(int n) {
    }

    public void setSource(XSDNode xSDNode) throws XSDException {
        XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDNode;
        int n = 0;
        while (n < 13) {
            this.facets[n] = xSDSimpleType.facets[n];
            ++n;
        }
    }

    void setVariety(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "list" && string2 != "restriction" && string2 != "union") {
            throw new XSDException();
        }
        this.variety = string2 == "union" || string2 == "list" ? string2 : (this.base != null ? this.base.variety : "atomic");
    }

    public void validateValue(String string) throws Exception {
        if (this.variety == "union") {
            int n = this.members.size();
            int n2 = 0;
            while (n2 < n) {
                XSDSimpleType xSDSimpleType = (XSDSimpleType)this.members.elementAt(n2);
                try {
                    xSDSimpleType.validateValue(string);
                    return;
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
            throw new XSDException(2207, string, this.name);
        }
        if (this.variety == "list") {
            if (this.itemType == null) {
                throw new XSDException(2207, string, this.name);
            }
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.itemType.validateValue(string2);
                ++n;
            }
            int n3 = 1;
            while (n3 < 13) {
                if (this.facets[n3] != null) {
                    this.facets[n3].validateLength(n);
                }
                ++n3;
            }
        } else {
            String string3 = this.processWS(string);
            XSDDataValue xSDDataValue = new XSDDataValue(this.basicType, string3);
            int n = 1;
            while (n < 13) {
                if (this.facets[n] != null) {
                    this.facets[n].validateFacet(xSDDataValue);
                }
                ++n;
            }
        }
    }
}

