/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XMLAttrList
implements NamedNodeMap,
Serializable,
XMLConstants {
    XMLElement parent;
    XMLAttr firstAttr;

    private void add(XMLAttr xMLAttr) {
        Object object;
        if (this.firstAttr == null) {
            this.firstAttr = xMLAttr;
            xMLAttr.nextNode = null;
            xMLAttr.prevNode = null;
        } else {
            object = this.firstAttr;
            while (((XMLNode)object).nextNode != null) {
                object = (XMLAttr)((XMLNode)object).nextNode;
            }
            ((XMLNode)object).nextNode = xMLAttr;
            xMLAttr.prevNode = object;
            xMLAttr.nextNode = null;
        }
        xMLAttr.parent = this.parent;
        object = xMLAttr.getValue();
        if (xMLAttr.prefix == "xmlns") {
            if (this.parent.nameSpaces == null) {
                this.parent.nameSpaces = new Hashtable(20);
            }
            this.parent.nameSpaces.put(xMLAttr.name, ((String)object).intern());
        }
        if (xMLAttr.name == "xmlns") {
            if (this.parent.nameSpaces == null) {
                this.parent.nameSpaces = new Hashtable(20);
            }
            this.parent.nameSpaces.put("#default", ((String)object).intern());
        }
        xMLAttr.ownerDocument = (XMLDocument)this.parent.getOwnerDocument();
        xMLAttr.setNodeFlag(131072);
        xMLAttr.setNodeFlag(65536);
        if ((xMLAttr.ownerDocument.flags & 0x10000) == 65536) {
            xMLAttr.fireDOMMutationEvent("DOMNodeInserted", xMLAttr, this.parent, null, null, null, true, false, (short)2);
            xMLAttr.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
        }
    }

    XMLAttrList cloneList(boolean bl) {
        return this.clone_List(bl, (XMLDocument)this.parent.getOwnerDocument());
    }

    XMLAttrList clone_List(boolean bl, XMLDocument xMLDocument) {
        XMLAttrList xMLAttrList = new XMLAttrList();
        xMLAttrList.parent = this.parent;
        XMLAttr xMLAttr = this.firstAttr;
        while (xMLAttr != null) {
            XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.clone_Node(bl, xMLDocument);
            xMLAttrList.add(xMLAttr2);
            if (xMLAttr.isNodeFlag(65536)) {
                xMLAttr2.setNodeFlag(65536);
            } else {
                xMLAttr2.resetNodeFlag(65536);
            }
            xMLAttr = xMLAttr.getNextAttribute();
        }
        return xMLAttrList;
    }

    public int getLength() {
        int n = 0;
        XMLNode xMLNode = this.firstAttr;
        while (xMLNode != null) {
            ++n;
            xMLNode = xMLNode.nextNode;
        }
        return n;
    }

    public Node getNamedItem(String string) {
        XMLAttr xMLAttr = this.firstAttr;
        while (xMLAttr != null) {
            if (xMLAttr.getNodeName().equals(string)) {
                return xMLAttr;
            }
            xMLAttr = xMLAttr.getNextAttribute();
        }
        return null;
    }

    Node getNamedItem(String string, String string2) {
        XMLAttr xMLAttr = this.firstAttr;
        while (xMLAttr != null) {
            if (xMLAttr.checkNamespace(string, string2)) {
                return xMLAttr;
            }
            xMLAttr = xMLAttr.getNextAttribute();
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        if (string == null) {
            string = "";
        }
        XMLAttr xMLAttr = this.firstAttr;
        while (xMLAttr != null) {
            if (xMLAttr.checkNamespace(string2.intern(), string.intern())) {
                return xMLAttr;
            }
            xMLAttr = (XMLAttr)xMLAttr.nextNode;
        }
        return null;
    }

    boolean isMember(XMLAttr xMLAttr) {
        return this.getNamedItem(xMLAttr.getName()) != null;
    }

    public Node item(int n) {
        XMLAttr xMLAttr = this.firstAttr;
        while (xMLAttr != null) {
            if (n == 0) {
                return xMLAttr;
            }
            --n;
            xMLAttr = xMLAttr.getNextAttribute();
        }
        return null;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        XMLAttr xMLAttr = this.firstAttr;
        while (xMLAttr != null) {
            xMLAttr.print(xMLOutputStream, bl);
            xMLAttr = (XMLAttr)xMLAttr.nextNode;
        }
    }

    void put(String string, String string2) {
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItem(string);
        if (xMLAttr != null) {
            if (xMLAttr.prefix == "xmlns") {
                if (this.parent.nameSpaces == null) {
                    this.parent.nameSpaces = new Hashtable(20);
                }
                this.parent.nameSpaces.put(xMLAttr.name, string2.intern());
            }
            if (xMLAttr.name == "xmlns") {
                if (this.parent.nameSpaces == null) {
                    this.parent.nameSpaces = new Hashtable(20);
                }
                this.parent.nameSpaces.put("#default", string2.intern());
            }
            xMLAttr.setNodeValue(string2);
        } else {
            XMLDocument xMLDocument = (XMLDocument)this.parent.getOwnerDocument();
            if (xMLDocument != null) {
                xMLAttr = (XMLAttr)xMLDocument.createAttribute(string);
                xMLAttr.setNodeValue(string2);
            } else {
                xMLAttr = new XMLAttr(string, string2);
            }
            if (xMLAttr != null) {
                this.add(xMLAttr);
            }
        }
    }

    void put(String string, String string2, String string3, String string4) {
        XMLAttr xMLAttr;
        if (string == null) {
            string = "";
        }
        if ((xMLAttr = (XMLAttr)this.getNamedItemNS(string, string2)) != null) {
            if (xMLAttr.prefix == "xmlns") {
                if (this.parent.nameSpaces == null) {
                    this.parent.nameSpaces = new Hashtable(20);
                }
                this.parent.nameSpaces.put(xMLAttr.name, string4.intern());
            }
            if (xMLAttr.name == "xmlns") {
                if (this.parent.nameSpaces == null) {
                    this.parent.nameSpaces = new Hashtable(20);
                }
                this.parent.nameSpaces.put("#default", string4.intern());
            }
            xMLAttr.setNodeValue(string4);
        } else {
            XMLDocument xMLDocument = (XMLDocument)this.parent.getOwnerDocument();
            if (xMLDocument != null) {
                String string5 = string2;
                if (string3 != "") {
                    string5 = String.valueOf(string3) + ":" + string2;
                }
                xMLAttr = (XMLAttr)xMLDocument.createAttributeNS(string, string5);
                xMLAttr.setNodeValue(string4);
            } else {
                xMLAttr = new XMLAttr(string2, string3, string, string4);
            }
            if (xMLAttr != null) {
                this.add(xMLAttr);
            }
        }
    }

    private void remove(XMLAttr xMLAttr) {
        if ((xMLAttr.ownerDocument.flags & 0x10000) == 65536) {
            xMLAttr.fireDOMMutationEvent("DOMNodeRemoved", xMLAttr, this.parent, null, null, null, true, false, (short)3);
            xMLAttr.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
        }
        if (xMLAttr == this.firstAttr) {
            this.firstAttr = (XMLAttr)xMLAttr.nextNode;
            if (this.firstAttr != null) {
                this.firstAttr.prevNode = null;
            }
        } else {
            xMLAttr.prevNode.nextNode = xMLAttr.nextNode;
            if (xMLAttr.nextNode != null) {
                xMLAttr.nextNode.prevNode = xMLAttr.prevNode;
            }
        }
        xMLAttr.nextNode = null;
        xMLAttr.prevNode = null;
        xMLAttr.resetNodeFlag(65536);
        xMLAttr.resetNodeFlag(131072);
        xMLAttr.parent = null;
        if (xMLAttr.prefix == "xmlns") {
            this.parent.nameSpaces.remove(xMLAttr.name);
        }
        if (xMLAttr.name == "xmlns") {
            this.parent.nameSpaces.remove("#default");
        }
    }

    Node removeItem(Attr attr) {
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItem(attr.getNodeName());
        this.parent.checkReadOnly();
        if (xMLAttr != null && xMLAttr == (XMLAttr)attr) {
            if (!this.setAttributeDefault(xMLAttr)) {
                this.remove(xMLAttr);
            }
        } else {
            throw new XMLDOMException(8, this.parent.getXMLError());
        }
        xMLAttr.resetNodeFlag(65536);
        return xMLAttr;
    }

    Node removeItemNS(Attr attr) throws DOMException {
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName());
        this.parent.checkReadOnly();
        if (xMLAttr != null && xMLAttr == (XMLAttr)attr) {
            if (!this.setAttributeDefault(xMLAttr)) {
                this.remove(xMLAttr);
            }
        } else {
            throw new XMLDOMException(8, this.parent.getXMLError());
        }
        xMLAttr.resetNodeFlag(65536);
        return xMLAttr;
    }

    public Node removeNamedItem(String string) throws DOMException {
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItem(string);
        if (xMLAttr != null) {
            if (!this.setAttributeDefault(xMLAttr)) {
                this.remove(xMLAttr);
            }
        } else {
            throw new XMLDOMException(8, this.parent.getXMLError());
        }
        xMLAttr.resetNodeFlag(65536);
        return xMLAttr;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        if (string == null) {
            string = "";
        }
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItemNS(string.intern(), string2.intern());
        this.parent.checkReadOnly();
        if (xMLAttr != null) {
            if (!this.setAttributeDefault(xMLAttr)) {
                this.remove(xMLAttr);
            }
        } else {
            throw new XMLDOMException(8, this.parent.getXMLError());
        }
        xMLAttr.resetNodeFlag(65536);
        return xMLAttr;
    }

    boolean setAttributeDefault(XMLAttr xMLAttr) {
        if (this.parent != null) {
            XMLNode xMLNode;
            ElementDecl elementDecl = null;
            XMLDocument xMLDocument = (XMLDocument)this.parent.getOwnerDocument();
            if (xMLDocument != null && (xMLNode = (DTD)xMLDocument.getDoctype()) != null) {
                elementDecl = xMLNode.findElementDecl(this.parent.tag);
            }
            if (elementDecl != null && (xMLNode = elementDecl.findAttrDecl(xMLAttr.getName())) != null && ((AttrDecl)xMLNode).def != null) {
                XMLAttr xMLAttr2 = new XMLAttr(xMLAttr.getLocalName(), xMLAttr.getPrefix(), xMLAttr.getNamespaceURI(), null);
                xMLAttr2.nextNode = xMLAttr.nextNode;
                xMLAttr2.prevNode = xMLAttr.prevNode;
                if (xMLAttr == this.firstAttr) {
                    this.firstAttr = xMLAttr2;
                    if (this.firstAttr != null) {
                        this.firstAttr.prevNode = null;
                    }
                } else {
                    xMLAttr.prevNode.nextNode = xMLAttr2;
                    if (xMLAttr.nextNode != null) {
                        xMLAttr.nextNode.prevNode = xMLAttr2;
                    }
                }
                xMLAttr.nextNode = null;
                xMLAttr.prevNode = null;
                xMLAttr2.setNodeValue(((AttrDecl)xMLNode).def);
                xMLAttr2.resetNodeFlag(65536);
                xMLAttr2.setNodeFlag(131072);
                xMLAttr2.parent = this.parent;
                xMLAttr.resetNodeFlag(65536);
                xMLAttr.resetNodeFlag(131072);
                xMLAttr.parent = null;
                if (xMLAttr2.prefix == "xmlns") {
                    if (this.parent.nameSpaces == null) {
                        this.parent.nameSpaces = new Hashtable(20);
                    }
                    this.parent.nameSpaces.put(xMLAttr2.name, ((AttrDecl)xMLNode).def);
                }
                if (xMLAttr2.name == "xmlns") {
                    if (this.parent.nameSpaces == null) {
                        this.parent.nameSpaces = new Hashtable(20);
                    }
                    this.parent.nameSpaces.put("#default", ((AttrDecl)xMLNode).def);
                }
                return true;
            }
        }
        return false;
    }

    public Node setNamedItem(Node node) throws DOMException {
        XMLAttr xMLAttr = (XMLAttr)node;
        if (xMLAttr.isNodeFlag(131072) && xMLAttr.parent != this.parent) {
            throw new XMLDOMException(10, this.parent.getXMLError());
        }
        this.parent.checkDocument(node);
        this.parent.checkReadOnly();
        XMLAttr xMLAttr2 = (XMLAttr)this.getNamedItem(xMLAttr.getName());
        if (xMLAttr2 != null) {
            this.remove(xMLAttr2);
        }
        this.add(xMLAttr);
        return xMLAttr2;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        XMLAttr xMLAttr = (XMLAttr)node;
        if (xMLAttr.isNodeFlag(131072) && xMLAttr.parent != this.parent) {
            throw new XMLDOMException(10, this.parent.getXMLError());
        }
        this.parent.checkDocument(node);
        this.parent.checkReadOnly();
        XMLAttr xMLAttr2 = (XMLAttr)this.getNamedItemNS(xMLAttr.getNamespaceURI(), xMLAttr.getLocalName());
        if (xMLAttr2 != null) {
            this.remove(xMLAttr2);
        }
        this.add(xMLAttr);
        return xMLAttr2;
    }
}

