/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class XMLDeclPI
extends XMLPI
implements Externalizable {
    boolean textDecl;
    String encoding;
    String standalone;
    String version;
    static String defaultEncoding = "UTF-8";
    static String defaultVersion = "1.0";
    static String defaultStandalone = "no";

    public XMLDeclPI() {
        super("xml");
    }

    public XMLDeclPI(String string, String string2, String string3, boolean bl) {
        super("xml");
        this.textDecl = bl;
        this.version = string;
        this.encoding = string2;
        this.standalone = string3;
    }

    boolean checkTypeNSName(int n, String string, String string2) {
        return false;
    }

    public Node cloneNode(boolean bl) {
        return this.clone_Node(bl, this.ownerDocument);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        XMLDeclPI xMLDeclPI = new XMLDeclPI(this.version, this.encoding, this.standalone, this.textDecl);
        xMLDeclPI.ownerDocument = xMLDocument;
        return xMLDeclPI;
    }

    public String getData() throws DOMException {
        if (this.text != null) {
            return this.text;
        }
        if (!this.textDecl) {
            this.text = "version = '" + this.version + "'";
            if (this.encoding != null) {
                this.text = String.valueOf(this.text) + " " + "encoding" + " = '" + this.encoding + "'";
            }
            if (this.standalone != null) {
                this.text = String.valueOf(this.text) + " " + "standalone" + " = '" + this.standalone + "'";
            }
        } else {
            if (this.version != null) {
                this.text = "version = '" + this.version + "' ";
            }
            this.text = String.valueOf(this.text) + "encoding" + " = '" + this.encoding + "'";
        }
        return this.text;
    }

    public final String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return defaultEncoding;
    }

    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    public final String getStandalone() {
        if (this.standalone != null) {
            return this.standalone;
        }
        return defaultStandalone;
    }

    public final String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return defaultVersion;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(64)) {
            xMLOutputStream.writeIndent();
            xMLOutputStream.writeChars("<?");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " " + this.getData());
            xMLOutputStream.writeChars("?>");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 16) {
            throw new IOException("Error in reading serialized stream  corresponding to PI node");
        }
        this.setVersion(xMLObjectInput.readUTF());
        this.setEncoding(xMLObjectInput.readUTF());
        this.setStandalone(xMLObjectInput.readUTF());
    }

    public final void setEncoding(String string) {
        this.text = null;
        this.encoding = string;
    }

    public final boolean setStandalone(String string) {
        this.text = null;
        this.standalone = string;
        return string != null && string.equalsIgnoreCase("yes");
    }

    public final void setVersion(String string) {
        this.text = null;
        this.version = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(16);
        xMLObjectOutput.writeUTF(this.getVersion());
        xMLObjectOutput.writeUTF(this.getEncoding());
        xMLObjectOutput.writeUTF(this.getStandalone());
    }
}

