/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDOMEvent;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDOMMutationEvent;
import oracle.xml.parser.v2.XMLDebugInfo;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeIterator;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.parser.v2.XMLRange;
import oracle.xml.parser.v2.XMLRangeEvent;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLTraversalEvent;
import oracle.xml.parser.v2.XMLTreeWalker;
import oracle.xml.util.HashInt;
import oracle.xml.util.NodeContext;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLDocument
extends XMLElement
implements Document,
DocumentTraversal,
Externalizable,
CXMLConstants {
    XMLError err;
    XMLDeclPI xmlDecl;
    XMLDebugInfo debugInfo;
    String sysId;
    NodeContext nodectx;
    HashInt nodeProperties;
    Hashtable ids;
    DOMLocator locator;
    NodeFactory factory = new NodeFactory();
    static XMLDocument nullDocument = new XMLDocument();
    static DOMImplementation domImpl = new XMLDOMImplementation();
    static final int AUTO_EVENTS = 65536;
    static final int RANGE_EVENTS = 131072;
    static final int TRAVERSAL_EVENTS = 262144;
    static final int PARTIAL_DOM = 262144;
    static final int PARSING = 524288;
    static final int DOC_ORDERED = 0x100000;

    public XMLDocument() {
        super("#document");
        this.ownerDocument = this;
        this.err = new XMLError();
    }

    public void addID(String string, XMLElement xMLElement) {
        if (this.ids == null) {
            this.ids = new Hashtable(20);
        }
        this.ids.put(string, xMLElement);
    }

    public Node adoptNode(Node node) throws DOMException {
        short s = node.getNodeType();
        if (s == 9 || s == 10) {
            return null;
        }
        if (s != 2) {
            Node node2 = node.getParentNode();
            if (node2 != null) {
                node = node2.removeChild(node);
            }
        } else {
            Element element = ((Attr)node).getOwnerElement();
            node = element.removeAttributeNode((Attr)node);
            ((XMLAttr)node).setNodeFlag(65536);
        }
        this.setOwnerDocument((XMLNode)node, this);
        return node;
    }

    public Node appendChild(Node node) throws DOMException {
        short s = node.getNodeType();
        if (s == 1) {
            if (this.getDocumentElement() != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            return (XMLElement)super.appendChild(node);
        }
        if (s == 7 && node.getNodeName().equals("xml")) {
            if (this.xmlDecl != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            this.xmlDecl = (XMLDeclPI)super.appendChild(node);
            return this.xmlDecl;
        }
        if (s == 10) {
            if (this.getDoctype() != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            return (DTD)super.appendChild(node);
        }
        XMLNode xMLNode = (XMLNode)super.appendChild(node);
        return xMLNode;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    boolean checkTypeNSName(int n, String string, String string2) {
        return false;
    }

    public Node cloneNode(boolean bl) {
        XMLDocument xMLDocument = this.factory.createDocument();
        xMLDocument.factory = this.factory;
        xMLDocument.debugInfo = this.debugInfo;
        if (!bl || !this.hasChildNodes()) {
            return xMLDocument;
        }
        Node node = this.getFirstChild();
        while (node != null) {
            xMLDocument.appendChild(((XMLNode)node).clone_Node(bl, xMLDocument));
            node = node.getNextSibling();
        }
        return xMLDocument;
    }

    public Attr createAttribute(String string) throws DOMException {
        XMLUtil.validateName(string);
        XMLAttr xMLAttr = this.factory.createAttribute(string, "");
        xMLAttr.ownerDocument = this;
        return xMLAttr;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            string = "";
        }
        XMLUtil.validateQualifiedName(string2);
        XMLAttr xMLAttr = this.factory.createAttribute(XMLUtil.getLocalName(string2), XMLUtil.getPrefix(string2), string, "");
        xMLAttr.parent = null;
        xMLAttr.ownerDocument = this;
        return xMLAttr;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        XMLCDATA xMLCDATA = this.factory.createCDATASection(string);
        xMLCDATA.ownerDocument = this;
        return xMLCDATA;
    }

    public Comment createComment(String string) {
        XMLComment xMLComment = this.factory.createComment(string);
        xMLComment.ownerDocument = this;
        return xMLComment;
    }

    public DocumentFragment createDocumentFragment() {
        XMLDocumentFragment xMLDocumentFragment = this.factory.createDocumentFragment();
        xMLDocumentFragment.ownerDocument = this;
        return xMLDocumentFragment;
    }

    public Element createElement(String string) throws DOMException {
        XMLUtil.validateName(string);
        XMLElement xMLElement = this.factory.createElement(string);
        xMLElement.ownerDocument = this;
        return xMLElement;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if (string == null) {
            string = "";
        }
        XMLUtil.validateQualifiedName(string2);
        XMLElement xMLElement = new XMLElement(XMLUtil.getLocalName(string2), XMLUtil.getPrefix(string2), string);
        xMLElement.parent = null;
        xMLElement.ownerDocument = this;
        if (xMLElement.nameSpaces == null) {
            xMLElement.nameSpaces = new Hashtable(20);
        }
        xMLElement.nameSpaces.put(xMLElement.getPrefix(), string);
        return xMLElement;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        XMLUtil.validateName(string);
        XMLEntityReference xMLEntityReference = this.factory.createEntityReference(string);
        xMLEntityReference.ownerDocument = this;
        return xMLEntityReference;
    }

    public Event createEvent(String string) {
        return new XMLDOMEvent(string);
    }

    public MutationEvent createMutationEvent(String string) {
        return new XMLDOMMutationEvent(string);
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (node == null) {
            throw new XMLDOMException(9);
        }
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator((XMLNode)node, n, nodeFilter, bl);
        this.setNodeFlag(262144);
        this.addEventListener("TRAVERSAL_DELETE_EVENT", xMLNodeIterator, false);
        this.addEventListener("TRAVERSAL_REPLACE_EVENT", xMLNodeIterator, false);
        return xMLNodeIterator;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (string.toLowerCase().startsWith("xml") && !string.equals("xml-stylesheet")) {
            throw new XMLDOMException(5, this.getXMLError());
        }
        XMLUtil.validateName(string);
        XMLPI xMLPI = this.factory.createProcessingInstruction(string, string2);
        xMLPI.ownerDocument = this;
        return xMLPI;
    }

    public Range createRange() {
        XMLRange xMLRange = new XMLRange();
        xMLRange.init(this, this, 0, 0, this);
        this.setNodeFlag(131072);
        this.addEventListener("RANGE_SETTEXT_EVENT", xMLRange, false);
        this.addEventListener("RANGE_INSERTTEXT_EVENT", xMLRange, false);
        this.addEventListener("RANGE_DELETETEXT_EVENT", xMLRange, false);
        this.addEventListener("RANGE_INSERT_EVENT", xMLRange, false);
        this.addEventListener("RANGE_DELETE_EVENT", xMLRange, false);
        this.addEventListener("RANGE_REPLACE_EVENT", xMLRange, false);
        return xMLRange;
    }

    public Event createRangeEvent(String string) {
        return new XMLRangeEvent(string);
    }

    public Text createTextNode(String string) {
        XMLText xMLText = this.factory.createTextNode(string);
        xMLText.ownerDocument = this;
        return xMLText;
    }

    public Event createTraversalEvent(String string) {
        return new XMLTraversalEvent(string);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (node == null) {
            throw new XMLDOMException(9);
        }
        return new XMLTreeWalker((XMLNode)node, n, nodeFilter, bl);
    }

    public Vector expectedElements(Element element) {
        DTD dTD = (DTD)this.getDoctype();
        if (dTD == null) {
            return null;
        }
        return ((XMLElement)element).expectedElements(dTD);
    }

    public int getColumnNumber() {
        return this.getColumnNumber(0);
    }

    int getColumnNumber(int n) {
        if (this.debugInfo != null) {
            return this.debugInfo.getColumnNumber(n);
        }
        return 0;
    }

    public boolean getDebugMode() {
        return this.debugInfo != null;
    }

    public DocumentType getDoctype() {
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null && !(xMLNode instanceof DTD)) {
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return (DocumentType)((Object)xMLNode);
    }

    public Element getDocumentElement() {
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null && !(xMLNode instanceof XMLElement)) {
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return (Element)((Object)xMLNode);
    }

    public Element getElementById(String string) {
        if (this.ids == null) {
            return null;
        }
        return (XMLElement)this.ids.get(string);
    }

    public NodeList getElementsByTagName(String string) {
        XMLElement xMLElement = (XMLElement)this.getDocumentElement();
        if (xMLElement == null) {
            return null;
        }
        XMLNodeList xMLNodeList = new XMLNodeList();
        xMLNodeList = (XMLNodeList)xMLElement.getElementsByTagName(string.intern(), xMLNodeList, xMLElement, null);
        return xMLNodeList;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        XMLElement xMLElement;
        if (string == null) {
            string = "";
        }
        if ((xMLElement = (XMLElement)this.getDocumentElement()) == null) {
            return null;
        }
        XMLNodeList xMLNodeList = new XMLNodeList();
        xMLNodeList = (XMLNodeList)xMLElement.getElementsByTagName(string2.intern(), xMLNodeList, xMLElement, string.intern());
        return xMLNodeList;
    }

    public final String getEncoding() {
        if (this.xmlDecl != null) {
            return this.xmlDecl.getEncoding();
        }
        return "UTF-8";
    }

    public XMLElement getIDElement(String string) {
        return (XMLElement)this.getElementById(string);
    }

    public Hashtable getIDHashtable() {
        return this.ids;
    }

    public DOMImplementation getImplementation() {
        return domImpl;
    }

    public int getLineNumber() {
        return this.getLineNumber(0);
    }

    int getLineNumber(int n) {
        if (this.debugInfo != null) {
            return this.debugInfo.getLineNumber(n);
        }
        return 0;
    }

    public short getNodeType() {
        return 9;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public final String getStandalone() {
        if (this.xmlDecl != null) {
            return this.xmlDecl.getStandalone();
        }
        return "no";
    }

    public String getSystemId() {
        return this.getSystemId(0);
    }

    String getSystemId(int n) {
        if (this.debugInfo != null) {
            return this.debugInfo.getSystemId(n);
        }
        return this.sysId;
    }

    public String getText() {
        XMLElement xMLElement = (XMLElement)this.getDocumentElement();
        if (xMLElement != null) {
            return xMLElement.getText();
        }
        return "";
    }

    public final String getVersion() {
        if (this.xmlDecl != null) {
            return this.xmlDecl.getVersion();
        }
        return "1.0";
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        if (node.getNodeType() == 9 || node.getNodeType() == 10) {
            return null;
        }
        return ((XMLNode)node).clone_Node(bl, this);
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (node2 != null && (node2 == this.xmlDecl || node2 instanceof DTD && s == 1)) {
            throw new XMLDOMException(3, this.getXMLError());
        }
        if (s == 1) {
            if (this.getDocumentElement() != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            return (XMLElement)super.insertBefore(node, node2);
        }
        if (s == 7 && node.getNodeName().equals("xml")) {
            if (this.xmlDecl != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            this.xmlDecl = (XMLDeclPI)super.insertBefore(node, node2);
            return this.xmlDecl;
        }
        if (s == 10) {
            if (this.getDoctype() != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            return (DTD)super.insertBefore(node, node2);
        }
        return super.insertBefore(node, node2);
    }

    boolean isDocOrdered() {
        return this.isNodeFlag(0x100000);
    }

    public void print(OutputStream outputStream) throws IOException {
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(outputStream);
        this.print(xMLPrintDriver);
        xMLPrintDriver.flush();
    }

    public void print(OutputStream outputStream, String string) throws IOException {
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(outputStream);
        this.print(xMLPrintDriver, string);
        xMLPrintDriver.flush();
    }

    public void print(PrintWriter printWriter) throws IOException {
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(printWriter);
        this.print(xMLPrintDriver);
        xMLPrintDriver.flush();
    }

    public void print(PrintDriver printDriver) throws IOException {
        printDriver.setEncoding(this.getEncoding());
        printDriver.printChildNodes(this);
    }

    void print(PrintDriver printDriver, String string) throws IOException {
        String string2 = this.getEncoding();
        printDriver.setEncoding(string);
        try {
            this.setEncoding(string);
            printDriver.printChildNodes(this);
        }
        finally {
            Object var5_4 = null;
            this.setEncoding(string2);
        }
    }

    public void printExternalDTD(OutputStream outputStream) throws IOException {
        DTD dTD = (DTD)this.getDoctype();
        if (dTD != null) {
            XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
            xMLOutputStream.err = this.err;
            xMLOutputStream.setEncoding(this.getEncoding(), true, true);
            dTD.print(xMLOutputStream, true);
            xMLOutputStream.finalFlush();
        }
    }

    public void printExternalDTD(OutputStream outputStream, String string) throws IOException {
        DTD dTD = (DTD)this.getDoctype();
        if (dTD != null) {
            XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
            xMLOutputStream.err = this.err;
            xMLOutputStream.setEncoding(string, true, true);
            dTD.print(xMLOutputStream, true);
            xMLOutputStream.finalFlush();
        }
    }

    public void printExternalDTD(PrintWriter printWriter) throws IOException {
        DTD dTD = (DTD)this.getDoctype();
        if (dTD != null) {
            XMLOutputStream xMLOutputStream = new XMLOutputStream(printWriter);
            xMLOutputStream.err = this.err;
            dTD.print(xMLOutputStream, true);
            xMLOutputStream.finalFlush();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
        this.readChildNodes(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        char[] cArray = new char[4];
        int n = 0;
        while (n < 4) {
            cArray[n] = xMLObjectInput.readChar();
            ++n;
        }
        if (cArray[0] != 'c' && cArray[1] != 'x' && cArray[2] != 'm' && cArray[3] != 'l') {
            throw new IOException("Error: The binary stream is not a compressed serialized stream");
        }
        byte by = xMLObjectInput.readByte();
        if (by > 1) {
            throw new IOException("Error: The binary stream version is not compatiblle with this release of parser.");
        }
        this.ownerDocument = this;
        String string = xMLObjectInput.readUTF();
        if (!string.equals("null")) {
            this.sysId = string;
        }
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.xmlDecl == node) {
            this.xmlDecl = null;
        }
        return super.removeChild(node);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node2 == null) {
            throw new XMLDOMException(8, this.getXMLError());
        }
        short s = node.getNodeType();
        if (s == 1) {
            XMLElement xMLElement = (XMLElement)this.getDocumentElement();
            if (xMLElement != null && node2 != xMLElement) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            node2 = super.replaceChild(node, node2);
        } else if (s == 7 && node.getNodeName().equals("xml")) {
            if (this.xmlDecl != null && node2 != this.xmlDecl) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            node2 = super.replaceChild(node, node2);
            this.xmlDecl = (XMLDeclPI)node;
        } else if (s == 10) {
            XMLNode xMLNode = (XMLNode)((Object)this.getDoctype());
            if (xMLNode != null && node2 != xMLNode) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            node2 = super.replaceChild(node, node2);
        } else {
            node2 = super.replaceChild(node, node2);
        }
        if (node2 != node && this.xmlDecl == node2) {
            this.xmlDecl = null;
        }
        return node2;
    }

    public void reportSAXEvents(ContentHandler contentHandler) throws SAXException {
        this.locator = new DOMLocator();
        this.locator.setCurrentNode(this);
        contentHandler.setDocumentLocator(this.locator);
        contentHandler.startDocument();
        this.reportChildSAXEvents(contentHandler);
        contentHandler.endDocument();
    }

    void setDebugInfo(int n, int n2, int n3, String string) {
        if (this.debugInfo != null) {
            this.debugInfo.setDebugInfo(n, n2, n3, string);
        } else if (n == 0) {
            this.sysId = string;
        }
    }

    void setDebugMode(boolean bl) {
        this.debugInfo = bl ? new XMLDebugInfo() : null;
    }

    void setDocOrdered(boolean bl) {
        if (bl) {
            this.setNodeFlag(0x100000);
        } else {
            this.resetNodeFlag(0x100000);
        }
    }

    public void setDoctype(String string, String string2, String string3) {
        DTD dTD;
        boolean bl = false;
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        if (xMLNode != null && xMLNode instanceof XMLDeclPI) {
            bl = true;
        }
        if ((dTD = (DTD)this.getDoctype()) == null) {
            dTD = !bl ? (DTD)this.insertBefore(new DTD(), xMLNode) : (DTD)this.insertBefore(new DTD(), xMLNode.getNextSibling());
        }
        dTD.sysID = string2;
        dTD.pubID = string3;
        dTD.tag = string;
    }

    public final void setEncoding(String string) {
        if (this.xmlDecl == null) {
            XMLDeclPI xMLDeclPI = new XMLDeclPI("1.0", string, null, false);
            xMLDeclPI.ownerDocument = this;
            this.insertBefore(xMLDeclPI, this.getFirstChild());
        }
        this.xmlDecl.setEncoding(string);
    }

    public final void setLocale(Locale locale) {
        if (this.err == null) {
            this.err = new XMLError();
        }
        this.err.setLocale(locale);
    }

    public void setNodeContext(NodeContext nodeContext) {
        this.nodectx = nodeContext;
    }

    public void setParsedDoctype(String string, String string2, String string3) throws DOMException {
        boolean bl = false;
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        if (xMLNode != null && xMLNode instanceof XMLDeclPI) {
            bl = true;
        }
        try {
            DTD dTD = (DTD)this.getDoctype();
            DOMParser dOMParser = new DOMParser();
            dOMParser.parseDTD(string2, string);
            DTD dTD2 = dOMParser.getDoctype();
            dTD = dTD == null ? (!bl ? (DTD)this.insertBefore(dTD2, xMLNode) : (DTD)this.insertBefore(dTD2, xMLNode.getNextSibling())) : (DTD)this.replaceChild(dTD2, dTD);
            dTD.sysID = string2;
            dTD.pubID = string3;
            dTD.tag = string;
        }
        catch (Exception exception) {
            throw new XMLDOMException(0, exception.getMessage());
        }
    }

    public final void setStandalone(String string) {
        if (this.xmlDecl == null) {
            XMLDeclPI xMLDeclPI = new XMLDeclPI("1.0", null, string, false);
            xMLDeclPI.ownerDocument = this;
            this.insertBefore(xMLDeclPI, this.getFirstChild());
        }
        this.xmlDecl.setStandalone(string);
    }

    public final void setVersion(String string) {
        if (this.xmlDecl == null) {
            XMLDeclPI xMLDeclPI = new XMLDeclPI(string, null, null, false);
            xMLDeclPI.ownerDocument = this;
            this.insertBefore(xMLDeclPI, this.getFirstChild());
        }
        this.xmlDecl.setVersion(string);
    }

    public boolean validateElementContent(Element element) {
        DTD dTD = (DTD)this.getDoctype();
        if (dTD == null) {
            return true;
        }
        return ((XMLElement)element).validateContent(dTD);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    public void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        int n = 0;
        while (n < 4) {
            xMLObjectOutput.writeChar(CXMLConstants.cXMLFILE[n]);
            ++n;
        }
        xMLObjectOutput.writeByte(1);
        if (this.sysId != null) {
            xMLObjectOutput.writeUTF(this.sysId);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLNode.writeExternal(xMLObjectOutput, cXMLContext);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        xMLObjectOutput.writeByte(22);
    }
}

