/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLElement
extends XMLNSNode
implements Element,
NSName,
NSResolver,
Externalizable,
CXMLConstants {
    XMLAttrList attrlist;
    Hashtable nameSpaces = null;
    static final int MIXED_CONTENT = 65536;
    static final int ELEMENT_CONTENT = 131072;

    public XMLElement() {
    }

    public XMLElement(String string) {
        super(string.intern());
        this.name = this.tag;
    }

    public XMLElement(String string, String string2, String string3) {
        super(string);
        if (string3 != null) {
            string3 = string3.intern();
        }
        this.name = string.intern();
        this.prefix = string2;
        this.namespace = string3;
        if (string2 != "") {
            this.tag = String.valueOf(string2) + ":" + string;
            this.tag = this.tag.intern();
        } else {
            this.tag = this.name;
        }
    }

    public XMLElement(String string, String string2, String string3, String string4) {
        super(string3);
        if (string4 != null) {
            string4 = string4.intern();
        }
        this.name = string;
        this.prefix = string2;
        this.tag = string3;
        this.namespace = string4;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    boolean checkNamespace(String string, String string2) {
        if (string2 == null) {
            return string == "*" || string == this.name;
        }
        if (string2 == "*") {
            return string == "*" || string == this.name;
        }
        return (string == "*" || string == this.name) && string2 == this.namespace;
    }

    boolean checkTypeNSName(int n, String string, String string2) {
        return !(n != 1 || string != null && string != this.namespace || string2 != null && string2 != this.name);
    }

    public Node cloneNode(boolean bl) {
        return this.clone_Node(bl, this.ownerDocument);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        XMLElement xMLElement = (XMLElement)super.clone_Node(bl, xMLDocument);
        if (this.attrlist != null) {
            this.attrlist.parent = xMLElement;
            xMLElement.attrlist = this.attrlist.clone_List(bl, xMLDocument);
            this.attrlist.parent = this;
        }
        xMLElement.nameSpaces = this.nameSpaces;
        return xMLElement;
    }

    Vector expectedElements(DTD dTD) {
        ElementDecl elementDecl = dTD.findElementDecl(this.tag);
        if (elementDecl == null) {
            return null;
        }
        return elementDecl.expectedElements(this);
    }

    Hashtable getAllNamespaceAttrs() {
        Hashtable hashtable = null;
        if (this.parent != null && this.parent.getNodeType() == 1) {
            hashtable = ((XMLElement)this.parent).getAllNamespaceAttrs();
        }
        if (this.nameSpaces != null) {
            if (hashtable == null) {
                hashtable = new Hashtable(20);
            }
            Enumeration enumeration = this.nameSpaces.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("#default")) continue;
                hashtable.put(string, this.nameSpaces.get(string));
            }
        }
        return hashtable;
    }

    Hashtable getAllNamespaceAttrs(String string) {
        Hashtable hashtable = null;
        if (this.parent != null && this.parent.getNodeType() == 1) {
            hashtable = ((XMLElement)this.parent).getAllNamespaceAttrs(string);
        }
        if (this.nameSpaces != null) {
            if (hashtable == null) {
                hashtable = new Hashtable(20);
            }
            Enumeration enumeration = this.nameSpaces.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this.nameSpaces.get(string2);
                if (string3.equals(string) || string2.equals("#default")) continue;
                hashtable.put(string2, this.nameSpaces.get(string2));
            }
            if (hashtable.isEmpty()) {
                return null;
            }
        }
        return hashtable;
    }

    public String getAttribute(String string) {
        Attr attr = this.getAttributeNode(string);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public String getAttributeNS(String string, String string2) {
        Attr attr = this.getAttributeNodeNS(string = string == null ? "" : string.intern(), string2 = string2.intern());
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public Attr getAttributeNode(String string) {
        string = string.intern();
        return this.attrlist != null ? (Attr)this.attrlist.getNamedItem(string) : null;
    }

    public Attr getAttributeNode(String string, String string2) {
        string = string.intern();
        if (string2 != null) {
            string2 = string2.intern();
        }
        if (this.attrlist != null) {
            return (Attr)this.attrlist.getNamedItem(string, string2);
        }
        return null;
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        string = string == null ? "" : string.intern();
        string2 = string2.intern();
        if (this.attrlist != null) {
            return (Attr)this.attrlist.getNamedItemNS(string, string2);
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        return this.attrlist;
    }

    public NodeList getChildrenByTagName(String string) {
        String string2 = string.intern();
        XMLNodeList xMLNodeList = new XMLNodeList();
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        boolean bl = string.equals("*");
        while (xMLNode != null) {
            String string3 = xMLNode.getNodeName().intern();
            if (bl || string3 == string2) {
                xMLNodeList.addNode(xMLNode);
            }
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLNodeList;
    }

    public NodeList getChildrenByTagName(String string, String string2) {
        String string3 = string.intern();
        XMLNodeList xMLNodeList = new XMLNodeList();
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        if (string2 != null) {
            string2 = string2.intern();
        }
        while (xMLNode != null) {
            if (xMLNode instanceof XMLElement) {
                if (((XMLElement)xMLNode).checkNamespace(string3, string2)) {
                    xMLNodeList.addNode(xMLNode);
                }
            } else if (xMLNode.getNodeName() == string3) {
                xMLNodeList.addNode(xMLNode);
            }
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLNodeList;
    }

    public NodeList getElementsByTagName(String string) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        if (string != null) {
            string = string.intern();
        }
        while (xMLNode != null) {
            if (xMLNode.getNodeType() == 1) {
                xMLNodeList = (XMLNodeList)this.getElementsByTagName(string, xMLNodeList, xMLNode, null);
            }
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLNodeList;
    }

    public NodeList getElementsByTagName(String string, String string2) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        string = string.intern();
        if (string2 != null) {
            string2 = string2.intern();
        }
        while (xMLNode != null) {
            if (xMLNode.getNodeType() == 1) {
                xMLNodeList = (XMLNodeList)this.getElementsByTagName(string, xMLNodeList, xMLNode, string2);
            }
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLNodeList;
    }

    NodeList getElementsByTagName(String string, XMLNodeList xMLNodeList, XMLNode xMLNode, String string2) {
        if (((XMLElement)xMLNode).checkNamespace(string, string2)) {
            xMLNodeList.addNode(xMLNode);
        }
        XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
        while (xMLNode2 != null) {
            if (xMLNode2.getNodeType() == 1) {
                xMLNodeList = (XMLNodeList)this.getElementsByTagName(string, xMLNodeList, xMLNode2, string2);
            }
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
        return xMLNodeList;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        string = string == null ? "" : string.intern();
        XMLNodeList xMLNodeList = new XMLNodeList();
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        string2 = string2.intern();
        while (xMLNode != null) {
            if (xMLNode.getNodeType() == 1) {
                xMLNodeList = (XMLNodeList)this.getElementsByTagName(string2, xMLNodeList, xMLNode, string);
            }
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLNodeList;
    }

    public String getExpandedName() {
        String string = this.namespace != null && !this.namespace.equals("") ? String.valueOf(this.namespace) + ":" + this.name : this.name;
        return string;
    }

    public XMLNode getFirstAttribute() {
        return this.attrlist != null ? this.attrlist.firstAttr : null;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    String getNamespacePrefix(String string) {
        if (this.nameSpaces != null) {
            Enumeration enumeration = this.nameSpaces.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!((String)this.nameSpaces.get(string2)).equals(string)) continue;
                return string2;
            }
        }
        if (this.parent != null && this.parent.getNodeType() == 1) {
            return ((XMLElement)this.parent).getNamespacePrefix(string);
        }
        return "";
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public short getNodeType() {
        return 1;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        return this.tag;
    }

    Node getSuccessor(XMLNode xMLNode, boolean bl) {
        XMLAttrList xMLAttrList = (XMLAttrList)this.getAttributes();
        XMLAttr xMLAttr = (XMLAttr)xMLAttrList.item(0);
        if (xMLAttr != null) {
            return xMLAttr;
        }
        return super.getSuccessor(xMLNode, bl);
    }

    public String getTagName() {
        return this.tag;
    }

    public boolean hasAttribute(String string) {
        if (this.attrlist == null) {
            return false;
        }
        return this.attrlist.getNamedItem(string = string.intern()) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        if (this.attrlist == null) {
            return false;
        }
        string = string == null ? "" : string.intern();
        string2 = string2.intern();
        return this.attrlist.getNamedItemNS(string, string2) != null;
    }

    public boolean hasAttributes() {
        if (this.attrlist != null) {
            return this.attrlist.getLength() != 0;
        }
        return false;
    }

    public void normalize() {
        XMLNode xMLNode = null;
        XMLNode xMLNode2 = (XMLNode)this.getFirstChild();
        while (xMLNode2 != null) {
            if (xMLNode2.getNodeType() == 3) {
                xMLNode = (XMLNode)xMLNode2.getNextSibling();
                while (xMLNode != null && xMLNode.getNodeType() == 3) {
                    xMLNode2.setNodeValue(String.valueOf(xMLNode2.getNodeValue()) + xMLNode.getNodeValue());
                    this.removeChild(xMLNode);
                    xMLNode = (XMLNode)xMLNode2.getNextSibling();
                }
                if (xMLNode == null) {
                    return;
                }
                xMLNode2 = xMLNode;
            }
            if (xMLNode2.getNodeType() == 1 && xMLNode2.hasChildNodes()) {
                ((XMLElement)xMLNode2).normalize();
            }
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        Object object;
        boolean bl2 = xMLOutputStream.mixed;
        int n = xMLOutputStream.outstyle;
        xMLOutputStream.writeIndent();
        xMLOutputStream.writeChars("<");
        xMLOutputStream.writeChars(this.tag);
        if (this.attrlist != null) {
            this.attrlist.print(xMLOutputStream, bl);
            object = this.getAttribute("xml:space");
            if (object != null && ((String)object).equals("preserve")) {
                xMLOutputStream.outstyle = XMLOutputStream.COMPACT;
            }
        }
        if (this.hasChildNodes()) {
            xMLOutputStream.writeChars(">");
            if (this.isNodeFlag(65536)) {
                xMLOutputStream.mixed = true;
            } else if (!this.isNodeFlag(131072)) {
                object = (XMLNode)this.getFirstChild();
                while (object != null) {
                    if (((XMLNode)object).getNodeType() == 3 || ((XMLNode)object).getNodeType() == 5) {
                        xMLOutputStream.mixed = true;
                        break;
                    }
                    object = (XMLNode)((XMLNode)object).getNextSibling();
                }
            }
            xMLOutputStream.writeNewLine();
            xMLOutputStream.addIndent(1);
            this.printChildren(xMLOutputStream, bl);
            xMLOutputStream.addIndent(-1);
            xMLOutputStream.writeIndent();
            xMLOutputStream.mixed = bl2;
            xMLOutputStream.writeChars("</" + this.tag + ">");
        } else {
            xMLOutputStream.writeChars("/>");
        }
        xMLOutputStream.writeNewLine();
        xMLOutputStream.outstyle = n;
        xMLOutputStream.flush();
    }

    void readAttrNodes(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        boolean bl = false;
        byte by = xMLObjectInput.peekByte();
        while (by == 25 || by == 24) {
            bl = true;
            XMLAttr xMLAttr = new XMLAttr();
            xMLAttr.readExternal(xMLObjectInput, cXMLContext);
            this.setAttributeNode(xMLAttr);
            by = xMLObjectInput.peekByte();
        }
        if (bl) {
            xMLObjectInput.readByte();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
        this.readChildNodes(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        boolean bl;
        int n;
        byte by;
        int n2;
        CXMLCodeSpace cXMLCodeSpace = cXMLContext.getNSCodeSpace();
        CXMLCodeSpace cXMLCodeSpace2 = cXMLContext.getElemCodeSpace();
        CXMLCodeSpace cXMLCodeSpace3 = cXMLContext.getPrefixCodeSpace();
        CXMLCodeSpace cXMLCodeSpace4 = cXMLContext.getAttrCodeSpace();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = xMLObjectInput.readByte();
        if (n3 != 28 && n3 != 15) {
            throw new IOException("Error in serialization of Element node");
        }
        if (n3 == 28) {
            this.name = CXMLConstants.names.create(xMLObjectInput.readUTF());
            bl2 = xMLObjectInput.readBoolean();
            bl3 = xMLObjectInput.readBoolean();
        } else if (n3 == 15) {
            n3 = xMLObjectInput.readByte();
            if ((n3 & 0x80) == 128) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                n2 = n3;
                by = xMLObjectInput.readByte();
                n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
            } else if ((n3 & 0xC0) == 192) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                n2 = xMLObjectInput.readByte();
                by = xMLObjectInput.readByte();
                n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
            } else {
                n = n3;
            }
            this.name = CXMLConstants.names.create(cXMLCodeSpace2.getElementFromToken(n));
        }
        if (bl2) {
            n3 = xMLObjectInput.readByte();
            if (n3 == 27) {
                this.namespace = CXMLConstants.names.create(xMLObjectInput.readUTF());
                bl = cXMLCodeSpace.addToken(this.namespace);
            } else {
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = xMLObjectInput.readByte();
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                this.namespace = CXMLConstants.names.create(cXMLCodeSpace.getElementFromToken(n));
            }
        }
        if (bl3) {
            n3 = xMLObjectInput.readByte();
            if (n3 == 26) {
                this.prefix = CXMLConstants.names.create(xMLObjectInput.readUTF());
                bl = cXMLCodeSpace3.addToken(this.prefix);
            } else {
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = xMLObjectInput.readByte();
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                this.prefix = CXMLConstants.names.create(cXMLCodeSpace3.getElementFromToken(n));
            }
        }
        bl = cXMLCodeSpace2.addToken(this.name);
        this.tag = this.prefix != "" ? String.valueOf(this.prefix) + ":" + this.name : this.name;
        this.readAttrNodes(xMLObjectInput, cXMLContext);
    }

    public void removeAttribute(String string) throws DOMException {
        if (string != null) {
            string = string.intern();
        }
        if (this.attrlist != null) {
            this.checkReadOnly();
            this.attrlist.removeNamedItem(string);
        }
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        string = string == null ? "" : string.intern();
        string2 = string2.intern();
        if (this.attrlist != null) {
            this.checkReadOnly();
            this.attrlist.removeNamedItemNS(string, string2);
        }
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.checkReadOnly();
        return (Attr)this.attrlist.removeItem(attr);
    }

    public void reportSAXEvents(ContentHandler contentHandler) throws SAXException {
        Object object;
        SAXAttrList sAXAttrList;
        this.getDOMLocator().setCurrentNode(this);
        if (this.attrlist != null) {
            int n = this.attrlist.getLength();
            sAXAttrList = new SAXAttrList(n);
            int n2 = 0;
            while (n2 < n) {
                object = (XMLAttr)this.attrlist.item(n2);
                sAXAttrList.addAttr(((XMLAttr)object).getPrefix(), ((XMLAttr)object).getLocalName(), ((XMLAttr)object).getQualifiedName(), ((XMLAttr)object).getValue(), ((XMLAttr)object).getSpecified(), 0, ((XMLAttr)object).getNamespace());
                ++n2;
            }
        } else {
            sAXAttrList = new SAXAttrList(1);
        }
        String string = this.getNamespace();
        object = this.getLocalName();
        String string2 = this.getQualifiedName();
        contentHandler.startElement(string, (String)object, string2, sAXAttrList);
        this.reportChildSAXEvents(contentHandler);
        contentHandler.endElement(string, (String)object, string2);
    }

    public String resolveNamespacePrefix(String string) {
        String string2;
        if ((string = string.intern()) == "xml") {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string == "xmlns") {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.nameSpaces != null && (string2 = (String)this.nameSpaces.get(string)) != null) {
            return string2;
        }
        if (this.parent != null && this.parent.getNodeType() == 1) {
            return ((XMLElement)this.parent).resolveNamespacePrefix(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.setAttribute(string.intern(), string2, false);
    }

    void setAttribute(String string, String string2, boolean bl) throws DOMException {
        if (!bl) {
            XMLUtil.validateName(string);
            this.checkReadOnly();
        }
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        this.attrlist.put(string, string2);
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        string = string == null ? "" : string.intern();
        XMLUtil.validateQualifiedName(string2);
        this.checkReadOnly();
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        this.attrlist.put(string, XMLUtil.getLocalName(string2), XMLUtil.getPrefix(string2), string3);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.checkReadOnly();
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        return (Attr)this.attrlist.setNamedItem(attr);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.checkReadOnly();
        if (this.attrlist == null) {
            this.attrlist = new XMLAttrList();
            this.attrlist.parent = this;
        }
        return (Attr)this.attrlist.setNamedItemNS(attr);
    }

    Node traverseDown(XMLNode xMLNode, boolean bl) {
        XMLNode xMLNode2 = (XMLNode)this.getLastChild();
        if (xMLNode2 == null) {
            XMLAttrList xMLAttrList = (XMLAttrList)this.getAttributes();
            XMLAttr xMLAttr = (XMLAttr)xMLAttrList.item(xMLAttrList.getLength() - 1);
            if (xMLAttr == null) {
                return this;
            }
            return xMLAttr.traverseDown(xMLNode, bl);
        }
        return xMLNode2.traverseDown(xMLNode, bl);
    }

    public boolean validateContent(XMLSchema xMLSchema) throws XMLParseException {
        return this.validateContent(xMLSchema, "ORACLE_XSD_StrictValidation");
    }

    public boolean validateContent(XMLSchema xMLSchema, String string) throws XMLParseException {
        XMLError xMLError = new XMLError();
        try {
            XSDValidator xSDValidator = new XSDValidator();
            xSDValidator.setXMLProperty("fixedSchema", xMLSchema);
            xSDValidator.setXMLProperty("validationMode", string);
            xSDValidator.setError(xMLError);
            this.reportSAXEvents(xSDValidator);
        }
        catch (Exception exception) {
            xMLError.setException(exception);
            xMLError.error0(180, 1);
            xMLError.flushErrors();
        }
        if (xMLError.getFirstError() == -1) {
            return true;
        }
        xMLError.flushErrors();
        return false;
    }

    public boolean validateContent(DTD dTD) {
        ElementDecl elementDecl = dTD.findElementDecl(this.tag);
        if (elementDecl == null) {
            return true;
        }
        return elementDecl.validateContent(this);
    }

    private void writeCurrentNode(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        byte by;
        int n;
        int n2;
        String string;
        CXMLCodeSpace cXMLCodeSpace = cXMLContext.getNSCodeSpace();
        CXMLCodeSpace cXMLCodeSpace2 = cXMLContext.getElemCodeSpace();
        CXMLCodeSpace cXMLCodeSpace3 = cXMLContext.getPrefixCodeSpace();
        CXMLCodeSpace cXMLCodeSpace4 = cXMLContext.getAttrCodeSpace();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.namespace != null && this.namespace != "") {
            bl = true;
            bl3 = cXMLCodeSpace.addToken(this.getNamespaceURI());
        }
        if (this.prefix != null && this.prefix != "") {
            bl2 = true;
            bl5 = cXMLCodeSpace3.addToken(this.getPrefix());
        }
        if (bl4 = cXMLCodeSpace2.addToken(this.getLocalName())) {
            xMLObjectOutput.writeByte(28);
            xMLObjectOutput.writeUTF(this.getLocalName());
            xMLObjectOutput.writeBoolean(bl);
            xMLObjectOutput.writeBoolean(bl2);
        } else {
            xMLObjectOutput.writeByte(15);
            string = this.getLocalName();
            n2 = cXMLCodeSpace2.getTokenLength(string, bl, bl2);
            n = 0;
            while (n < n2) {
                by = cXMLCodeSpace2.getToken(string, n, bl, bl2);
                xMLObjectOutput.writeByte(by);
                ++n;
            }
        }
        if (bl3) {
            xMLObjectOutput.writeByte(27);
            xMLObjectOutput.writeUTF(this.getNamespaceURI());
        } else if (this.namespace != null && this.namespace != "") {
            string = this.getNamespaceURI();
            n2 = cXMLCodeSpace.getTokenLength(string);
            n = 0;
            while (n < n2) {
                by = cXMLCodeSpace.getToken(string, n);
                xMLObjectOutput.writeByte(by);
                ++n;
            }
        }
        if (bl5) {
            xMLObjectOutput.writeByte(26);
            xMLObjectOutput.writeUTF(this.getPrefix());
        } else if (this.prefix != null && this.prefix != "") {
            string = this.getPrefix();
            n2 = cXMLCodeSpace3.getTokenLength(string);
            n = 0;
            while (n < n2) {
                by = cXMLCodeSpace3.getToken(string, n);
                xMLObjectOutput.writeByte(by);
                ++n;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    public void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        XMLNode xMLNode;
        this.writeCurrentNode(xMLObjectOutput, cXMLContext);
        XMLAttrList xMLAttrList = (XMLAttrList)this.getAttributes();
        int n = 0;
        while (n < xMLAttrList.getLength()) {
            xMLNode = (XMLAttr)xMLAttrList.item(n);
            ((XMLAttr)xMLNode).writeExternal(xMLObjectOutput, cXMLContext);
            ++n;
        }
        if (xMLAttrList.getLength() != 0) {
            xMLObjectOutput.writeByte(22);
        }
        xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLNode.writeExternal(xMLObjectOutput, cXMLContext);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        xMLObjectOutput.writeByte(22);
    }
}

