/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMMutationEvent;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLRangeEvent;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLTraversalEvent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNSNode
extends XMLNode {
    String name = "";
    String namespace = "";
    String prefix = "";
    String tag;
    private XMLNode firstChild;
    private XMLNode lastChild;

    XMLNSNode() {
    }

    protected XMLNSNode(String string) {
        this.tag = string;
    }

    public XMLNode addText(String string) throws XMLDOMException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        this.addText(cArray, 0, n);
        return (XMLNode)this.getLastChild();
    }

    public void addText(char[] cArray, int n, int n2) throws XMLDOMException {
        boolean bl;
        XMLNode xMLNode = (XMLNode)this.getLastChild();
        boolean bl2 = bl = xMLNode == null || xMLNode.getNodeType() != 3;
        if (bl) {
            XMLText xMLText = new XMLText(cArray, n, n2);
            xMLText.ownerDocument = this.ownerDocument;
            this.appendChild(xMLText);
        } else {
            ((XMLText)xMLNode).addText(cArray, n, n2);
        }
    }

    public Node appendChild(Node node) throws DOMException {
        XMLNode xMLNode = (XMLNode)node;
        if (xMLNode instanceof XMLDocumentFragment) {
            Node node2 = xMLNode.getFirstChild();
            while (node2 != null) {
                this.appendChild(node2);
                node2 = xMLNode.getFirstChild();
            }
            return xMLNode;
        }
        if ((this.ownerDocument.flags & 0x80000) == 0) {
            this.checkNodePermissions(xMLNode, null);
        }
        xMLNode.removeNode();
        this.getFirstChild();
        this.getLastChild();
        if (this.firstChild == null) {
            this.firstChild = this.lastChild = xMLNode;
            xMLNode.parent = this;
        } else {
            this.lastChild.addNextNode(xMLNode);
        }
        if ((this.ownerDocument.flags & 0x20000) == 131072) {
            XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)this.ownerDocument.createRangeEvent("RANGE_INSERT_EVENT");
            xMLRangeEvent.initRangeEvent("RANGE_INSERT_EVENT", false, false, xMLNode, null, null, null, null);
            xMLRangeEvent.setTarget(this.ownerDocument);
            this.ownerDocument.dispatchEvent(xMLRangeEvent);
        }
        if ((this.ownerDocument.flags & 0x10000) == 65536) {
            this.fireDOMMutationEvent("DOMNodeInserted", xMLNode, this, null, null, null, true, false, (short)0);
            xMLNode.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
        }
        return xMLNode;
    }

    void checkAncestry(XMLNode xMLNode) throws DOMException {
        XMLNSNode xMLNSNode = this;
        while (xMLNSNode != null) {
            if (xMLNSNode == xMLNode) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            xMLNSNode = xMLNSNode.parent;
        }
    }

    void checkChildType(int n) throws DOMException {
        throw new XMLDOMException(3, this.getXMLError());
    }

    void checkDocument(Node node) throws DOMException {
        XMLDocument xMLDocument = ((XMLNode)node).ownerDocument;
        if (this.ownerDocument != xMLDocument && xMLDocument != XMLDocument.nullDocument) {
            throw new XMLDOMException(4, this.getXMLError());
        }
    }

    void checkNodePermissions(XMLNode xMLNode, XMLNode xMLNode2) {
        this.checkChildType(xMLNode.getNodeType());
        XMLDocument xMLDocument = xMLNode.ownerDocument;
        if (this.ownerDocument != xMLDocument && xMLDocument != XMLDocument.nullDocument) {
            throw new XMLDOMException(4, this.getXMLError());
        }
        XMLNSNode xMLNSNode = this;
        while (xMLNSNode != null) {
            if (xMLNSNode == xMLNode) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            xMLNSNode = xMLNSNode.parent;
        }
        if (xMLNode2 != null) {
            if (xMLNode == xMLNode2) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            if (xMLNode2.parent != this) {
                throw new XMLDOMException(8, this.getXMLError());
            }
        }
        if (xMLNode.ownerDocument == XMLDocument.nullDocument) {
            this.setOwnerDocument(xMLNode, this.ownerDocument);
        }
        this.ownerDocument.setDocOrdered(false);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        XMLNode xMLNode = (XMLNode)super.clone_Node(bl, xMLDocument);
        ((XMLNSNode)xMLNode).name = this.name;
        ((XMLNSNode)xMLNode).namespace = this.namespace;
        ((XMLNSNode)xMLNode).prefix = this.prefix;
        if (!bl || !this.hasChildNodes()) {
            return xMLNode;
        }
        XMLNode xMLNode2 = (XMLNode)this.getFirstChild();
        while (xMLNode2 != null) {
            xMLNode.appendChild(xMLNode2.clone_Node(bl, xMLDocument));
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
        return xMLNode;
    }

    public NodeList getChildNodes() {
        return new XMLNodeList(this);
    }

    public Node getFirstChild() {
        if ((this.flags & 2) == 2) {
            this.firstChild = this.ownerDocument.nodectx.getFirstChild(this);
            if (this.firstChild != null) {
                this.firstChild.ownerDocument = this.ownerDocument;
                this.firstChild.parent = this;
                this.firstChild.flags &= 0xFFFFFFF7;
            }
            this.flags &= 0xFFFFFFFD;
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if ((this.flags & 4) == 4) {
            this.lastChild = this.ownerDocument.nodectx.getLastChild(this);
            if (this.lastChild != null) {
                this.lastChild.ownerDocument = this.ownerDocument;
                this.lastChild.parent = this;
                this.lastChild.flags &= 0xFFFFFFEF;
            }
            this.flags &= 0xFFFFFFFB;
        }
        return this.lastChild;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getNodeName() {
        return this.tag;
    }

    public String getPrefix() {
        return null;
    }

    public String getText() {
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        if (xMLNode != null) {
            StringBuffer stringBuffer = new StringBuffer();
            while (xMLNode != null) {
                String string;
                short s = xMLNode.getNodeType();
                if (s != 8 && s != 7 && (string = xMLNode.getText()) != null && string != "") {
                    stringBuffer.append(string);
                }
                xMLNode = (XMLNode)xMLNode.getNextSibling();
            }
            return stringBuffer.toString();
        }
        return super.getText();
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        XMLNode xMLNode = (XMLNode)node2;
        XMLNode xMLNode2 = (XMLNode)node;
        if (xMLNode == null) {
            return this.appendChild(xMLNode2);
        }
        if (xMLNode2 instanceof XMLDocumentFragment) {
            Node node3 = xMLNode2.getFirstChild();
            while (node3 != null) {
                this.insertBefore(node3, xMLNode);
                node3 = xMLNode2.getFirstChild();
            }
            return xMLNode2;
        }
        if ((this.ownerDocument.flags & 0x80000) == 0) {
            this.checkNodePermissions(xMLNode2, xMLNode);
        }
        xMLNode2.removeNode();
        xMLNode.addPrevNode(xMLNode2);
        if ((this.ownerDocument.flags & 0x20000) == 131072) {
            XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)this.ownerDocument.createRangeEvent("RANGE_INSERT_EVENT");
            xMLRangeEvent.initRangeEvent("RANGE_INSERT_EVENT", false, false, xMLNode2, null, null, null, null);
            xMLRangeEvent.setTarget(this.ownerDocument);
            this.ownerDocument.dispatchEvent(xMLRangeEvent);
        }
        if ((this.ownerDocument.flags & 0x10000) == 65536) {
            this.fireDOMMutationEvent("DOMNodeInserted", xMLNode2, this, null, null, null, true, false, (short)0);
            xMLNode2.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
        }
        return xMLNode2;
    }

    public void normalize() {
        XMLNode xMLNode = null;
        XMLNode xMLNode2 = (XMLNode)this.getFirstChild();
        while (xMLNode2 != null) {
            if (xMLNode2.getNodeType() == 3) {
                xMLNode = (XMLNode)xMLNode2.getNextSibling();
                while (xMLNode != null && xMLNode.getNodeType() == 3) {
                    xMLNode2.setNodeValue(String.valueOf(xMLNode2.getNodeValue()) + xMLNode.getNodeValue());
                    this.removeChild(xMLNode);
                    xMLNode = (XMLNode)xMLNode2.getNextSibling();
                }
                if (xMLNode == null) {
                    return;
                }
                xMLNode2 = xMLNode;
            }
            xMLNode2.normalize();
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        this.printChildren(xMLOutputStream, bl);
        xMLOutputStream.flush();
    }

    void printChildren(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLNode.print(xMLOutputStream, bl);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        xMLOutputStream.flush();
    }

    public Node removeChild(Node node) throws DOMException {
        XMLDOMMutationEvent xMLDOMMutationEvent;
        XMLNode xMLNode = (XMLNode)node;
        if (xMLNode.parent != this) {
            throw new XMLDOMException(8, this.getXMLError());
        }
        if ((this.ownerDocument.flags & 0x20000) == 131072) {
            xMLDOMMutationEvent = (XMLRangeEvent)this.ownerDocument.createRangeEvent("RANGE_DELETE_EVENT");
            ((XMLRangeEvent)xMLDOMMutationEvent).initRangeEvent("RANGE_DELETE_EVENT", false, false, xMLNode, null, null, null, null);
            xMLDOMMutationEvent.setTarget(this.ownerDocument);
            this.ownerDocument.dispatchEvent(xMLDOMMutationEvent);
        }
        if ((this.ownerDocument.flags & 0x40000) == 262144) {
            xMLDOMMutationEvent = (XMLTraversalEvent)this.ownerDocument.createTraversalEvent("TRAVERSAL_DELETE_EVENT");
            ((XMLTraversalEvent)xMLDOMMutationEvent).initTraversalEvent("TRAVERSAL_DELETE_EVENT", false, false, xMLNode, null, null, null, null);
            xMLDOMMutationEvent.setTarget(this.ownerDocument);
            this.ownerDocument.dispatchEvent(xMLDOMMutationEvent);
        }
        if ((this.ownerDocument.flags & 0x10000) == 65536) {
            this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode, this, null, null, null, true, false, (short)0);
            xMLNode.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
        }
        xMLNode.removeNode();
        return xMLNode;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        XMLDOMMutationEvent xMLDOMMutationEvent;
        XMLNode xMLNode = (XMLNode)node;
        XMLNode xMLNode2 = (XMLNode)node2;
        this.checkNodePermissions(xMLNode, xMLNode2);
        if ((this.ownerDocument.flags & 0x20000) == 131072) {
            xMLDOMMutationEvent = (XMLRangeEvent)this.ownerDocument.createRangeEvent("RANGE_REPLACE_EVENT");
            ((XMLRangeEvent)xMLDOMMutationEvent).initRangeEvent("RANGE_REPLACE_EVENT", false, false, xMLNode2, xMLNode, null, null, null);
            xMLDOMMutationEvent.setTarget(this.ownerDocument);
            this.ownerDocument.dispatchEvent(xMLDOMMutationEvent);
        }
        if ((this.ownerDocument.flags & 0x40000) == 262144) {
            xMLDOMMutationEvent = (XMLTraversalEvent)this.ownerDocument.createTraversalEvent("TRAVERSAL_REPLACE_EVENT");
            ((XMLTraversalEvent)xMLDOMMutationEvent).initTraversalEvent("TRAVERSAL_REPLACE_EVENT", false, false, xMLNode2, xMLNode, null, null, null);
            xMLDOMMutationEvent.setTarget(this.ownerDocument);
            this.ownerDocument.dispatchEvent(xMLDOMMutationEvent);
        }
        if ((this.ownerDocument.flags & 0x10000) == 65536) {
            this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode2, this, null, null, null, true, false, (short)0);
            xMLNode2.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
            this.fireDOMMutationEvent("DOMNodeInserted", xMLNode, this, null, null, null, true, false, (short)0);
            xMLNode.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
        }
        xMLNode.removeNode();
        xMLNode2.addPrevNode(xMLNode);
        xMLNode2.removeNode();
        return xMLNode2;
    }

    int setDocOrder(int n) {
        XMLNode xMLNode;
        this.docOrderId = n;
        n += 2;
        XMLAttrList xMLAttrList = (XMLAttrList)this.getAttributes();
        if (xMLAttrList != null) {
            int n2 = xMLAttrList.getLength();
            int n3 = 0;
            while (n3 < n2) {
                xMLNode = (XMLNode)xMLAttrList.item(n3);
                n = xMLNode.setDocOrder(n);
                ++n3;
            }
        }
        xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            n = xMLNode.setDocOrder(n);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return n;
    }

    void setFirstChild(XMLNode xMLNode) {
        this.firstChild = xMLNode;
    }

    void setLastChild(XMLNode xMLNode) {
        this.lastChild = xMLNode;
    }

    void setOwnerDocument(XMLNode xMLNode, XMLDocument xMLDocument) {
        XMLConstants xMLConstants;
        super.setOwnerDocument(xMLNode, xMLDocument);
        if (xMLNode.getNodeType() == 1) {
            xMLConstants = (XMLAttrList)xMLNode.getAttributes();
            int n = 0;
            int n2 = ((XMLAttrList)xMLConstants).getLength();
            while (n < n2) {
                this.setOwnerDocument((XMLNode)((XMLAttrList)xMLConstants).item(n), this.ownerDocument);
                ++n;
            }
        }
        xMLConstants = (XMLNode)xMLNode.getFirstChild();
        while (xMLConstants != null) {
            this.setOwnerDocument((XMLNode)xMLConstants, this.ownerDocument);
            xMLConstants = (XMLNode)((XMLNode)xMLConstants).getNextSibling();
        }
    }

    public void setPrefix(String string) throws DOMException {
    }
}

