/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNodeList
implements NodeList,
Serializable,
Cloneable {
    XMLNSNode parent;
    XMLNode[] nodeArray;
    int nodeCount;
    static XMLNodeList EMPTY_NODELIST = new XMLNodeList();

    public XMLNodeList() {
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[4];
    }

    public XMLNodeList(int n) {
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[n];
    }

    public XMLNodeList(XMLNSNode xMLNSNode) {
        this.parent = xMLNSNode;
    }

    public void addNode(Node node) {
        this.ensureCapacity();
        this.nodeArray[this.nodeCount] = (XMLNode)node;
        ++this.nodeCount;
    }

    void ensureCapacity() {
        if (this.nodeCount >= this.nodeArray.length) {
            XMLNode[] xMLNodeArray = this.nodeArray;
            this.nodeArray = new XMLNode[this.nodeArray.length * 2];
            System.arraycopy(xMLNodeArray, 0, this.nodeArray, 0, xMLNodeArray.length);
        }
    }

    public int getLength() {
        if (this.parent != null) {
            int n = 0;
            Node node = this.parent.getFirstChild();
            while (node != null) {
                ++n;
                node = node.getNextSibling();
            }
            return n;
        }
        return this.nodeCount;
    }

    public Node item(int n) {
        if (this.parent != null) {
            Node node = this.parent.getFirstChild();
            while (node != null) {
                if (n == 0) {
                    return node;
                }
                --n;
                node = node.getNextSibling();
            }
            return null;
        }
        if (n >= 0 && n < this.nodeCount) {
            return this.nodeArray[n];
        }
        return null;
    }
}

