/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NonValidatingParser;
import oracle.xml.parser.v2.ValidatingParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.util.XMLProperties;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLParser
implements XMLConstants,
XMLProperties {
    NonValidatingParser parser = new NonValidatingParser();
    public static final String DTD_OBJECT = "oracle.xml.parser.XMLParser.DTDObject";
    public static final String USE_DTD_ONLY_FOR_VALIDATION = "oracle.xml.parser.XMLParser.UseDTDForValidation";
    public static final String SCHEMA_OBJECT = "oracle.xml.parser.XMLParser.SchemaObject";
    public static final String BASE_URL = "oracle.xml.parser.XMLParser.BaseURL";
    public static final String STANDALONE = "oracle.xml.parser.XMLParser.Standalone";
    protected Hashtable attributes;
    boolean validating;
    boolean useDTDForValidation;
    boolean xsdValidatorSet;
    int validating_mode;
    static final String releaseVersion = "Oracle XDK Java      9.2.0.2.0       Production";

    XMLParser() {
    }

    XSDValidator addXSDValidator() {
        try {
            if (!this.xsdValidatorSet) {
                XSDValidator xSDValidator = new XSDValidator();
                xSDValidator.setXMLProperties(this);
                xSDValidator.addContentHandler(this.parser.cntHandler);
                this.parser.cntHandler = xSDValidator;
                this.xsdValidatorSet = true;
                return xSDValidator;
            }
            return (XSDValidator)this.parser.cntHandler;
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
            return null;
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if ((string = string.intern()) == DTD_OBJECT || string == SCHEMA_OBJECT || string == BASE_URL || string == USE_DTD_ONLY_FOR_VALIDATION || string == STANDALONE) {
            return this.attributes.get(string);
        }
        throw new IllegalArgumentException();
    }

    public URL getBaseURL() {
        return this.parser.baseURL;
    }

    public EntityResolver getEntityResolver() {
        return this.parser.entResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.err.getErrorHandler();
    }

    public static String getReleaseVersion() {
        return releaseVersion;
    }

    public boolean getValidationMode() {
        return this.validating;
    }

    public int getValidationModeValue() {
        return this.validating_mode;
    }

    public Object getXMLProperty(String string) {
        if (string.equals("oracle.xml.parser.DocumentBuilder")) {
            return this.parser.getDocumentBuilder();
        }
        return null;
    }

    private void initializeSchemaValidation(String string) {
        this.parser = new NonValidatingParser(this.parser);
        XSDValidator xSDValidator = this.addXSDValidator();
        try {
            xSDValidator.setError(this.parser.err);
            xSDValidator.setDocumentLocator(this.parser.reader);
            if (xSDValidator.setXMLProperty("validationMode", string) == null) {
                this.parser.err.error0(1900, 0);
            }
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
        this.validating = true;
    }

    public boolean isXMLPropertyReadOnly(String string) {
        return true;
    }

    public boolean isXMLPropertySupported(String string) {
        return string.equals("oracle.xml.parser.DocumentBuilder");
    }

    public final void parse(InputStream inputStream) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.pushXMLReader(inputStream, null, null);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public final void parse(Reader reader) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.pushXMLReader(reader, null, null);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public void parse(String string) throws XMLParseException, SAXException, IOException {
        try {
            InputSource inputSource = new InputSource(string);
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.pushXMLReader(inputSource);
            this.parser.parseDocument();
        }
        finally {
            Object var3_3 = null;
            this.parser.reader.close();
        }
    }

    public final void parse(URL uRL) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.pushXMLReader(uRL, uRL.toString(), null);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public void parse(InputSource inputSource) throws XMLParseException, SAXException, IOException {
        try {
            this.parser.init();
            this.parser.reader = new XMLReader(this.parser.dtd, this.parser.err, this.parser.entResolver, this.validating_mode);
            this.parser.reader.pushXMLReader(inputSource);
            this.parser.parseDocument();
        }
        finally {
            Object var3_2 = null;
            this.parser.reader.close();
        }
    }

    public void reset() {
        this.parser.reset();
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if ((string = string.intern()) == DTD_OBJECT && object instanceof DTD) {
            this.setDoctype((DTD)object);
        } else if (string == SCHEMA_OBJECT) {
            this.setXMLSchema(object);
        } else if (string == BASE_URL && object instanceof URL) {
            this.setBaseURL((URL)object);
        } else if (string == USE_DTD_ONLY_FOR_VALIDATION && object instanceof Boolean) {
            this.useDTDForValidation = (Boolean)object;
        } else if (string == STANDALONE && object instanceof Boolean) {
            this.parser.standalone = (Boolean)object;
        } else {
            throw new IllegalArgumentException();
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable(5);
        }
        this.attributes.put(string, object);
    }

    public void setBaseURL(URL uRL) {
        this.parser.baseURL = uRL;
    }

    void setContentHandler(ContentHandler contentHandler, ContentHandler contentHandler2) {
        if (this.xsdValidatorSet) {
            XMLMultiHandler xMLMultiHandler = (XMLMultiHandler)this.parser.cntHandler;
            xMLMultiHandler.removeContentHandler(contentHandler2);
            xMLMultiHandler.addContentHandler(contentHandler);
        } else {
            this.parser.cntHandler = contentHandler;
        }
    }

    public void setDoctype(DTD dTD) {
        this.parser.dtd = dTD;
        this.parser.fixedDTD = true;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.entResolver = entityResolver;
    }

    void setError(XMLError xMLError) {
        this.parser.err = xMLError;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.err.setErrorHandler(errorHandler);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.err.setLocale(locale);
    }

    public void setPreserveWhitespace(boolean bl) {
        this.parser.preserveWS = bl;
    }

    public void setSchemaValidationMode(boolean bl) {
        this.setValidationMode(3);
    }

    public void setValidationMode(int n) {
        if (n == 0) {
            this.validating = false;
            this.parser = new NonValidatingParser(this.parser);
        } else if (n == 3) {
            this.initializeSchemaValidation("ORACLE_XSD_AutoValidation");
        } else if (n == 5) {
            this.initializeSchemaValidation("ORACLE_XSD_LaxValidation");
        } else if (n == 6) {
            this.initializeSchemaValidation("ORACLE_XSD_StrictValidation");
        } else {
            this.parser = new ValidatingParser(this.parser);
            this.validating = true;
        }
        this.validating_mode = n == 4 ? 1 : n;
    }

    public void setValidationMode(boolean bl) {
        if (bl != this.validating) {
            if (bl) {
                this.parser = new ValidatingParser(this.parser);
                this.validating_mode = 2;
            } else {
                this.parser = new NonValidatingParser(this.parser);
                this.validating_mode = 0;
            }
            this.validating = bl;
        }
    }

    public Object setXMLProperty(String string, Object object) {
        return null;
    }

    public void setXMLSchema(Object object) {
        XSDValidator xSDValidator = this.addXSDValidator();
        try {
            xSDValidator.setError(this.parser.err);
            xSDValidator.setDocumentLocator(this.parser.reader);
            xSDValidator.setXMLProperty("fixedSchema", (XMLSchema)object);
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }
}

