/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XPathFilterExpr;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExpr;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLExtFunctions;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLParseString;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.util.FastVector;

class XPathExtFunction
extends XPathFilterExpr {
    String name1;
    String name2;
    FastVector exprVector;
    XSLExprBase expr1;
    private Hashtable methodHash;
    static final int CONSTRUCTOR = 0;
    static final int INST_METHOD = 1;
    static final int STATIC_METHOD = 2;
    static final int CACHE_SIZE = 64;

    XPathExtFunction() {
        this.methodHash = new Hashtable(20);
    }

    XPathExtFunction(XSLParseString xSLParseString) throws XSLException {
        this.exprType = -123;
        this.name1 = xSLParseString.nameSpace;
        this.name2 = xSLParseString.name;
        xSLParseString.nextToken();
        this.exprVector = new FastVector();
        if (xSLParseString.lookahead != 41) {
            this.exprVector.addElement(XSLExpr.parse(xSLParseString, true));
            while (xSLParseString.lookahead != 41) {
                if (xSLParseString.lookahead != 44) {
                    throw new XPathException(1020);
                }
                this.exprVector.addElement(XSLExpr.parse(xSLParseString, false));
            }
        }
        xSLParseString.nextToken();
        this.methodHash = new Hashtable(20);
    }

    boolean checkPosLastFN() {
        return true;
    }

    void evaluateMethod(String string, String string2, FastVector fastVector, XSLExprValue xSLExprValue) throws XPathException {
        Method method = null;
        Constructor constructor = null;
        int n = -1;
        Thread thread = Thread.currentThread();
        Object v = this.methodHash.get(thread);
        if (v == null) {
            if (this.methodHash.size() >= 64) {
                this.methodHash.clear();
            }
            if (string2.equals("new")) {
                constructor = XSLExtFunctions.getConstructor(string, fastVector);
                n = 0;
                this.methodHash.put(thread, constructor);
            } else {
                method = XSLExtFunctions.getMethod(string, string2, fastVector);
                this.methodHash.put(thread, method);
            }
        } else if (v instanceof Method) {
            method = (Method)v;
        } else {
            constructor = (Constructor)v;
            n = 0;
        }
        if (n == -1) {
            n = Modifier.isStatic(method.getModifiers()) ? 2 : 1;
        }
        switch (n) {
            case 0: {
                XSLExtFunctions.callConstructor(constructor, fastVector, xSLExprValue);
                break;
            }
            case 1: {
                XSLExtFunctions.callMethod(method, fastVector, xSLExprValue);
                break;
            }
            case 2: {
                XSLExtFunctions.callStaticMethod(method, fastVector, xSLExprValue);
                break;
            }
        }
    }

    public XSLExprValue getValue(XSLTContext xSLTContext) throws XSLException {
        XSLExprValue xSLExprValue = xSLTContext.getExprValueObject(this.exprIndex, this);
        if (this.name2 == "node-set") {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(0);
            XSLExprValue xSLExprValue2 = xSLExprBase.getValue(xSLTContext);
            XSLNodeList xSLNodeList = new XSLNodeList();
            XMLDocumentFragment xMLDocumentFragment = xSLExprValue2.getResultTreeValue();
            if (xMLDocumentFragment == null) {
                throw new XPathException(1019, "result-tree-fragment", xSLExprValue2.getTypeString());
            }
            xSLNodeList.addNode(xMLDocumentFragment);
            xSLExprValue.setNodeList(xSLNodeList);
        } else {
            FastVector fastVector = new FastVector(this.exprVector.size());
            int n = 0;
            while (n < this.exprVector.size()) {
                fastVector.addElement(((XSLExprBase)this.exprVector.elementAt(n)).getValue(xSLTContext));
                ++n;
            }
            this.evaluateMethod(this.name1, this.name2, fastVector, xSLExprValue);
        }
        if (this.predicates == null) {
            return xSLExprValue;
        }
        return this.filterPredicates(xSLTContext);
    }

    boolean isNumber() {
        return true;
    }

    void setExprIndex(XSLStylesheet xSLStylesheet) {
        if (this.expr1 != null) {
            this.expr1.setExprIndex(xSLStylesheet);
        }
        if (this.exprVector != null) {
            int n = this.exprVector.size();
            int n2 = 0;
            while (n2 < n) {
                XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(n2);
                xSLExprBase.setExprIndex(xSLStylesheet);
                ++n2;
            }
        }
        super.setExprIndex(xSLStylesheet);
    }
}

