/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.PrintWriter;
import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLNodeSetInt;
import oracle.xml.parser.v2.XSLSort;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.parser.v2.XSLTemplate;
import oracle.xml.parser.v2.XSLVariable;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;

class XSLApplyTemplates
extends XSLNode
implements XSLConstants {
    private XSLSort sortnode;
    private FastVector paramList;
    private int nParams;
    private XSLNodeSetInt expr;
    private NSName mode;

    XSLApplyTemplates(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.localName = "apply-templates";
        this.elementType = 4;
    }

    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform") {
            if (xSLNode.localName == "sort") {
                if (this.sortnode == null) {
                    this.sortnode = (XSLSort)xSLNode;
                } else {
                    this.sortnode.addSecondaryKey((XSLSort)xSLNode);
                }
                this.children.setSize(this.children.size() - 1);
            }
            if (xSLNode.localName == "with-param") {
                if (this.paramList == null) {
                    this.paramList = new FastVector(4);
                }
                this.paramList.addElement(xSLNode);
                ++this.nParams;
                this.children.setSize(this.children.size() - 1);
            }
        }
    }

    public void finalize() throws XSLException {
        if (this.sortnode != null) {
            this.sortnode.finalize();
        }
        int n = 0;
        while (n < this.nParams) {
            ((XSLNode)this.paramList.elementAt(n)).finalize();
            ++n;
        }
        super.finalize();
    }

    void printChildren(PrintWriter printWriter, int n) {
        if (this.sortnode != null) {
            this.sortnode.printXSLNode(printWriter, n);
        }
        int n2 = 0;
        while (n2 < this.nParams) {
            ((XSLNode)this.paramList.elementAt(n2)).printXSLNode(printWriter, n);
            ++n2;
        }
        super.printChildren(printWriter, n);
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        this.processAction(xSLTContext, this.mode);
    }

    private void processAction(XSLTContext xSLTContext, NSName nSName) throws XSLException {
        XSLNode xSLNode;
        Object object;
        XMLNode xMLNode = xSLTContext.getContextNode();
        boolean bl = false;
        if (xMLNode.getNodeType() == 1 && (bl = ((String)(object = ((XMLElement)xMLNode).getAttribute("xml:space"))).equals("") ^ true)) {
            if (((String)object).equals("preserve")) {
                xSLTContext.setSrcWhiteSpaceMode(true);
            } else if (((String)object).equals("default")) {
                xSLTContext.setSrcWhiteSpaceMode(false);
            } else {
                bl = false;
            }
        }
        object = null;
        int n = 0;
        object = (XSLNodeList)this.expr.getSelectedNodes(xSLTContext);
        ((XSLNodeList)object).removeWhiteSpace(xSLTContext);
        if (this.sortnode != null) {
            object = this.sortnode.sortNodes(xSLTContext, (XSLNodeList)object);
        }
        n = ((XSLNodeList)object).getLength();
        Hashtable hashtable = null;
        if (this.nParams > 0) {
            hashtable = (Hashtable)XSLNode.hashPool.alloc();
            int n2 = 0;
            while (n2 < this.nParams) {
                xSLNode = (XSLVariable)this.paramList.elementAt(n2);
                hashtable.put(((XSLVariable)xSLNode).getName(), ((XSLVariable)xSLNode).getValue(xSLTContext));
                ++n2;
            }
        }
        if (this.xss.isForwardCompatibilityMode()) {
            this.processChildren(xSLTContext);
        }
        int n3 = xSLTContext.setContextSize(n);
        int n4 = xSLTContext.getContextPosition();
        int n5 = 0;
        while (n5 < n) {
            XMLNode xMLNode2 = (XMLNode)((XSLNodeList)object).item(n5);
            xSLTContext.setContextPosition(n5 + 1);
            xSLTContext.setContextNode(xMLNode2);
            xSLTContext.setCurrentNode(xMLNode2);
            xSLNode = this.xss.getMatchingTemplate(xMLNode2, nSName, xSLTContext);
            if (((XSLTemplate)xSLNode).isBuiltInElementTemplate) {
                XSLApplyTemplates xSLApplyTemplates = (XSLApplyTemplates)xSLNode.children.elementAt(0);
                xSLApplyTemplates.processAction(xSLTContext, nSName);
            } else {
                int n6 = xSLTContext.getCurrentTmpl();
                xSLTContext.setCurrentTmpl(((XSLTemplate)xSLNode).index);
                ((XSLTemplate)xSLNode).setParams(hashtable, xSLTContext);
                ((XSLTemplate)xSLNode).processAction(xSLTContext);
                xSLTContext.setCurrentTmpl(n6);
            }
            ++n5;
        }
        xSLTContext.setContextSize(n3);
        xSLTContext.setContextPosition(n4);
        xSLTContext.setContextNode(xMLNode);
        xSLTContext.setCurrentNode(xMLNode);
        if (bl) {
            xSLTContext.resetSrcWhiteSpaceMode();
        }
        if (hashtable != null) {
            XSLNode.hashPool.free(hashtable);
        }
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (string == "") {
            if (string3 == "select") {
                this.expr = XSLExprBase.createNodeSetExpr(string4, this, this.xss);
            } else if (string3 == "mode") {
                this.mode = this.resolveQname(string4);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    public void startContent() throws XSLException {
        if (this.expr == null) {
            this.expr = XSLExprBase.createNodeSetExpr("node()", this, this.xss);
        }
        if (this.mode == null) {
            this.mode = new NSNameImpl();
        }
    }
}

