/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XSLApplyImport;
import oracle.xml.parser.v2.XSLApplyTemplates;
import oracle.xml.parser.v2.XSLAttribute;
import oracle.xml.parser.v2.XSLAttributeSet;
import oracle.xml.parser.v2.XSLCallTemplate;
import oracle.xml.parser.v2.XSLCondition;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLCopy;
import oracle.xml.parser.v2.XSLCopyOf;
import oracle.xml.parser.v2.XSLElement;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLFallback;
import oracle.xml.parser.v2.XSLForEach;
import oracle.xml.parser.v2.XSLKey;
import oracle.xml.parser.v2.XSLMiscElements;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNumber;
import oracle.xml.parser.v2.XSLOtherElements;
import oracle.xml.parser.v2.XSLOutput;
import oracle.xml.parser.v2.XSLResultElement;
import oracle.xml.parser.v2.XSLSort;
import oracle.xml.parser.v2.XSLSpaceElem;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTemplate;
import oracle.xml.parser.v2.XSLText;
import oracle.xml.parser.v2.XSLValueOf;
import oracle.xml.parser.v2.XSLVariable;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSLBuilder
extends DefaultHandler
implements XSLConstants,
TemplatesHandler {
    private boolean fixedXss;
    private XSLStylesheet xss;
    private XSLNode xssRoot;
    private URL baseURL;
    private XMLError err;
    private Locator locator;
    private EntityResolver entityResolver;
    private FastVector nodeStack;
    private XSLNode currentNode;
    private int contentMode;
    private int importLevel;
    private int importPriority;
    private int skipTopLevel;
    private int includeProcessing;

    public XSLBuilder() {
        this.nodeStack = new FastVector(16);
        this.contentMode = 0;
    }

    XSLBuilder(XSLStylesheet xSLStylesheet) {
        this.xss = xSLStylesheet;
        this.fixedXss = true;
        this.nodeStack = new FastVector(16);
        this.contentMode = 0;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.skipTopLevel > 0) {
                return;
            }
            if (this.contentMode == 1 || this.contentMode == 2 || this.contentMode == 4 || this.contentMode == 3) {
                if (!XMLUtil.isWhiteSpace(cArray, n, n2)) {
                    this.err.error2(1029, 2, "text", this.currentNode.getQualifiedName());
                }
            } else {
                this.currentNode.appendText(cArray, n, n2);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    private XSLNode createCharTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        if (string == "http://www.w3.org/1999/XSL/Transform") {
            if (string2 == "text") {
                xSLNode = new XSLText(this.xss);
            } else if (string2 == "message") {
                xSLNode = new XSLMiscElements(string2, this.xss);
            } else if (string2 == "apply-imports") {
                xSLNode = new XSLApplyImport(this.xss);
            } else if (string2 == "apply-templates") {
                xSLNode = new XSLApplyTemplates(this.xss);
            } else if (string2 == "for-each") {
                xSLNode = new XSLForEach(this.xss);
            } else if (string2 == "call-template") {
                xSLNode = new XSLCallTemplate(this.xss);
            } else if (string2 == "copy") {
                xSLNode = new XSLCopy(this.xss);
            } else if (string2 == "copy-of") {
                xSLNode = new XSLCopyOf(this.xss);
            } else if (string2 == "value-of") {
                xSLNode = new XSLValueOf(this.xss);
            } else if (string2 == "number") {
                xSLNode = new XSLNumber(this.xss);
            } else if (string2 == "choose" || string2 == "if") {
                xSLNode = new XSLCondition(this.xss);
            } else if (string2 == "variable") {
                xSLNode = new XSLVariable(this.xss);
            } else if (string2 == "fallback") {
                xSLNode = new XSLFallback(this.xss);
            } else if (this.xss.isForwardCompatibilityMode()) {
                xSLNode = new XSLOtherElements(this.xss);
            }
        }
        return xSLNode;
    }

    private XSLNode createMiscTemplateElement(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        String string3 = this.currentNode.getLocalName();
        if (string == "http://www.w3.org/1999/XSL/Transform") {
            if (string3 == "apply-templates") {
                if (string2 == "with-param") {
                    xSLNode = new XSLVariable(this.xss);
                } else if (string2 == "sort") {
                    xSLNode = new XSLSort(this.xss);
                }
            } else if (string3 == "call-template" && string2 == "with-param") {
                xSLNode = new XSLVariable(this.xss);
            } else if (string3 == "choose") {
                if (string2 == "when" || string2 == "otherwise") {
                    xSLNode = new XSLCondition(this.xss);
                }
            } else if (string3 == "attribute-set" && string2 == "attribute") {
                xSLNode = new XSLAttribute(this.xss);
            } else if (this.currentNode instanceof XSLOtherElements && string2 == "fallback") {
                xSLNode = new XSLFallback(this.xss);
            }
        } else if (string == "http://www.oracle.com/XSL/Transform/java" && string3 == "extlib" && string2 == "element") {
            xSLNode = new XSLNode(this.xss);
        }
        return xSLNode;
    }

    private XSLNode createMiscTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        String string3 = this.currentNode.getLocalName();
        if (string == "http://www.w3.org/1999/XSL/Transform") {
            if (string3 == "template" && string2 == "param") {
                xSLNode = new XSLVariable(this.xss);
            } else if (string3 == "for-each" && string2 == "sort") {
                xSLNode = new XSLSort(this.xss);
            }
        }
        if (xSLNode == null) {
            this.contentMode = 7;
            this.currentNode.elementType = 7;
        }
        return xSLNode;
    }

    private XSLNode createTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        if (string == "http://www.w3.org/1999/XSL/Transform") {
            if (string2 == "attribute") {
                xSLNode = new XSLAttribute(this.xss);
            } else if (string2 == "element") {
                xSLNode = new XSLElement(this.xss);
            } else if (string2 == "processing-instruction" || string2 == "comment") {
                xSLNode = new XSLMiscElements(string2, this.xss);
            }
        } else {
            xSLNode = new XSLResultElement(this.xss);
        }
        return xSLNode;
    }

    private XSLNode createTopLevelInstruction(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string == "http://www.w3.org/1999/XSL/Transform") {
            if (string2 == "import") {
                xSLNode = this.processImport(string, string2, attributes);
                this.err.error2(1048, 1, string2, "stylesheet");
            } else if (string2 == "include") {
                xSLNode = this.processInclude(string, string2, attributes);
            } else if (string2 == "template") {
                xSLNode = new XSLTemplate(this.xss);
                ((XSLTemplate)xSLNode).baseUrl = this.baseURL;
                ((XSLTemplate)xSLNode).importLevel = this.importLevel;
                ((XSLTemplate)xSLNode).importPriority = this.xssRoot.xssImportPriority;
            } else if (string2 == "variable" || string2 == "param") {
                xSLNode = new XSLVariable(this.xss);
                ((XSLVariable)xSLNode).setBaseURL(this.baseURL);
            } else if (string2 == "attribute-set") {
                xSLNode = new XSLAttributeSet(this.xss);
            } else if (string2 == "key") {
                xSLNode = new XSLKey(this.xss);
            } else if (string2 == "strip-space" || string2 == "preserve-space") {
                xSLNode = new XSLSpaceElem(this.xss);
                ((XSLSpaceElem)xSLNode).importPriority = this.xssRoot.xssImportPriority;
            } else if (string2 == "output") {
                xSLNode = new XSLOutput(this.xss);
            } else if (string2 == "namespace-alias") {
                xSLNode = new XSLNode(this.xss);
            } else if (string2 == "decimal-format") {
                xSLNode = new XSLNode(this.xss);
            }
        } else if (string == "http://www.oracle.com/XSL/Transform/java") {
            if (string2 == "output") {
                xSLNode = new XSLOutput(this.xss);
            } else if (string2 == "extlib") {
                xSLNode = new XSLNode(this.xss);
                xSLNode.elementType = 4;
            }
        }
        if (xSLNode == null) {
            ++this.skipTopLevel;
        }
        return xSLNode;
    }

    public void endDocument() throws SAXException {
        try {
            this.xss.appendChild(this.xssRoot);
            if (this.includeProcessing > 0) {
                this.importPriority = this.xssRoot.xssImportPriority;
                return;
            }
            this.xss.endContent();
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skipTopLevel > 0) {
            --this.skipTopLevel;
            return;
        }
        try {
            this.currentNode.endContent();
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        int n = this.nodeStack.size();
        this.currentNode = (XSLNode)this.nodeStack.elementAt(n - 2);
        this.contentMode = this.currentNode.elementType;
        this.nodeStack.setSize(n - 1);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public Locator getLocator() {
        return this.locator;
    }

    public XSLStylesheet getStylesheet() throws XSLException {
        return this.xss;
    }

    public String getSystemId() {
        if (this.baseURL != null) {
            return this.baseURL.toString();
        }
        return null;
    }

    public Templates getTemplates() {
        try {
            return this.getStylesheet();
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    private void processAttributes(XSLNode xSLNode, Attributes attributes) throws XSLException, SAXException {
        String string;
        String string2;
        String string3;
        String string4;
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            string4 = ((SAXAttrList)attributes).getPrefix(n2);
            string3 = attributes.getLocalName(n2);
            string2 = attributes.getURI(n2);
            string = attributes.getValue(n2);
            if (string4 == "xmlns") {
                xSLNode.addNamespace(string3, string.intern());
            } else if (string3 == "xmlns") {
                xSLNode.addNamespace("#default", string.intern());
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            string4 = ((SAXAttrList)attributes).getPrefix(n3);
            string3 = attributes.getLocalName(n3);
            string2 = attributes.getURI(n3);
            string = attributes.getValue(n3);
            if (string4 != "xmlns" && string3 != "xmlns") {
                xSLNode.setAttribute(string2, string4, string3, string);
            }
            ++n3;
        }
    }

    private XSLNode processImport(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string == "http://www.w3.org/1999/XSL/Transform" && string2 == "import") {
            xSLNode = new XSLNode(this.xss);
            String string3 = attributes.getValue("href");
            if (string3 != null) {
                this.processImportHref(string3);
            } else {
                this.err.error2(1009, 1, "href", xSLNode.getQualifiedName());
            }
        } else {
            this.xssRoot.elementType = 2;
            this.contentMode = 2;
        }
        return xSLNode;
    }

    private void processImportHref(String string) throws SAXException {
        int n = this.importPriority++;
        ++this.importLevel;
        this.processIncludeHref(string);
        --this.importLevel;
    }

    private XSLNode processInclude(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string == "http://www.w3.org/1999/XSL/Transform" && string2 == "include") {
            xSLNode = new XSLNode(this.xss);
            String string3 = attributes.getValue("href");
            if (string3 != null) {
                this.processIncludeHref(string3);
            } else {
                this.err.error2(1009, 1, "href", xSLNode.getQualifiedName());
            }
        }
        return xSLNode;
    }

    private void processIncludeHref(String string) throws SAXException {
        XSLNode xSLNode = this.xssRoot;
        Locator locator = this.locator;
        URL uRL = this.baseURL;
        int n = this.contentMode;
        ++this.includeProcessing;
        try {
            URL uRL2;
            SAXParser sAXParser = new SAXParser();
            sAXParser.setPreserveWhitespace(true);
            sAXParser.setContentHandler(this);
            this.baseURL = uRL2 = new URL(this.baseURL, string);
            this.contentMode = 0;
            sAXParser.setBaseURL(uRL2);
            if (this.entityResolver != null) {
                sAXParser.setEntityResolver(this.entityResolver);
                InputSource inputSource = this.entityResolver.resolveEntity("", uRL2.toString());
                sAXParser.parse(inputSource);
            } else {
                sAXParser.parse(uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.err.setException(malformedURLException);
            this.err.error1(1002, 1, string);
        }
        catch (IOException iOException) {
            this.err.setException(iOException);
            this.err.error1(1002, 1, string);
        }
        this.locator = locator;
        this.baseURL = uRL;
        this.xssRoot = xSLNode;
        this.contentMode = n;
        --this.includeProcessing;
    }

    private XSLNode processStylesheetRoot(String string, String string2, String string3, Attributes attributes) throws XSLException, SAXException {
        Object object;
        XSLNode xSLNode = this.xssRoot;
        String string4 = "";
        if (string == "http://www.w3.org/1999/XSL/Transform") {
            if (string2 != "stylesheet" && string2 != "transform") {
                this.err.error1(1001, 1, string3);
                return null;
            }
        } else {
            if (string2.equalsIgnoreCase("html") && string.equals("")) {
                this.xss.output.setMethod(XSLOutput.HTML);
            }
            object = new XSLTemplate(this.xss);
            ((XSLTemplate)object).setAttribute("", "", "match", "/");
            ((XSLNode)object).setURI("http://www.w3.org/1999/XSL/Transform");
            ((XSLNode)object).setLocalName("template");
            ((XSLTemplate)object).startContent();
            ((XSLTemplate)object).endContent();
            this.xssRoot.appendChild((XSLNode)object);
            this.currentNode = object;
            this.contentMode = 7;
            ((XSLNode)object).elementType = 7;
            xSLNode = this.createTemplateInstruction(string, string2);
            string4 = "http://www.w3.org/1999/XSL/Transform";
        }
        if ((object = attributes.getValue(string4, "version")) != null) {
            this.xss.setForwardCompatibilityMode((String)object);
        } else {
            String string5 = "version";
            if (string4 == "http://www.w3.org/1999/XSL/Transform") {
                string5 = "{http://www.w3.org/1999/XSL/Transform}:version";
            }
            this.err.error2(1009, 1, string5, string3);
        }
        return xSLNode;
    }

    private void pushXSLNode(XSLNode xSLNode) throws XSLException {
        this.nodeStack.addElement(xSLNode);
        if (xSLNode != this.xssRoot) {
            this.currentNode.appendChild(xSLNode);
        }
        this.currentNode = xSLNode;
        this.contentMode = xSLNode.getElementType();
        if (this.locator != null) {
            xSLNode.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
        }
    }

    public void reset() {
        if (!this.fixedXss) {
            this.xss = null;
        }
        this.locator = null;
        this.nodeStack.setSize(0);
        this.currentNode = null;
        this.contentMode = 0;
        this.importLevel = 0;
        this.importPriority = 0;
        this.skipTopLevel = 0;
        this.includeProcessing = 0;
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    public void setSystemId(String string) {
        try {
            if (string != null) {
                this.baseURL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.err.setException(malformedURLException);
            this.err.error1(1002, 1, string);
        }
    }

    public void startDocument() throws SAXException {
        try {
            if (this.includeProcessing == 0) {
                if (this.err == null) {
                    this.err = new XMLError();
                }
                if (this.xss == null) {
                    this.xss = new XSLStylesheet();
                }
            }
            this.xssRoot = new XSLNode(this.xss);
            this.xssRoot.elementType = 1;
            this.xssRoot.xssImportPriority = this.importPriority;
            this.xssRoot.setLocalName("stylesheet");
            if (this.includeProcessing > 0) {
                return;
            }
            this.xss.err = this.err;
            this.nodeStack.addElement(this.xss);
            if (this.locator != null) {
                this.err.setLocator(this.locator);
                this.xss.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
            }
            this.currentNode = this.xss;
            this.contentMode = 0;
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            XSLNode xSLNode = null;
            if (this.skipTopLevel > 0) {
                ++this.skipTopLevel;
                return;
            }
            switch (this.contentMode) {
                case 0: {
                    xSLNode = this.processStylesheetRoot(string, string2, string3, attributes);
                    break;
                }
                case 1: {
                    xSLNode = this.processImport(string, string2, attributes);
                    if (xSLNode != null) break;
                }
                case 2: {
                    xSLNode = this.createTopLevelInstruction(string, string2, attributes);
                    if (xSLNode != null) break;
                    return;
                }
                case 6: {
                    xSLNode = this.createMiscTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 7: {
                    xSLNode = this.createTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 5: {
                    xSLNode = this.createCharTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 4: {
                    xSLNode = this.createMiscTemplateElement(string, string2);
                }
            }
            if (xSLNode == null) {
                xSLNode = new XSLNode(this.xss);
                xSLNode.elementType = 7;
                String string4 = this.currentNode.getQualifiedName();
                String string5 = this.currentNode.getLocalName();
                if (string5 == "template" && string2 == "param" || string5 == "for-each" && string2 == "sort") {
                    this.err.error2(1048, 2, string3, string4);
                } else {
                    this.err.error2(1029, 2, string3, string4);
                    xSLNode.setErrorId(1047, 1, 2);
                    xSLNode.addErrorParam(0, string3);
                    xSLNode.addErrorParam(1, string4);
                }
            }
            xSLNode.setURI(string);
            xSLNode.setPrefix(XMLUtil.getPrefix(string3));
            xSLNode.setLocalName(string2);
            this.pushXSLNode(xSLNode);
            this.processAttributes(xSLNode, attributes);
            xSLNode.startContent();
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

