/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;

class XSLCondition
extends XSLNode
implements XSLConstants {
    private XSLExprInt testExpr;
    private int childState;

    XSLCondition(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
    }

    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (this.localName != "choose") {
            return;
        }
        if (this.childState == 2) {
            this.xss.err.error2(1029, 1, xSLNode.localName, "choose");
        }
        if (xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform") {
            if (xSLNode.localName == "when") {
                this.childState = 1;
            } else if (xSLNode.localName == "otherwise") {
                if (this.childState == 0) {
                    this.xss.err.error2(1010, 1, "when", this.getQualifiedName());
                }
                this.childState = 2;
            }
        }
    }

    void endContent() throws XSLException {
        if (this.localName == "choose" && this.childState == 0) {
            this.xss.err.error2(1010, 1, "when", this.getQualifiedName());
        }
        super.endContent();
    }

    public int getElementType() {
        this.elementType = this.localName == "choose" ? 4 : 7;
        return this.elementType;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        String string = this.getLocalName();
        if (string == "choose") {
            int n = this.children.size();
            int n2 = 0;
            while (n2 < n) {
                XSLCondition xSLCondition = (XSLCondition)this.children.elementAt(n2);
                String string2 = xSLCondition.getLocalName();
                if (string2 == "when") {
                    if (xSLCondition.testCondition(xSLTContext)) {
                        xSLCondition.processAction(xSLTContext);
                        break;
                    }
                } else {
                    xSLCondition.processAction(xSLTContext);
                    break;
                }
                ++n2;
            }
        } else if (string == "when" || string == "otherwise") {
            this.processChildren(xSLTContext);
        } else if (string == "if" && this.testCondition(xSLTContext)) {
            this.processChildren(xSLTContext);
        }
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (this.localName != "choose" && this.localName != "otherwise" && string == "" && string3 == "test") {
            this.testExpr = XSLExprBase.createBooleanExpr(string4, this, this.xss);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    public void startContent() throws XSLException {
        if (this.localName != "choose" && this.localName != "otherwise" && this.testExpr == null) {
            this.xss.err.error2(1009, 1, "test", this.getQualifiedName());
        }
    }

    private boolean testCondition(XSLTContext xSLTContext) throws XSLException {
        if (this.testExpr == null) {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error2(1009, 1, "test", this.localName);
        }
        return this.testExpr.testBooleanExpr(xSLTContext);
    }
}

