/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.util.FastVector;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLEventHandler
implements XSLConstants {
    ContentHandler xmlHandler;
    LexicalHandler lexHandler;
    XSLTContext context;
    XMLError err;
    String qname;
    String localname;
    String namespace;
    SAXAttrList attrList;
    Hashtable attrHash;
    String strData;
    char[] charData;
    int size;
    int charlen;
    int currentAttrIndex;
    int currentDataType;
    int currentState;
    int previousState;
    FastVector prefixVect;
    FastVector namespaceVect;
    int[] nspStack;
    int nspIndex = 0;
    static final int NONE = 0;
    static final int CHAR_DATA = 1;
    static final int STR_DATA = 2;
    static final int ELEMENT = 1;
    static final int START_ELEMENT = 2;
    static final int ATTRIBUTE = 3;
    static final int PI = 4;
    static final int COMMENT = 5;
    static final int MESSAGE = 6;

    public XSLEventHandler() {
        this.init();
    }

    public XSLEventHandler(ContentHandler contentHandler, LexicalHandler lexicalHandler, XSLTContext xSLTContext) throws XSLException {
        this.xmlHandler = contentHandler;
        this.lexHandler = lexicalHandler;
        this.context = xSLTContext;
        this.err = xSLTContext.getError();
        try {
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).init();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        this.init();
    }

    void attribute(String string, String string2, String string3, String string4) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startAttribute(string, string2, string3);
        this.strData = string4;
        this.currentDataType = 2;
        this.endAttribute(string, string2, string3);
    }

    void characters(String string, boolean bl) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
            this.currentState = 1;
        }
        if (this.currentState == 1) {
            int n = string.length();
            if (n == 0) {
                return;
            }
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            try {
                if (bl) {
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(true);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(true);
                    }
                    this.xmlHandler.characters(cArray, 0, n);
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(false);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(false);
                    }
                } else {
                    this.xmlHandler.characters(cArray, 0, n);
                }
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
            return;
        }
        switch (this.currentDataType) {
            case 0: {
                this.strData = string;
                this.currentDataType = 2;
                break;
            }
            case 2: {
                int n = this.strData.length();
                if (this.size < n) {
                    this.size *= 2;
                    this.size = n > this.size ? n : this.size;
                    this.charData = new char[this.size];
                }
                this.strData.getChars(0, n, this.charData, 0);
                this.charlen = n;
            }
            case 1: {
                this.currentDataType = 1;
                int n = string.length();
                int n2 = this.charlen + n;
                if (this.size < n2) {
                    this.size *= 2;
                    this.size = n2 > this.size ? n2 : this.size;
                    char[] cArray = new char[this.size];
                    System.arraycopy(this.charData, 0, cArray, 0, this.charlen);
                    this.charData = cArray;
                }
                string.getChars(0, n, this.charData, this.charlen);
                this.charlen += n;
                break;
            }
        }
    }

    void characters(char[] cArray, int n, int n2, boolean bl) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
            this.currentState = 1;
        }
        if (this.currentState == 1) {
            try {
                if (bl) {
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(true);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(true);
                    }
                    this.xmlHandler.characters(cArray, n, n2);
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(false);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(false);
                    }
                } else {
                    this.xmlHandler.characters(cArray, n, n2);
                }
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
            return;
        }
        switch (this.currentDataType) {
            case 0: {
                this.currentDataType = 1;
                if (this.size < n2) {
                    this.size *= 2;
                    this.size = n2 > this.size ? n2 : this.size;
                    this.charData = new char[this.size];
                }
                System.arraycopy(cArray, n, this.charData, 0, n2);
                this.charlen = n2;
                break;
            }
            case 2: {
                int n3 = this.strData.length();
                if (this.size < n3) {
                    this.size *= 2;
                    this.size = n3 > this.size ? n3 : this.size;
                    this.charData = new char[this.size];
                }
                this.strData.getChars(0, n3, this.charData, 0);
                this.charlen = n3;
            }
            case 1: {
                this.currentDataType = 1;
                int n4 = this.charlen + n2;
                if (this.size < n4) {
                    this.size *= 2;
                    this.size = n4 > this.size ? n4 : this.size;
                    char[] cArray2 = new char[this.size];
                    System.arraycopy(this.charData, 0, cArray2, 0, this.charlen);
                    this.charData = cArray2;
                }
                System.arraycopy(cArray, n, this.charData, this.charlen, n2);
                this.charlen += n2;
                break;
            }
        }
    }

    void comment(String string) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startComment();
        this.strData = string;
        this.currentDataType = 2;
        this.endComment();
    }

    void endAttribute(String string, String string2, String string3) throws XSLException {
        if (this.currentState != 3) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 2;
        this.attrList.values[this.currentAttrIndex] = this.getData();
        this.currentDataType = 0;
    }

    void endComment() throws XSLException {
        if (this.currentState != 5) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 1;
        String string = this.getData();
        if (string.indexOf("--") == -1 && !string.endsWith("-")) {
            int n = string.length();
            if (n == 0) {
                return;
            }
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            try {
                this.lexHandler.comment(cArray, 0, n);
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
        } else {
            this.err.error1(1012, 1, string);
        }
    }

    void endElement(String string, String string2, String string3) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error0(1900, 1);
            }
        }
        int n = this.nspStack[this.nspIndex - 1];
        int n2 = this.prefixVect.size();
        try {
            int n3 = n;
            while (n3 < n2) {
                this.xmlHandler.endPrefixMapping((String)this.prefixVect.elementAt(n3));
                ++n3;
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        --this.nspIndex;
        this.prefixVect.setSize(this.nspStack[this.nspIndex]);
        this.namespaceVect.setSize(this.nspStack[this.nspIndex]);
        this.currentState = 1;
        try {
            String string4 = string.equals("") ? string2 : String.valueOf(string) + ":" + string2;
            this.xmlHandler.endElement(string3, string2, string4);
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void endMessage() throws XSLException {
        if (this.currentState != 6) {
            this.err.error0(1900, 1);
        }
        this.currentState = this.previousState;
        String string = this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        Locator locator = this.err.getLocator();
        String string2 = locator.getSystemId();
        int n = locator.getLineNumber();
        int n2 = locator.getColumnNumber();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (n != 0 && n2 != 0) {
            stringBuffer.append("<Line " + n + ", Column " + n2 + ">");
            stringBuffer.append(": ");
            System.out.println(stringBuffer.toString());
        } else if (string2 != null) {
            stringBuffer.append(": ");
            System.out.println(stringBuffer.toString());
        }
        System.out.println("Message: " + string);
    }

    void endProcessingInstruction(String string) throws XSLException {
        if (this.currentState != 4) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 1;
        String string2 = this.getData();
        if (string2.indexOf("?>") == -1) {
            try {
                this.xmlHandler.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
        } else {
            this.err.error1(1011, 1, string2);
        }
    }

    void flushEvents() throws XSLException {
    }

    String getData() {
        String string = "";
        string = this.currentDataType == 2 ? this.strData : new String(this.charData, 0, this.charlen);
        this.currentDataType = 0;
        this.charlen = 0;
        return string;
    }

    void growNamespaceStack() {
        int n = this.nspStack.length;
        int[] nArray = new int[n * 2];
        System.arraycopy(this.nspStack, 0, nArray, 0, n);
        this.nspStack = nArray;
    }

    void init() {
        this.prefixVect = new FastVector(16);
        this.namespaceVect = new FastVector(16);
        this.nspStack = new int[16];
        this.nspIndex = 0;
        this.currentDataType = 0;
        this.currentState = 1;
        this.attrList = new SAXAttrList(4);
        this.attrHash = new Hashtable(20);
        this.size = 1024;
        this.charData = new char[1024];
        this.charlen = 0;
    }

    void message(String string) throws XSLException {
        this.startMessage();
        this.strData = string;
        this.currentDataType = 2;
        this.endMessage();
    }

    void namespaceAttr(String string, String string2) throws XSLException {
        int n = this.prefixVect.size();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            String string3 = this.prefixVect.elementAt(n2).toString();
            if (string3.equals(string)) {
                bl = true;
                String string4 = this.namespaceVect.elementAt(n2).toString();
                if (!string4.equals(string2)) break;
                return;
            }
            --n2;
        }
        this.prefixVect.addElement(string);
        this.namespaceVect.addElement(string2);
        if (string == "") {
            if (bl || string2 != "") {
                this.attribute(string, "xmlns", "http://www.w3.org/2000/xmlns/", string2);
            }
        } else {
            this.attribute("xmlns", string, "http://www.w3.org/2000/xmlns/", string2);
        }
        try {
            this.xmlHandler.startPrefixMapping(string, string2);
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void processingInstruction(String string, String string2) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startProcessingInstruction(string);
        this.strData = string2;
        this.currentDataType = 2;
        this.endProcessingInstruction(string);
    }

    void reportStartElement() throws XSLException {
        try {
            this.xmlHandler.startElement(this.namespace, this.localname, this.qname, this.attrList);
            this.attrList.reset();
            this.attrHash.clear();
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    public void reset(ContentHandler contentHandler, LexicalHandler lexicalHandler, XSLTContext xSLTContext) throws XSLException {
        this.xmlHandler = contentHandler;
        this.lexHandler = lexicalHandler;
        this.context = xSLTContext;
        this.err = xSLTContext.getError();
        try {
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).init();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        this.prefixVect.setSize(0);
        this.namespaceVect.setSize(0);
        this.currentDataType = 0;
        this.currentState = 1;
        this.attrList.reset();
        this.attrHash.clear();
        this.charlen = 0;
        this.nspIndex = 0;
    }

    void startAttribute(String string, String string2, String string3) throws XSLException {
        if (this.currentState != 2) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error2(1047, 1, this.stateToString(3), this.stateToString(this.currentState));
        }
        this.currentState = 3;
        this.currentAttrIndex = -1;
        if (this.attrHash.get(string2) != null) {
            this.currentAttrIndex = this.attrList.getIndex(string3, string2);
        }
        if (this.currentAttrIndex == -1) {
            this.attrHash.put(string2, string2);
            String string4 = string.equals("") ? string2 : String.valueOf(string) + ":" + string2;
            this.attrList.addAttr(string, string2, string4, "", true, 0, string3);
            this.currentAttrIndex = this.attrList.getLength() - 1;
        }
    }

    void startComment() throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(5), this.stateToString(this.currentState));
            }
        }
        this.currentState = 5;
    }

    void startElement(String string, String string2, String string3) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(1), this.stateToString(this.currentState));
            }
        }
        if (this.nspIndex == this.nspStack.length) {
            this.growNamespaceStack();
        }
        this.nspStack[this.nspIndex++] = this.prefixVect.size();
        this.currentState = 2;
        this.qname = string.equals("") ? string2 : String.valueOf(string) + ":" + string2;
        this.localname = string2;
        this.namespace = string3;
    }

    void startMessage() throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        }
        this.previousState = this.currentState;
        this.currentState = 6;
    }

    void startProcessingInstruction(String string) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(4), this.stateToString(this.currentState));
            }
        }
        this.currentState = 4;
    }

    String stateToString(int n) {
        switch (n) {
            case 1: {
                return "Element";
            }
            case 2: {
                return "Start element";
            }
            case 3: {
                return "Attribute";
            }
            case 4: {
                return "PI";
            }
            case 5: {
                return "Comment";
            }
            case 6: {
                return "Message";
            }
        }
        return "";
    }
}

