/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.math.BigDecimal;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprConstants;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XSLExprValue
implements XSLExprConstants {
    int type;
    boolean boolvalue;
    String stringvalue;
    XSLNodeList nodelist;
    double numbervalue;
    BigDecimal m_mathBigDecimal;
    XMLDocumentFragment resultTree;
    Object object;
    static final String BOOLEAN = "boolean";
    static final String NODESET = "node-set";
    static final String NUMBER = "number";
    static final String STRING = "string";
    static final String RESULTTREE = "result tree fragment";

    public XSLExprValue(double d, BigDecimal bigDecimal) {
        this.type = -122;
        this.numbervalue = d;
        this.m_mathBigDecimal = bigDecimal;
    }

    public XSLExprValue(Object object) {
        if (object instanceof XMLDocumentFragment) {
            this.type = -124;
            this.resultTree = (XMLDocumentFragment)object;
        } else if (object instanceof XSLNodeList) {
            this.type = -123;
            this.nodelist = (XSLNodeList)object;
        } else if (object instanceof NodeList) {
            this.type = -123;
            this.nodelist = new XSLNodeList((NodeList)object);
        } else if (object instanceof String) {
            this.type = -121;
            this.stringvalue = (String)object;
        } else if (object instanceof Number) {
            this.type = -122;
            this.numbervalue = ((Number)object).doubleValue();
            if (this.numbervalue > 9.223372036854776E18) {
                this.m_mathBigDecimal = new BigDecimal(this.numbervalue);
            }
        } else if (object instanceof Boolean) {
            this.type = -120;
            this.boolvalue = (Boolean)object;
        } else {
            this.type = -125;
            this.object = object;
        }
    }

    public XSLExprValue(String string) {
        this.type = -121;
        this.stringvalue = string;
    }

    public XSLExprValue(XMLDocumentFragment xMLDocumentFragment) {
        this.type = -124;
        this.resultTree = xMLDocumentFragment;
    }

    public XSLExprValue(XSLNodeList xSLNodeList) {
        this.type = -123;
        this.nodelist = xSLNodeList;
    }

    public XSLExprValue(boolean bl) {
        this.type = -120;
        this.boolvalue = bl;
    }

    public static double arithmetic(XSLExprValue xSLExprValue, XSLExprValue xSLExprValue2, int n) throws XPathException {
        double d = xSLExprValue.getNumberValue();
        double d2 = xSLExprValue2.getNumberValue();
        switch (n) {
            case 45: {
                return d - d2;
            }
            case 43: {
                return d + d2;
            }
            case 42: {
                return d * d2;
            }
            case -73: {
                return d / d2;
            }
            case -74: {
                return d % d2;
            }
        }
        return 0.0;
    }

    boolean checkType(Class clazz) throws XPathException {
        String string = clazz.getName();
        boolean bl = false;
        try {
            switch (this.type) {
                case -122: 
                case -121: 
                case -120: {
                    if (clazz.isAssignableFrom(Class.forName("java.lang.String")) || clazz.isAssignableFrom(Class.forName("java.lang.Float")) || clazz.isAssignableFrom(Class.forName("java.lang.Double")) || clazz.isAssignableFrom(Class.forName("java.lang.Integer")) || clazz.isAssignableFrom(Class.forName("java.lang.Boolean")) || string.equals("int") || string.equals("float") || string.equals("double") || string.equals(BOOLEAN)) {
                        bl = true;
                    }
                    break;
                }
                case -123: {
                    if (clazz.isAssignableFrom(Class.forName("java.lang.String")) || clazz.isAssignableFrom(Class.forName("java.lang.Float")) || clazz.isAssignableFrom(Class.forName("java.lang.Double")) || clazz.isAssignableFrom(Class.forName("java.lang.Integer")) || clazz.isAssignableFrom(Class.forName("java.lang.Boolean")) || clazz.isAssignableFrom(Class.forName("oracle.xml.parser.v2.XSLNodeList")) || clazz.isAssignableFrom(Class.forName("oracle.xml.parser.v2.XMLNodeList")) || string.equals("int") || string.equals("float") || string.equals("double") || string.equals(BOOLEAN)) {
                        bl = true;
                    }
                    break;
                }
                case -124: {
                    if (clazz.isAssignableFrom(Class.forName("java.lang.String")) || clazz.isAssignableFrom(Class.forName("java.lang.Float")) || clazz.isAssignableFrom(Class.forName("java.lang.Double")) || clazz.isAssignableFrom(Class.forName("java.lang.Integer")) || clazz.isAssignableFrom(Class.forName("java.lang.Boolean")) || clazz.isAssignableFrom(Class.forName("oracle.xml.parser.v2.XMLDocumentFragment")) || string.equals("int") || string.equals("float") || string.equals("double") || string.equals(BOOLEAN)) {
                        bl = true;
                    }
                    break;
                }
                case -125: {
                    if (clazz.isAssignableFrom(this.object.getClass())) {
                        bl = true;
                    }
                    break;
                }
                default: {
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        return bl;
    }

    public static boolean compare(XSLExprValue xSLExprValue, XSLExprValue xSLExprValue2, int n) throws XPathException {
        if (xSLExprValue.type == -123 || xSLExprValue2.type == -123) {
            boolean bl;
            XSLExprValue xSLExprValue3;
            XSLExprValue xSLExprValue4;
            if (xSLExprValue.type == -123) {
                xSLExprValue4 = xSLExprValue;
                xSLExprValue3 = xSLExprValue2;
                bl = false;
            } else {
                xSLExprValue4 = xSLExprValue2;
                xSLExprValue3 = xSLExprValue;
                bl = true;
            }
            XSLNodeList xSLNodeList = xSLExprValue4.getNodeList();
            int n2 = xSLNodeList.getLength();
            switch (xSLExprValue3.type) {
                case -123: {
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = ((XMLNode)xSLNodeList.item(n3)).getText();
                        int n4 = 0;
                        while (n4 < xSLExprValue3.getNodeList().getLength()) {
                            if (XSLExprValue.compareString(string, ((XMLNode)xSLExprValue3.getNodeList().item(n4)).getText(), n, bl)) {
                                return true;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    return false;
                }
                case -122: {
                    int n5 = 0;
                    while (n5 < n2) {
                        String string = ((XMLNode)xSLNodeList.item(n5)).getText();
                        double d = 0.0;
                        try {
                            Double d2 = new Double(string);
                            d = d2;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                        if (XSLExprValue.compareDouble(d, xSLExprValue3.getNumberValue(), n, bl)) {
                            return true;
                        }
                        ++n5;
                    }
                    return false;
                }
                case -121: {
                    String string = xSLExprValue3.getStringValue();
                    int n6 = 0;
                    while (n6 < n2) {
                        String string2 = ((XMLNode)xSLNodeList.item(n6)).getText();
                        if (XSLExprValue.compareString(string2, string, n, bl)) {
                            return true;
                        }
                        ++n6;
                    }
                    return false;
                }
                case -120: {
                    return XSLExprValue.compareBoolean(xSLExprValue4.getBooleanValue(), xSLExprValue3.getBooleanValue(), n, bl);
                }
            }
        }
        if (n == 61 || n == -61) {
            if (xSLExprValue.type == -120 || xSLExprValue2.type == -120) {
                return XSLExprValue.compareBoolean(xSLExprValue.getBooleanValue(), xSLExprValue2.getBooleanValue(), n, false);
            }
            if (xSLExprValue.type == -122 || xSLExprValue2.type == -122) {
                return XSLExprValue.compareDouble(xSLExprValue.getNumberValue(), xSLExprValue2.getNumberValue(), n, false);
            }
            return XSLExprValue.compareString(xSLExprValue.getStringValue(), xSLExprValue2.getStringValue(), n, false);
        }
        return XSLExprValue.compareDouble(xSLExprValue.getNumberValue(), xSLExprValue2.getNumberValue(), n, false);
    }

    private static boolean compareBoolean(boolean bl, boolean bl2, int n, boolean bl3) {
        if (bl3) {
            bl ^= true;
            bl2 ^= true;
        }
        switch (n) {
            case 61: {
                return bl == bl2;
            }
            case -61: {
                return bl != bl2;
            }
            case 60: {
                return !bl && bl2;
            }
            case -53: {
                return (bl && !bl2) ^ true;
            }
            case 62: {
                return bl && !bl2;
            }
            case -54: {
                return (!bl && bl2) ^ true;
            }
        }
        return false;
    }

    private static boolean compareDouble(double d, double d2, int n, boolean bl) {
        switch (n) {
            case 61: {
                return d == d2;
            }
            case -61: {
                return d != d2;
            }
            case 60: {
                if (bl) {
                    return d2 < d;
                }
                return d < d2;
            }
            case -53: {
                if (bl) {
                    return d2 <= d;
                }
                return d <= d2;
            }
            case 62: {
                if (bl) {
                    return d2 > d;
                }
                return d > d2;
            }
            case -54: {
                if (bl) {
                    return d2 >= d;
                }
                return d >= d2;
            }
        }
        return false;
    }

    private static boolean compareString(String string, String string2, int n, boolean bl) {
        switch (n) {
            case 61: {
                return string.equals(string2);
            }
            case -61: {
                return string.equals(string2) ^ true;
            }
            case 60: {
                if (bl) {
                    return string.compareTo(string2) > 0;
                }
                return string.compareTo(string2) < 0;
            }
            case -53: {
                if (bl) {
                    return string.compareTo(string2) >= 0;
                }
                return string.compareTo(string2) <= 0;
            }
            case 62: {
                if (bl) {
                    return string.compareTo(string2) < 0;
                }
                return string.compareTo(string2) > 0;
            }
            case -54: {
                if (bl) {
                    return string.compareTo(string2) <= 0;
                }
                return string.compareTo(string2) >= 0;
            }
        }
        return false;
    }

    Object convertType(Class clazz) throws XPathException {
        String string = clazz.getName();
        try {
            if (string.equals("java.lang.String")) {
                return this.getStringValue();
            }
            if (string.equals("java.lang.Float") || string.equals("float")) {
                return new Float(this.getNumberValue());
            }
            if (string.equals("java.lang.Double") || string.equals("double")) {
                return new Double(this.getNumberValue());
            }
            if (string.equals("java.lang.Integer") || string.equals("int")) {
                return new Integer((int)this.getNumberValue());
            }
            if (string.equals("java.lang.Boolean") || string.equals(BOOLEAN)) {
                return new Boolean(this.getBooleanValue());
            }
            if (string.equals("java.lang.Object")) {
                switch (this.type) {
                    case -121: {
                        return this.getStringValue();
                    }
                    case -122: {
                        return new Double(this.getNumberValue());
                    }
                    case -120: {
                        return new Boolean(this.getBooleanValue());
                    }
                    case -123: {
                        return this.getNodeList();
                    }
                    case -124: {
                        return this.getResultTreeValue();
                    }
                    case -125: {
                        return this.object;
                    }
                }
            }
            if (this.type == -123) {
                return this.getNodeList();
            }
            if (this.type == -124) {
                return this.getResultTreeValue();
            }
            return this.object;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    void copyValue(XSLExprValue xSLExprValue) throws XSLException {
        this.type = xSLExprValue.type;
        switch (this.type) {
            case -120: {
                this.boolvalue = xSLExprValue.boolvalue;
                break;
            }
            case -123: {
                this.nodelist = xSLExprValue.nodelist;
                break;
            }
            case -122: {
                this.numbervalue = xSLExprValue.numbervalue;
                this.m_mathBigDecimal = xSLExprValue.m_mathBigDecimal;
                break;
            }
            case -121: {
                this.stringvalue = xSLExprValue.stringvalue;
                break;
            }
            case -124: {
                this.resultTree = xSLExprValue.resultTree;
                break;
            }
            case -125: {
                this.object = xSLExprValue.object;
                break;
            }
        }
    }

    public BigDecimal getBigDecimalValue() throws XPathException {
        switch (this.type) {
            case -121: {
                this.m_mathBigDecimal = new BigDecimal(this.stringvalue);
                break;
            }
        }
        return this.m_mathBigDecimal;
    }

    public boolean getBooleanValue() throws XPathException {
        switch (this.type) {
            case -120: {
                return this.boolvalue;
            }
            case -123: {
                return this.nodelist.getLength() != 0;
            }
            case -122: {
                if (Double.isNaN(this.numbervalue)) {
                    return false;
                }
                return this.numbervalue != 0.0;
            }
            case -121: {
                return this.stringvalue.length() != 0;
            }
            case -124: {
                return this.resultTree.getFirstChild() != null;
            }
        }
        return false;
    }

    public XSLNodeList getNodeList() throws XPathException {
        if (this.type != -123) {
            throw new XPathException(1036, this.getTypeString());
        }
        return this.nodelist;
    }

    public double getNumberValue() throws XPathException {
        switch (this.type) {
            case -120: {
                if (this.boolvalue) {
                    return 1.0;
                }
                return 0.0;
            }
            case -124: 
            case -123: {
                try {
                    Double d = new Double(this.getStringValue());
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
            case -121: {
                try {
                    Double d = new Double(this.stringvalue);
                    if (d > 9.223372036854776E18) {
                        return 0.0;
                    }
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
            case -122: {
                return this.numbervalue;
            }
        }
        return 0.0;
    }

    public XMLDocumentFragment getResultTreeValue() throws XPathException {
        switch (this.type) {
            case -124: {
                return this.resultTree;
            }
        }
        return null;
    }

    public String getStringValue() throws XPathException {
        switch (this.type) {
            case -120: {
                if (this.boolvalue) {
                    return "true";
                }
                return "false";
            }
            case -123: {
                if (this.nodelist.getLength() == 0) {
                    return "";
                }
                XMLNode xMLNode = (XMLNode)this.nodelist.item(0);
                return xMLNode.getText();
            }
            case -122: {
                if (this.numbervalue == 0.0 && this.m_mathBigDecimal != null) {
                    String string = this.m_mathBigDecimal.toString();
                    return string;
                }
                long l = Math.round(this.numbervalue);
                if ((double)l == this.numbervalue) {
                    Long l2 = new Long((long)this.numbervalue);
                    return l2.toString();
                }
                Double d = new Double(this.numbervalue);
                return d.toString();
            }
            case -121: {
                return this.stringvalue;
            }
            case -124: {
                return this.resultTree.getText();
            }
            case -125: {
                if (!(this.object instanceof String)) break;
                return (String)this.object;
            }
        }
        return "";
    }

    String getTypeString() {
        switch (this.type) {
            case -120: {
                return BOOLEAN;
            }
            case -123: {
                return NODESET;
            }
            case -122: {
                return NUMBER;
            }
            case -121: {
                return STRING;
            }
            case -124: {
                return RESULTTREE;
            }
            case -125: {
                return this.object.getClass().getName();
            }
        }
        return null;
    }

    public static void insertList(XSLNodeList xSLNodeList, XSLNodeList xSLNodeList2) throws XPathException {
        if (xSLNodeList == null || xSLNodeList2 == null) {
            return;
        }
        int n = 0;
        while (n < xSLNodeList2.getLength()) {
            xSLNodeList.addNode(xSLNodeList2.item(n));
            ++n;
        }
    }

    void mergeList(XSLExprValue xSLExprValue) throws XPathException {
        XSLNodeList xSLNodeList = this.getNodeList();
        XSLNodeList xSLNodeList2 = xSLExprValue.getNodeList();
        XSLExprValue.mergeList(xSLNodeList, xSLNodeList2);
    }

    public static void mergeList(XSLNodeList xSLNodeList, XSLNodeList xSLNodeList2) throws XPathException {
        int n = xSLNodeList2.getLength();
        if (n <= 0) {
            return;
        }
        int n2 = xSLNodeList.getLength();
        if (n2 == 0) {
            int n3 = ((XMLNode)xSLNodeList2.item((int)0)).docOrderId;
            int n4 = 0;
            while (n4 < n) {
                Node node = xSLNodeList2.item(n4);
                if (n3 > ((XMLNode)node).docOrderId) {
                    int n5 = n4;
                    while (n5 < n) {
                        XSLExprValue.mergeNode(xSLNodeList, xSLNodeList2.item(n5));
                        ++n5;
                    }
                    break;
                }
                n3 = ((XMLNode)node).docOrderId;
                xSLNodeList.addNode(node);
                ++n4;
            }
            return;
        }
        int n6 = 0;
        while (n6 < n) {
            XSLExprValue.mergeNode(xSLNodeList, xSLNodeList2.item(n6));
            ++n6;
        }
    }

    public static void mergeNode(XSLNodeList xSLNodeList, Node node) throws XPathException {
        int n = xSLNodeList.getLength();
        int n2 = 0;
        int n3 = ((XMLNode)node).docOrderId;
        while (n2 < n && ((XMLNode)xSLNodeList.item((int)n2)).docOrderId <= n3) {
            ++n2;
        }
        if ((XMLNode)xSLNodeList.item(n2 - 1) != node) {
            xSLNodeList.insertNode(node, n2);
        }
    }

    public static String normalizeString(String string) throws XPathException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && Character.isWhitespace(cArray[n3])) {
            ++n3;
        }
        while (true) {
            if (n3 < n && !Character.isWhitespace(cArray[n3])) {
                cArray2[n2++] = cArray[n3++];
                continue;
            }
            while (n3 < n && Character.isWhitespace(cArray[n3])) {
                ++n3;
            }
            if (n3 == n) break;
            cArray2[n2++] = 32;
        }
        return new String(cArray2, 0, n2);
    }

    void reset() {
        if (this.nodelist != null) {
            this.nodelist.reset();
        }
    }

    public static NSNameImpl resolveQname(String string, NSResolver nSResolver) {
        String[] stringArray = new String[2];
        String string2 = "";
        XSLExprValue.splitQname(string, stringArray);
        if (stringArray[1] != "") {
            string2 = nSResolver.resolveNamespacePrefix(stringArray[1]);
        }
        return new NSNameImpl(stringArray[1], stringArray[0], string2);
    }

    void setBooleanValue(boolean bl) throws XPathException {
        this.type = -120;
        this.boolvalue = bl;
    }

    void setDocumentFragmentValue(XMLDocumentFragment xMLDocumentFragment) throws XPathException {
        this.type = -124;
        this.resultTree = xMLDocumentFragment;
    }

    void setExtensionValue(Object object) throws XPathException {
        if (object instanceof XMLDocumentFragment) {
            this.type = -124;
            this.resultTree = (XMLDocumentFragment)object;
        } else if (object instanceof XSLNodeList) {
            this.type = -123;
            this.nodelist = (XSLNodeList)object;
        } else if (object instanceof NodeList) {
            this.type = -123;
            this.nodelist = new XSLNodeList((NodeList)object);
        } else if (object instanceof String) {
            this.type = -121;
            this.stringvalue = (String)object;
        } else if (object instanceof Number) {
            this.type = -122;
            this.numbervalue = ((Number)object).doubleValue();
            if (this.numbervalue > 9.223372036854776E18) {
                this.m_mathBigDecimal = new BigDecimal(this.numbervalue);
            }
        } else if (object instanceof Boolean) {
            this.type = -120;
            this.boolvalue = (Boolean)object;
        } else {
            this.type = -125;
            this.object = object;
        }
    }

    void setNodeList(XSLNodeList xSLNodeList) throws XPathException {
        this.type = -123;
        this.nodelist = xSLNodeList;
    }

    void setNumberValue(double d) throws XPathException {
        this.type = -122;
        this.numbervalue = d;
    }

    void setNumberValue(double d, BigDecimal bigDecimal) throws XPathException {
        this.type = -122;
        this.numbervalue = d;
        this.m_mathBigDecimal = bigDecimal;
    }

    void setStringValue(String string) throws XPathException {
        this.type = -121;
        this.stringvalue = string;
    }

    public static void splitQname(String string, String[] stringArray) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && cArray[n3] != ':') {
            ++n3;
        }
        if (n3 < n) {
            stringArray[1] = new String(cArray, n2, n3 - n2);
            stringArray[1] = stringArray[1].intern();
            stringArray[0] = new String(cArray, ++n3, n - n3);
            stringArray[0] = stringArray[0].intern();
        } else {
            stringArray[0] = string.intern();
            stringArray[1] = "";
        }
    }

    static void tokenize(String string, FastVector fastVector) throws XPathException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            if (n2 < n && Character.isWhitespace(cArray[n2])) {
                ++n2;
                continue;
            }
            if (n2 == n) break;
            int n3 = n2;
            while (n2 < n && !Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            String string2 = new String(cArray, n3, n2 - n3);
            fastVector.addElement(string2);
        }
    }

    public static String translateString(String string, String string2, String string3) throws XPathException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string2.indexOf(string.charAt(n3));
            if (n4 != -1) {
                if (n4 <= string3.length() - 1) {
                    cArray2[n2++] = string3.charAt(n4);
                }
            } else {
                cArray2[n2++] = cArray[n3];
            }
            ++n3;
        }
        return new String(cArray2, 0, n2);
    }
}

