/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLNodeSetInt;
import oracle.xml.parser.v2.XSLPatternInt;
import oracle.xml.parser.v2.XSLSourceContext;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

class XSLKey
extends XSLNode
implements XSLConstants,
Cloneable {
    private NSName name;
    private XSLPatternInt pattern;
    private XSLNodeSetInt useExpr;
    private XSLNodeList emptList;

    XSLKey(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
    }

    private void addToTable(Hashtable hashtable, String string, XMLNode xMLNode) throws XSLException {
        XSLNodeList xSLNodeList = (XSLNodeList)hashtable.get(string);
        if (xSLNodeList == null) {
            XSLNodeList xSLNodeList2 = new XSLNodeList();
            xSLNodeList2.addNode(xMLNode);
            hashtable.put(string, xSLNodeList2);
        } else {
            XSLExprValue.mergeNode(xSLNodeList, xMLNode);
        }
    }

    public XSLNodeList getMatchingNodes(XSLTContext xSLTContext, String string, XMLNode xMLNode) throws XSLException {
        Cloneable cloneable;
        XMLElement xMLElement = xMLNode.getSrcRoot();
        XSLSourceContext xSLSourceContext = xSLTContext.getSrcContext(xMLElement);
        Hashtable hashtable = xSLSourceContext.getKeyTable(this.name);
        if (hashtable == null) {
            hashtable = new Hashtable(20);
            xSLSourceContext.setKeyTable(this.name, hashtable);
            cloneable = xSLTContext.getContextNode();
            int n = xSLTContext.getContextSize();
            int n2 = xSLTContext.getContextPosition();
            this.updateHashtable(hashtable, xMLElement, xSLTContext);
            xSLTContext.setContextNode((XMLNode)cloneable);
            xSLTContext.setContextSize(n);
            xSLTContext.setContextPosition(n2);
        }
        if ((cloneable = (XSLNodeList)hashtable.get(string)) != null) {
            return (XSLNodeList)cloneable.clone();
        }
        if (this.emptList == null) {
            this.emptList = new XSLNodeList();
        }
        return (XSLNodeList)this.emptList.clone();
    }

    public NSName getName() {
        return this.name;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (string == "") {
            if (string3 == "match") {
                this.pattern = XSLExprBase.createPattern(string4, this, false, this.xss);
            } else if (string3 == "use") {
                this.useExpr = XSLExprBase.createNodeSetExpr(string4, this, this.xss);
            } else if (string3 == "name") {
                this.name = this.resolveQname(string4);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    public void startContent() throws XSLException {
        if (this.pattern == null) {
            this.xss.err.error2(1009, 1, "match", this.getQualifiedName());
        }
        if (this.useExpr == null) {
            this.xss.err.error2(1009, 1, "use", this.getQualifiedName());
        }
        if (this.name == null) {
            this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
        }
    }

    private void updateHashtable(Hashtable hashtable, XMLNode xMLNode, XSLTContext xSLTContext) throws XSLException {
        Object object;
        if (this.pattern.matchPattern(xMLNode, -1000.0f, xSLTContext) != null) {
            xSLTContext.setContextSize(1);
            xSLTContext.setContextPosition(1);
            xSLTContext.setContextNode(xMLNode);
            object = this.useExpr.getValue(xSLTContext);
            if (((XSLExprValue)object).type == -123) {
                NodeList nodeList = this.useExpr.getSelectedNodes(xSLTContext);
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.addToTable(hashtable, ((XMLNode)nodeList.item(n)).getText(), xMLNode);
                    ++n;
                }
            } else {
                String string = this.useExpr.getStringValue(xSLTContext);
                this.addToTable(hashtable, string, xMLNode);
            }
        }
        if (xMLNode instanceof XMLElement) {
            int n;
            int n2;
            object = xMLNode.getChildNodes();
            NamedNodeMap namedNodeMap = xMLNode.getAttributes();
            if (namedNodeMap != null) {
                n2 = namedNodeMap.getLength();
                n = 0;
                while (n < n2) {
                    this.updateHashtable(hashtable, (XMLNode)namedNodeMap.item(n), xSLTContext);
                    ++n;
                }
            }
            if (object != null) {
                n2 = object.getLength();
                n = 0;
                while (n < n2) {
                    this.updateHashtable(hashtable, (XMLNode)object.item(n), xSLTContext);
                    ++n;
                }
            }
        }
    }
}

