/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExtensionElement;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLOutput;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.util.FastVector;

class XSLResultElement
extends XSLNode
implements XSLConstants {
    private FastVector attrPrefixVec;
    private FastVector attrLocalNameVec;
    private FastVector attrNamespaceVec;
    private FastVector attrValueVec;
    private FastVector nsKeyVec;
    private FastVector nsValVec;
    private String oraOutputName;
    private XSLNode.AttrValueTmpl oraOutputHrefVal;
    private XSLOutput oraXSLOutput;
    private XSLExtensionElement extElem;

    XSLResultElement(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 7;
    }

    private boolean excludeResultNamespace(String string) {
        if (this.exclResPrefixes == null) {
            return false;
        }
        int n = this.exclResPrefixes.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.exclResPrefixes.elementAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void finalize() throws XSLException {
        Object object;
        super.finalize();
        if (this.prefixHash != null) {
            object = this.prefixHash.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = (String)this.prefixHash.get(string);
                if (string2 == "http://www.w3.org/1999/XSL/Transform") continue;
                String string3 = this.xss.getNamespaceAlias(string2);
                if (string3 == null) {
                    string3 = string2;
                }
                if (this.excludeResultNamespace(string3)) continue;
                if (string == "#default") {
                    string = "";
                }
                if (this.nsKeyVec == null) {
                    this.nsKeyVec = new FastVector();
                    this.nsValVec = new FastVector();
                }
                this.nsKeyVec.addElement(string);
                this.nsValVec.addElement(string3);
            }
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output") {
            this.oraXSLOutput = this.xss.getOutput(this.oraOutputName);
            if (this.oraXSLOutput == null) {
                this.xss.err.error2(1030, 1, this.oraOutputName, "output");
                return;
            }
            if (this.oraOutputHrefVal == null && (object = this.oraXSLOutput.getOraHref()) != null) {
                XSLResultElement xSLResultElement = this;
                xSLResultElement.getClass();
                this.oraOutputHrefVal = xSLResultElement.new XSLNode.AttrValueTmpl((String)object, this.oraXSLOutput);
            }
            if (this.oraOutputHrefVal == null) {
                this.xss.err.setLocator(this.oraXSLOutput);
                this.xss.err.error2(1009, 1, "href", this.oraXSLOutput.getQualifiedName());
                return;
            }
        }
    }

    XSLNode.AttrValueTmpl getAttrTmpl(String string, String string2) {
        if (this.attrLocalNameVec != null) {
            int n = this.attrLocalNameVec.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.attrLocalNameVec.elementAt(n2).equals(string2) && this.attrNamespaceVec.elementAt(n2).equals(string)) {
                    return (XSLNode.AttrValueTmpl)this.attrValueVec.elementAt(n2);
                }
                ++n2;
            }
        }
        return null;
    }

    String getAttributeTemplateValue(XSLTContext xSLTContext, String string, String string2) throws XSLException {
        XSLNode.AttrValueTmpl attrValueTmpl = this.getAttrTmpl(string, string2);
        if (attrValueTmpl != null) {
            return attrValueTmpl.getValue(xSLTContext);
        }
        return null;
    }

    String getAttributeValue(String string, String string2) {
        XSLNode.AttrValueTmpl attrValueTmpl = this.getAttrTmpl(string, string2);
        if (attrValueTmpl != null) {
            return attrValueTmpl.getAttrValue();
        }
        return null;
    }

    void printAttributes(PrintWriter printWriter) {
        if (this.attrPrefixVec != null) {
            int n = this.attrPrefixVec.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.attrPrefixVec.elementAt(n2);
                if (string != "") {
                    string = String.valueOf(string) + ":";
                }
                printWriter.print(" " + string + this.attrLocalNameVec.elementAt(n2) + "=\"" + this.attrValueVec.elementAt(n2) + "\"");
                ++n2;
            }
        }
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        int n;
        int n2;
        Object object;
        Object object2;
        if (this.extElem != null || this.xss.isExtensionNamespace(this.namespace)) {
            if (this.extElem == null) {
                object2 = this.xss.getExtensionElement(this.namespace, this.localName);
                try {
                    object = Class.forName((String)object2);
                    this.extElem = (XSLExtensionElement)((Class)object).newInstance();
                }
                catch (Exception exception) {
                    this.extElem = null;
                }
            }
            if (this.extElem != null) {
                this.extElem.setXSLNode(this);
                this.extElem.processAction(xSLTContext);
                return;
            }
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output") {
            this.processOraOutput(xSLTContext);
            return;
        }
        object2 = xSLTContext.getEventHandler();
        object = this.xss.getNamespaceAlias(this.namespace);
        if (object == null) {
            object = this.namespace;
        }
        ((XSLEventHandler)object2).startElement(this.prefix, this.localName, (String)object);
        this.processAttrSets(xSLTContext);
        if (this.attrPrefixVec != null) {
            n2 = this.attrPrefixVec.size();
            n = 0;
            while (n < n2) {
                XSLNode.AttrValueTmpl attrValueTmpl = (XSLNode.AttrValueTmpl)this.attrValueVec.elementAt(n);
                ((XSLEventHandler)object2).attribute((String)this.attrPrefixVec.elementAt(n), (String)this.attrLocalNameVec.elementAt(n), (String)this.attrNamespaceVec.elementAt(n), attrValueTmpl.getValue(xSLTContext));
                ++n;
            }
        }
        if (this.nsKeyVec != null) {
            n2 = this.nsKeyVec.size();
            n = 0;
            while (n < n2) {
                ((XSLEventHandler)object2).namespaceAttr((String)this.nsKeyVec.elementAt(n), (String)this.nsValVec.elementAt(n));
                ++n;
            }
        }
        this.processChildren(xSLTContext);
        ((XSLEventHandler)object2).endElement(this.prefix, this.localName, (String)object);
    }

    void processOraOutput(XSLTContext xSLTContext) throws XSLException {
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        String string = "";
        try {
            Object object;
            string = this.oraOutputHrefVal.getValue(xSLTContext);
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null && !((File)(object = new File(string2))).exists()) {
                ((File)object).mkdirs();
            }
            object = new FileOutputStream(file);
            XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver((OutputStream)object, this.oraXSLOutput);
            XSLEventHandler xSLEventHandler2 = new XSLEventHandler(xSLSAXPrintDriver, xSLSAXPrintDriver, xSLTContext);
            xSLTContext.setEventHandler(xSLEventHandler2);
            this.processChildren(xSLTContext);
            xSLSAXPrintDriver.flush();
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error1(1003, 1, string);
        }
        xSLTContext.setEventHandler(xSLEventHandler);
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output") {
            if (string == "") {
                if (string3 == "use") {
                    this.oraOutputName = string4;
                } else if (string3 == "href") {
                    XSLResultElement xSLResultElement = this;
                    xSLResultElement.getClass();
                    this.oraOutputHrefVal = xSLResultElement.new XSLNode.AttrValueTmpl(string4, this);
                }
            }
            return;
        }
        if (string != "http://www.w3.org/1999/XSL/Transform") {
            if (this.attrPrefixVec == null) {
                this.attrPrefixVec = new FastVector();
                this.attrLocalNameVec = new FastVector();
                this.attrNamespaceVec = new FastVector();
                this.attrValueVec = new FastVector();
            }
            this.attrPrefixVec.addElement(string2);
            this.attrLocalNameVec.addElement(string3);
            this.attrNamespaceVec.addElement(string);
            XSLResultElement xSLResultElement = this;
            xSLResultElement.getClass();
            this.attrValueVec.addElement(xSLResultElement.new XSLNode.AttrValueTmpl(string4, this));
        } else if (string3 == "exclude-result-prefixes") {
            this.addResultPrefixes(string4);
        } else if (string3 == "extension-element-prefixes") {
            this.xss.addExtensionNamespace(this, string4);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    public void startContent() throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && this.localName == "output" && this.oraOutputName == null) {
            this.xss.err.error2(1009, 1, "use", this.getQualifiedName());
        }
        XSLNode xSLNode = this.parent;
        FastVector fastVector = null;
        while (xSLNode != null) {
            if (xSLNode.exclResPrefixes != null) {
                fastVector = xSLNode.exclResPrefixes;
                break;
            }
            xSLNode = xSLNode.parent;
        }
        if (fastVector != null) {
            if (this.exclResPrefixes == null) {
                this.exclResPrefixes = fastVector;
            } else {
                int n = fastVector.size();
                int n2 = 0;
                while (n2 < n) {
                    String string = (String)fastVector.elementAt(n2);
                    if (this.exclResPrefixes.indexOf(string) == -1) {
                        this.exclResPrefixes.addElement(string);
                    }
                    ++n2;
                }
            }
        }
    }
}

