/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XSLException;

class XSLSourceContext {
    XMLElement srcRoot;
    Hashtable idHashTable;
    Hashtable entityHashTable;
    Hashtable keyTables;

    XSLSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) throws XSLException {
        this.srcRoot = xMLElement;
        if (xMLDocument == null || !xMLDocument.isDocOrdered()) {
            this.srcRoot.setDocOrder(0);
        }
        if (xMLDocument != null) {
            this.idHashTable = xMLDocument.getIDHashtable();
            DTD dTD = (DTD)xMLDocument.getDoctype();
            if (dTD != null) {
                this.entityHashTable = dTD.entities;
            }
        }
    }

    public XMLElement getIDElement(String string) throws XSLException {
        if (this.idHashTable == null) {
            return null;
        }
        return (XMLElement)this.idHashTable.get(string);
    }

    public Hashtable getKeyTable(NSName nSName) throws XSLException {
        if (this.keyTables == null) {
            return null;
        }
        return (Hashtable)this.keyTables.get(nSName);
    }

    public String getUnparsedEntityUri(String string) throws XSLException {
        if (this.entityHashTable == null) {
            return "";
        }
        XMLEntity xMLEntity = (XMLEntity)this.entityHashTable.get(string);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.ndata == null) {
            return "";
        }
        return xMLEntity.url;
    }

    public void setKeyTable(NSName nSName, Hashtable hashtable) throws XSLException {
        if (this.keyTables == null) {
            this.keyTables = new Hashtable(20);
        }
        this.keyTables.put(nSName, hashtable);
    }
}

