/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.StringTokenizer;
import oracle.xml.parser.v2.WildCard;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;

class XSLSpaceElem
extends XSLNode
implements XSLConstants {
    private boolean preserve;
    private WildCard[] wildCards;
    int importPriority;

    XSLSpaceElem(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
        this.preserve = this.getLocalName() == "preserve-space";
    }

    int getImportPriority() {
        return this.importPriority;
    }

    private static WildCard[] getWildCards(String string) throws XSLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        WildCard[] wildCardArray = new WildCard[n];
        int n2 = 0;
        while (n2 < n) {
            wildCardArray[n2] = new WildCard(stringTokenizer.nextToken());
            ++n2;
        }
        return wildCardArray;
    }

    WildCard matchWildCard(XMLElement xMLElement, float f) {
        int n = this.wildCards.length;
        int n2 = 0;
        while (n2 < n) {
            WildCard wildCard = this.wildCards[n2];
            if (wildCard.match(xMLElement, this, f)) {
                return wildCard;
            }
            ++n2;
        }
        return null;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (string == "" && string3 == "elements") {
            this.wildCards = XSLSpaceElem.getWildCards(string4);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    boolean strip() {
        return this.preserve ^ true;
    }
}

