/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

public class ArrayPool {
    private char[][] charArrArr = new char[10][];
    private byte[][] byteArrArr = new byte[10][];
    private int chsize = 0;
    private int bysize = 0;
    private int arrsize;
    private static final int MAX_POOL_SIZE = 10;
    public static final int DEFAULT_BUFSIZE = 16388;
    private static final ArrayPool arrPool = new ArrayPool(16388);

    public ArrayPool(int n) {
        this.arrsize = n;
    }

    public synchronized byte[] allocByteArr() {
        if (this.bysize == 0) {
            return new byte[this.arrsize];
        }
        byte[] byArray = this.byteArrArr[--this.bysize];
        return byArray;
    }

    public static synchronized byte[] allocByteArrDefault() {
        return arrPool.allocByteArr();
    }

    public synchronized char[] allocCharArr() {
        if (this.chsize == 0) {
            return new char[this.arrsize];
        }
        char[] cArray = this.charArrArr[--this.chsize];
        int n = 0;
        while (n < this.arrsize) {
            cArray[n] = '\u0000';
            ++n;
        }
        return cArray;
    }

    public static synchronized char[] allocCharArrDefault() {
        return arrPool.allocCharArr();
    }

    public synchronized void freeByteArr(byte[] byArray) {
        if (this.bysize >= 10 || byArray.length != this.arrsize) {
            return;
        }
        this.byteArrArr[this.bysize++] = byArray;
    }

    public static synchronized void freeByteArrDefault(byte[] byArray) {
        arrPool.freeByteArr(byArray);
    }

    public synchronized void freeCharArr(char[] cArray) {
        if (this.chsize >= 10 || cArray.length != this.arrsize) {
            return;
        }
        this.charArrArr[this.chsize++] = cArray;
    }

    public static synchronized void freeCharArrDefault(char[] cArray) {
        arrPool.freeCharArr(cArray);
    }
}

