/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.util.XMLErrorMsg;
import org.xml.sax.Locator;

public class XMLError
implements XMLConstants {
    Locale eLocale;
    ResourceBundle messages;
    protected int[] line;
    protected int[] col;
    protected int[] types;
    protected int[] errid;
    protected String[] mesg;
    protected String[] sysId;
    protected String[] pubId;
    protected Exception[] exp;
    int nerrors = 0;
    int firsterr = -1;
    int lasterr = -1;
    boolean warning = false;
    boolean flushed = false;
    Locator locator;
    Exception lastExp;
    Writer out;
    char[] errID = new char[]{'X', 'M', 'L', '-', '0', '0', '0', '0'};
    static final int ERRIDLEN = 8;
    static String eFilename = "oracle.xml.parser.v2.mesg.XMLErrorMesg";

    void alloc() {
        if (this.eLocale == null) {
            this.eLocale = new Locale("en", "US");
        }
        if (this.messages == null) {
            this.getMessageBundle();
        }
    }

    public void error(int n, int n2, String string) {
        if (this.mesg == null) {
            this.init();
        }
        if (this.nerrors == 100) {
            return;
        }
        if (n2 == 2) {
            if (!this.warning) {
                return;
            }
            if (this.lasterr == -1 && this.nerrors == 99) {
                return;
            }
        } else {
            if (this.firsterr == -1) {
                this.firsterr = this.nerrors;
            }
            this.lasterr = this.nerrors;
        }
        if (this.locator != null) {
            this.line[this.nerrors] = this.locator.getLineNumber();
            this.col[this.nerrors] = this.locator.getColumnNumber();
            this.pubId[this.nerrors] = this.locator.getPublicId();
            this.sysId[this.nerrors] = this.locator.getSystemId();
        }
        this.mesg[this.nerrors] = string;
        this.errid[this.nerrors] = n;
        this.types[this.nerrors] = n2;
        if (this.lastExp != null) {
            this.exp[this.nerrors] = this.lastExp;
            this.lastExp = null;
        }
        ++this.nerrors;
    }

    public void error(int n, int n2, String[] stringArray) {
        this.error(n, n2, this.getMessage(n, stringArray));
    }

    public void error0(int n, int n2) {
        this.error(n, n2, this.getMessage0(n));
    }

    public void error1(int n, int n2, String string) {
        this.error(n, n2, this.getMessage1(n, string));
    }

    public void error2(int n, int n2, String string, String string2) {
        this.error(n, n2, this.getMessage2(n, string, string2));
    }

    public void error3(int n, int n2, String string, String string2, String string3) {
        this.error(n, n2, this.getMessage3(n, string, string2, string3));
    }

    public void flushErrorStream() throws IOException {
        if (this.nerrors == 0 || this.flushed) {
            return;
        }
        this.flushed = true;
        if (this.out != null) {
            int n = 0;
            while (n < this.nerrors) {
                this.out.write(System.getProperty("line.separator"));
                this.out.write(this.formatErrorMesg(n));
                ++n;
            }
            this.out.write(System.getProperty("line.separator"));
            this.out.flush();
        }
    }

    public String formatErrorMesg(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sysId[n] != null) {
            stringBuffer.append(this.sysId[n]);
        }
        if (this.line[n] != 0 && this.col[n] != 0) {
            stringBuffer.append("<Line " + this.line[n] + ", Column " + this.col[n] + ">");
            stringBuffer.append(": ");
        } else if (this.sysId[n] != null) {
            stringBuffer.append(": ");
        }
        stringBuffer.append(String.valueOf(this.idToString(this.errid[n])) + ": (" + this.typeToString(this.types[n]) + ") " + this.mesg[n]);
        return stringBuffer.toString();
    }

    public int getColumnNumber(int n) {
        return this.col[n];
    }

    public Exception getException(int n) {
        return this.exp[n];
    }

    public int getFirstError() {
        return this.firsterr;
    }

    public int getLineNumber(int n) {
        return this.line[n];
    }

    public Locator getLocator() {
        return this.locator;
    }

    public String getMessage(int n) {
        return this.mesg[n];
    }

    public String getMessage(int n, String[] stringArray) {
        this.alloc();
        String string = this.idToString(n);
        String string2 = MessageFormat.format(this.messages.getString(string), stringArray);
        return string2;
    }

    public String getMessage0(int n) {
        this.alloc();
        String string = this.idToString(n);
        return this.messages.getString(string);
    }

    public String getMessage1(int n, String string) {
        this.alloc();
        String string2 = this.idToString(n);
        Object[] objectArray = new String[]{string};
        String string3 = MessageFormat.format(this.messages.getString(string2), objectArray);
        return string3;
    }

    public String getMessage2(int n, String string, String string2) {
        this.alloc();
        String string3 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2};
        String string4 = MessageFormat.format(this.messages.getString(string3), objectArray);
        return string4;
    }

    public String getMessage3(int n, String string, String string2, String string3) {
        this.alloc();
        String string4 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2, string3};
        String string5 = MessageFormat.format(this.messages.getString(string4), objectArray);
        return string5;
    }

    public String getMessage4(int n, String string, String string2, String string3, String string4) {
        this.alloc();
        String string5 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2, string3, string4};
        String string6 = MessageFormat.format(this.messages.getString(string5), objectArray);
        return string6;
    }

    public String getMessage5(int n, String string, String string2, String string3, String string4, String string5) {
        this.alloc();
        String string6 = this.idToString(n);
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        String string7 = MessageFormat.format(this.messages.getString(string6), objectArray);
        return string7;
    }

    void getMessageBundle() {
        try {
            this.messages = ResourceBundle.getBundle(eFilename, this.eLocale);
        }
        catch (Exception exception) {
            this.messages = new XMLErrorMsg();
        }
    }

    public int getMessageType(int n) {
        return this.types[n];
    }

    public int getNumMessages() {
        return this.nerrors;
    }

    public String getPublicId(int n) {
        return this.pubId[n];
    }

    public String getSystemId(int n) {
        return this.sysId[n];
    }

    String idToString(int n) {
        this.errID[0] = 88;
        if (n < 1000) {
            this.errID[1] = 77;
            this.errID[2] = 76;
        } else {
            this.errID[1] = 83;
            this.errID[2] = n < 2000 ? 76 : 68;
        }
        int n2 = 1;
        while (n2 < 5) {
            this.errID[8 - n2] = (char)(n % 10 + 48);
            n /= 10;
            ++n2;
        }
        return new String(this.errID);
    }

    private void init() {
        this.line = new int[101];
        this.col = new int[101];
        this.types = new int[101];
        this.errid = new int[101];
        this.mesg = new String[101];
        this.sysId = new String[101];
        this.pubId = new String[101];
        this.exp = new Exception[101];
    }

    public void printErrorListener() throws IOException {
        if (this.nerrors == 0) {
            return;
        }
        this.flushed = true;
        if (this.out != null) {
            int n = 0;
            while (n < this.nerrors) {
                this.out.write(System.getProperty("line.separator"));
                this.out.write(this.formatErrorMesg(n));
                ++n;
            }
            this.out.write(System.getProperty("line.separator"));
            this.out.flush();
        }
    }

    public void reset() {
        this.lastExp = null;
        this.nerrors = 0;
        this.firsterr = -1;
        this.lasterr = -1;
        this.flushed = false;
    }

    public void setErrorStream(OutputStream outputStream) {
        this.out = new OutputStreamWriter(outputStream);
    }

    public void setErrorStream(OutputStream outputStream, String string) throws IOException {
        this.out = new OutputStreamWriter(outputStream, string);
    }

    public void setErrorStream(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void setException(Exception exception) {
        this.lastExp = exception;
    }

    public void setLocale(Locale locale) {
        this.eLocale = locale;
        this.getMessageBundle();
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public void showWarnings(boolean bl) {
        this.warning = bl;
    }

    String typeToString(int n) {
        switch (n) {
            case 0: {
                return this.getMessage0(1);
            }
            case 1: {
                return this.getMessage0(2);
            }
            case 2: {
                return this.getMessage0(3);
            }
        }
        return "";
    }
}

