/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceFileParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceClassIterator<S>
implements Iterator<Class<? extends S>> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Class<S> service;
    private final ClassLoader classLoader;
    private final Enumeration<URL> serviceResources;
    private final LinkedHashMap<String, Class<? extends S>> providerTypes;
    private Iterator<String> pending = null;
    private String nextName = null;

    public ServiceClassIterator(Class<S> service, ClassLoader classLoader, Enumeration<URL> serviceResources, LinkedHashMap<String, Class<? extends S>> providerTypes) {
        this.service = service;
        this.classLoader = classLoader;
        this.serviceResources = serviceResources;
        this.providerTypes = providerTypes;
    }

    @Override
    public boolean hasNext() {
        if (this.nextName != null) {
            return true;
        }
        while (this.pending == null || !this.pending.hasNext()) {
            if (!this.serviceResources.hasMoreElements()) {
                return false;
            }
            this.pending = this.parseServiceFile(this.serviceResources.nextElement());
        }
        this.nextName = this.pending.next();
        return true;
    }

    @Override
    public Class<? extends S> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String className = this.nextName;
        this.nextName = null;
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            if (!this.service.isAssignableFrom(clazz)) {
                throw new ServiceConfigurationError("Provider '" + className + "' is not assignable to Service '" + this.service.getName() + "'");
            }
            Class<S> serviceClass = clazz.asSubclass(this.service);
            this.providerTypes.put(className, serviceClass);
            return serviceClass;
        }
        catch (ClassNotFoundException e) {
            throw new ServiceConfigurationError("Provider '" + className + "' not found", e);
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationError("Provider '" + className + "' is not assignable to Service '" + this.service.getName() + "'", e);
        }
        catch (Throwable e) {
            throw new ServiceConfigurationError("Provider '" + className + "' could not be instantiated", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<String> parseServiceFile(URL url) {
        Iterator<String> iterator;
        InputStream inputStream = null;
        InputStreamReader reader = null;
        try {
            inputStream = url.openStream();
            reader = new InputStreamReader(inputStream, UTF_8);
            ServiceFileParser<? extends S> serviceFileParser = new ServiceFileParser<S>(reader);
            serviceFileParser.setProviderTypes(this.providerTypes);
            serviceFileParser.parse();
            iterator = serviceFileParser.iterator();
        }
        catch (Exception e) {
            try {
                throw new ServiceConfigurationError("An error occurred while reading service resource '" + url + "' for service class '" + this.service.getName() + "'", e);
            }
            catch (Throwable throwable) {
                ServiceClassIterator.closeQuietly(reader);
                ServiceClassIterator.closeQuietly(inputStream);
                throw throwable;
            }
        }
        ServiceClassIterator.closeQuietly(reader);
        ServiceClassIterator.closeQuietly(inputStream);
        return iterator;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

