/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceIterator<S>
implements Iterator<S> {
    private final Iterator<Class<? extends S>> typesIterator;
    private final LinkedHashMap<Class<? extends S>, S> providers;

    public ServiceIterator(Iterator<Class<? extends S>> typesIterator, LinkedHashMap<Class<? extends S>, S> providers) {
        this.typesIterator = typesIterator;
        this.providers = providers;
    }

    @Override
    public boolean hasNext() {
        return this.typesIterator.hasNext();
    }

    @Override
    public S next() {
        Class<S> serviceClass = this.typesIterator.next();
        try {
            S provider = serviceClass.newInstance();
            this.providers.put(serviceClass, provider);
            return provider;
        }
        catch (Exception e) {
            throw new ServiceConfigurationError("Provider '" + serviceClass.getName() + "' could not be instantiated", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

