/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ServiceClassIterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceInstancesIterator;
import java.util.ServiceIterator;
import java.util.ServiceTypesIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String SERVICE_PREFIX = "META-INF/services/";
    private final LinkedHashMap<String, Class<? extends S>> servicesTypes = new LinkedHashMap();
    private final LinkedHashMap<Class<? extends S>, S> services = new LinkedHashMap();
    private final Class<S> service;
    private final ClassLoader classLoader;
    private ServiceClassIterator<S> serviceClassIterator;

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader classLoader) {
        if (service == null) {
            throw new IllegalArgumentException("Parameter 'service' must not be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Parameter 'classLoader' must not be null");
        }
        return new ServiceLoader<S>(service, classLoader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader current = null;
        for (ClassLoader parent = ClassLoader.getSystemClassLoader(); parent != null; parent = parent.getParent()) {
            current = parent;
        }
        return ServiceLoader.load(service, current);
    }

    private ServiceLoader(Class<S> service, ClassLoader classLoader) {
        this.service = service;
        this.classLoader = classLoader;
        this.reload();
    }

    public void reload() {
        this.servicesTypes.clear();
        this.services.clear();
        String fullName = SERVICE_PREFIX + this.service.getName();
        try {
            Enumeration<URL> serviceResources = this.classLoader.getResources(fullName);
            this.serviceClassIterator = new ServiceClassIterator<S>(this.service, this.classLoader, serviceResources, this.servicesTypes);
        }
        catch (IOException e) {
            throw new ServiceConfigurationError("An error occurred while loading '" + fullName + "' Service resource(s) from clabackport-spiath", e);
        }
    }

    @Override
    public Iterator<S> iterator() {
        return new ServiceInstancesIterator<S>(this.services.entrySet().iterator(), new ServiceIterator<S>(this.typesIterator(), this.services));
    }

    public Iterator<Class<? extends S>> typesIterator() {
        return new ServiceTypesIterator<S>(this.servicesTypes.entrySet().iterator(), this.serviceClassIterator);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.service.getName() + "]";
    }
}

