/*
 * Decompiled with CFR 0.152.
 */
package org.aaa4j.radius.client;

import java.time.Duration;
import org.aaa4j.radius.client.RetransmissionStrategy;

public final class IntervalRetransmissionStrategy
implements RetransmissionStrategy {
    private final int maxAttempts;
    private final Duration timeout;

    public IntervalRetransmissionStrategy(int maxAttempts, Duration timeout) {
        this.maxAttempts = maxAttempts;
        this.timeout = timeout;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public Duration timeoutForAttempt(int attempt) {
        if (attempt < 0 || attempt >= this.maxAttempts) {
            throw new IllegalArgumentException("Attempt " + attempt + " is outside of the valid range");
        }
        return this.timeout;
    }
}

