/*
 * Decompiled with CFR 0.152.
 */
package org.aaa4j.radius.server.servers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import org.aaa4j.radius.core.dictionary.Dictionary;
import org.aaa4j.radius.core.dictionary.dictionaries.StandardDictionary;
import org.aaa4j.radius.core.packet.Packet;
import org.aaa4j.radius.core.packet.PacketCodec;
import org.aaa4j.radius.core.util.RandomProvider;
import org.aaa4j.radius.core.util.SecureRandomProvider;
import org.aaa4j.radius.server.DuplicationStrategy;
import org.aaa4j.radius.server.RadiusServer;
import org.aaa4j.radius.server.TimedDuplicationStrategy;

public final class UdpRadiusServer
implements RadiusServer {
    private static final int MAX_PACKET_SIZE = 4096;
    private static final DuplicationStrategy DEFAULT_DUPLICATION_STRATEGY = new TimedDuplicationStrategy(Duration.ofSeconds(30L));
    private final InetSocketAddress bindAddress;
    private final RadiusServer.Handler handler;
    private final DuplicationStrategy duplicationStrategy;
    private final Executor executor;
    private final PacketCodec packetCodec;
    private final CountDownLatch startCountDownLatch;
    private final CountDownLatch stopCountDownLatch;
    private volatile boolean isRunning = false;
    private boolean isStarted = false;
    private boolean isStopped = false;
    private SelectorManager selectorManager;

    private UdpRadiusServer(Builder builder) {
        this.bindAddress = Objects.requireNonNull(builder.bindAddress);
        this.handler = Objects.requireNonNull(builder.handler);
        this.duplicationStrategy = builder.duplicationStrategy == null ? DEFAULT_DUPLICATION_STRATEGY : builder.duplicationStrategy;
        this.executor = builder.executor == null ? ForkJoinPool.commonPool() : builder.executor;
        StandardDictionary dictionary = builder.dictionary == null ? new StandardDictionary() : builder.dictionary;
        SecureRandomProvider randomProvider = builder.randomProvider == null ? new SecureRandomProvider() : builder.randomProvider;
        this.packetCodec = new PacketCodec((Dictionary)dictionary, (RandomProvider)randomProvider);
        this.startCountDownLatch = new CountDownLatch(1);
        this.stopCountDownLatch = new CountDownLatch(1);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public synchronized void start() throws InterruptedException {
        if (!this.isStarted && !this.isStopped) {
            this.selectorManager = new SelectorManager(this);
            this.selectorManager.setDaemon(false);
            this.selectorManager.start();
            this.isStarted = true;
        }
        this.startCountDownLatch.await();
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        if (this.isStarted && !this.isStopped) {
            this.selectorManager.interrupt();
            this.isStopped = true;
        }
        this.stopCountDownLatch.await();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    public static final class Builder {
        InetSocketAddress bindAddress;
        DuplicationStrategy duplicationStrategy;
        RadiusServer.Handler handler;
        Executor executor;
        Dictionary dictionary;
        RandomProvider randomProvider;

        public Builder bindAddress(InetSocketAddress bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder handler(RadiusServer.Handler handler) {
            this.handler = handler;
            return this;
        }

        public Builder duplicationStrategy(DuplicationStrategy duplicationStrategy) {
            this.duplicationStrategy = duplicationStrategy;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder dictionary(Dictionary dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public Builder randomProvider(RandomProvider randomProvider) {
            this.randomProvider = randomProvider;
            return this;
        }

        public UdpRadiusServer build() {
            return new UdpRadiusServer(this);
        }
    }

    private static final class SelectorManager
    extends Thread {
        private static final String NAME = "aaa4j-radius-server-udp-selector-manager";
        private final UdpRadiusServer udpRadiusServer;
        private DatagramChannel datagramChannel;

        SelectorManager(UdpRadiusServer udpRadiusServer) {
            super(NAME);
            this.udpRadiusServer = udpRadiusServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Selector selector = Selector.open();
                this.datagramChannel = DatagramChannel.open();
                this.datagramChannel.configureBlocking(false);
                this.datagramChannel.register(selector, 1);
                this.datagramChannel.socket().bind(this.udpRadiusServer.bindAddress);
                this.udpRadiusServer.isRunning = true;
                this.udpRadiusServer.startCountDownLatch.countDown();
                while (!this.isInterrupted()) {
                    int numKeysChanged = selector.select();
                    if (this.isInterrupted()) break;
                    if (numKeysChanged <= 0) continue;
                    Set<SelectionKey> selectedKeys = selector.selectedKeys();
                    Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                    boolean isReadable = false;
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        if (key.isReadable()) {
                            isReadable = true;
                        }
                        keyIterator.remove();
                    }
                    selectedKeys.clear();
                    if (!isReadable) continue;
                    ByteBuffer inByteBuffer = ByteBuffer.allocate(4096);
                    InetSocketAddress clientAddress = (InetSocketAddress)this.datagramChannel.receive(inByteBuffer);
                    try {
                        this.udpRadiusServer.executor.execute(() -> {
                            try {
                                this.runHandler(clientAddress, inByteBuffer);
                            }
                            catch (Exception exception) {
                                try {
                                    this.udpRadiusServer.handler.handleException(exception);
                                }
                                catch (Exception exceptionHandlerException) {
                                    exceptionHandlerException.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        try {
                            this.udpRadiusServer.handler.handleException(rejectedExecutionException);
                        }
                        catch (Exception exceptionHandlerException) {
                            exceptionHandlerException.printStackTrace();
                        }
                    }
                }
                this.datagramChannel.close();
                selector.close();
            }
            catch (Exception exception) {
                try {
                    this.udpRadiusServer.handler.handleException(exception);
                }
                catch (Exception exceptionHandlerException) {
                    exceptionHandlerException.printStackTrace();
                }
            }
            finally {
                this.udpRadiusServer.isRunning = false;
                this.udpRadiusServer.startCountDownLatch.countDown();
                this.udpRadiusServer.stopCountDownLatch.countDown();
            }
        }

        private void runHandler(InetSocketAddress clientAddress, ByteBuffer inByteBuffer) throws Exception {
            byte[] secret = this.udpRadiusServer.handler.handleClient(clientAddress.getAddress());
            if (secret != null) {
                inByteBuffer.flip();
                byte[] inBytes = new byte[inByteBuffer.remaining()];
                inByteBuffer.get(inBytes);
                Packet requestPacket = this.udpRadiusServer.packetCodec.decodeRequest(inBytes, secret);
                Packet responsePacket = null;
                DuplicationStrategy.Result result = this.udpRadiusServer.duplicationStrategy.handleRequest(clientAddress, requestPacket, inBytes);
                switch (result.getState()) {
                    case NEW_REQUEST: {
                        try {
                            responsePacket = this.udpRadiusServer.handler.handlePacket(clientAddress.getAddress(), requestPacket);
                            if (responsePacket == null) break;
                            this.udpRadiusServer.duplicationStrategy.handleResponse(clientAddress, requestPacket, inBytes, responsePacket);
                            break;
                        }
                        catch (Exception e) {
                            this.udpRadiusServer.duplicationStrategy.unhandleRequest(clientAddress, requestPacket, inBytes);
                            throw e;
                        }
                    }
                    case IN_PROGRESS_REQUEST: {
                        break;
                    }
                    case CACHED_RESPONSE: {
                        responsePacket = result.getResponsePacket();
                    }
                }
                if (responsePacket != null) {
                    byte[] outBytes = this.udpRadiusServer.packetCodec.encodeResponse(responsePacket, secret, requestPacket.getReceivedFields().getIdentifier(), requestPacket.getReceivedFields().getAuthenticator());
                    this.datagramChannel.send(ByteBuffer.wrap(outBytes), clientAddress);
                }
            }
        }
    }
}

