/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout.netbeans;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.util.AbstractTreeForTreeLayout;
import org.abego.treelayout.util.DefaultConfiguration;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbegoTreeLayoutForNetbeans<N, E>
extends GraphLayout<N, E> {
    private TreeLayout<N> treeLayout;
    private Configuration<N> configuration;
    private int originX;
    private int originY;
    private N rootNode;

    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        if (!graph.getNodes().contains(this.rootNode)) {
            throw new IllegalArgumentException("graph does not contain rootNode");
        }
        TreeLayout layout = new TreeLayout((TreeForTreeLayout)new MyTreeForTreeLayout(this.rootNode, graph), (NodeExtentProvider)new MyNodeExtentProvider(graph), this.configuration);
        Map bounds = layout.getNodeBounds();
        for (Map.Entry entry : bounds.entrySet()) {
            Rectangle2D.Double rect = (Rectangle2D.Double)entry.getValue();
            Point pt = new Point((int)Math.round(rect.getX() + (double)this.originX), (int)Math.round(rect.getY() + (double)this.originY));
            this.setResolvedNodeLocation(graph, entry.getKey(), pt);
        }
    }

    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> nodes) {
        throw new UnsupportedOperationException("Cannot layout a subsets of nodes of a tree");
    }

    public AbegoTreeLayoutForNetbeans(N rootNode, int originX, int originY, Configuration<N> configuration) {
        this.rootNode = rootNode;
        this.originX = originX;
        this.originY = originY;
        this.configuration = configuration;
    }

    public AbegoTreeLayoutForNetbeans(N rootNode, int originX, int originY, int gapBetweenLevels, int gapBetweenNodes, boolean vertical) {
        this(rootNode, originX, originY, (Configuration<N>)new DefaultConfiguration((double)gapBetweenLevels, (double)gapBetweenNodes, vertical ? Configuration.Location.Top : Configuration.Location.Left, Configuration.AlignmentInLevel.TowardsRoot));
    }

    public N getRootNode() {
        return this.rootNode;
    }

    public Configuration<N> getConfiguration() {
        return this.configuration;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyTreeForTreeLayout
    extends AbstractTreeForTreeLayout<N> {
        private Map<N, List<N>> childrenNodes;
        private Map<N, N> parents;
        private UniversalGraph<N, E> graph;

        private N calcParent(N node) {
            Collection edges = this.graph.findNodeEdges(node, false, true);
            int n = edges.size();
            if (n > 1) {
                throw new RuntimeException("node has more than one parent");
            }
            Object parent = n == 0 ? null : this.graph.getEdgeSource(edges.iterator().next());
            return parent;
        }

        private List<N> calcChildrenList(N parentNode) {
            Collection edges = this.graph.findNodeEdges(parentNode, true, false);
            ArrayList<Object> children = new ArrayList<Object>(edges.size());
            for (Object edge : edges) {
                children.add(this.graph.getEdgeTarget(edge));
            }
            return children;
        }

        public N getParent(N node) {
            if (this.parents.containsKey(node)) {
                return this.parents.get(node);
            }
            Object parent = this.calcParent(node);
            this.parents.put(node, parent);
            return parent;
        }

        public List<N> getChildrenList(N parentNode) {
            List children = this.childrenNodes.get(parentNode);
            if (children == null) {
                children = this.calcChildrenList(parentNode);
                this.childrenNodes.put(parentNode, children);
            }
            return children;
        }

        public MyTreeForTreeLayout(N root, UniversalGraph<N, E> graph) {
            super(root);
            this.childrenNodes = new HashMap();
            this.parents = new HashMap();
            this.graph = graph;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyNodeExtentProvider
    implements NodeExtentProvider<N> {
        private UniversalGraph<N, E> graph;

        private Rectangle getBounds(N node) {
            Widget widget = this.graph.getScene().findWidget(node);
            widget.getLayout().layout(widget);
            return widget.getPreferredBounds();
        }

        public MyNodeExtentProvider(UniversalGraph<N, E> graph) {
            this.graph = graph;
        }

        public double getHeight(N treeNode) {
            return this.getBounds(treeNode).getHeight();
        }

        public double getWidth(N treeNode) {
            return this.getBounds(treeNode).getWidth();
        }
    }
}

