package org.accidia.dbz.modules;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import org.accidia.dbz.Constants;
import org.accidia.dbz.IDbz;
import org.accidia.dbz.impl.DbzOnBDBImpl;
import com.sleepycat.je.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

import static com.google.common.base.Preconditions.checkArgument;

public class BdbStorageModule extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final String homeDirectory;

    public BdbStorageModule() {
        logger.debug("BdbStorageModule()");
        this.homeDirectory = Constants.BdbStorageModule.DEFAULT_BDB_HOME_DIRECTORY;
    }

    public BdbStorageModule(final String homeDirectory) {
        logger.debug("BdbStorageModule(homeDirectory)");
        checkArgument(!Strings.isNullOrEmpty(homeDirectory), "null/empty home directory");
        this.homeDirectory = homeDirectory;
    }

    @Override
    protected void configure() {
        logger.debug("configure()");
        try {
            if (! Files.exists(Paths.get(this.homeDirectory))) {
                Files.createDirectories(Paths.get(this.homeDirectory));
            }
            final IDbz storage = new DbzOnBDBImpl(this.homeDirectory,
                    Constants.BdbStorageModule.BDB_DATABASE_NAME);
            bind(IDbz.class).toInstance(storage);
        } catch (IOException | DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}
