package org.accidia.dbz.modules;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import org.accidia.dbz.impl.DbzOnDerbyImpl;
import org.accidia.dbz.IDbz;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

import javax.sql.DataSource;

import static com.google.common.base.Preconditions.checkArgument;

public class DerbyStorageModule extends AbstractModule {
    private final String path;

    public DerbyStorageModule(final String path) {
        checkArgument(!Strings.isNullOrEmpty(path), "null/empty path");
        this.path = path;
    }

    @Override
    protected void configure() {
        final String url = String.format("jdbc:derby:%s;create=true", this.path);
        final DataSource dataSource = new SimpleDriverDataSource(
                new EmbeddedDriver(), url
        );
        bind(DataSource.class).toInstance(dataSource);
        bind(IDbz.class).to(DbzOnDerbyImpl.class).in(Singleton.class);
    }
}
