package org.accidia.echo.mysql;

import com.google.common.base.Joiner;
import com.google.protobuf.Message;
import org.accidia.echo.protobuf.Protobufs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

import static com.google.common.base.Preconditions.checkArgument;

public class EchoSqls {
    private static final Logger logger = LoggerFactory.getLogger(EchoSqls.class);

    /**
     * Generates a SQL 'select' statement to read the given fields from the table which
     * is a data source for the message.  This method validates the given field names
     * by checking that the message does have the given fields.
     */
    public static String getSqlSelectFieldsForMessage(final Message message,
                                                      final List<String> fields) {
        logger.debug("getSqlSelectFieldsForMessage(message,fields,tableName)");
        checkArgument(message != null, "null message");
        checkArgument(fields != null && !fields.isEmpty(), "null/empty fields");

        // validate that all given fields are actually present in the message
        final List<String> allFields = Protobufs.getAllFieldNamesToUpperCase(message);
        for (final String field : fields) {
            checkArgument(allFields.contains(field.toUpperCase()), "invalid field: " + field);
        }

        final StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("SELECT ")
                .append(Joiner.on(",").join(fields));
        final String sql = sqlStringBuilder.toString();
        logger.debug("sql: {}", sql);
        return sql;
    }

    public static String getSqlCreateTableForMessage(final Message message) {
        return null;
    }

    public static String getSqlReplaceIntoForMessage(final Message message) {
        return null;
    }
}

