/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.beans.PropertyDescriptorUtils;
import org.springframework.util.ObjectUtils;

class SimplePropertyDescriptor
extends PropertyDescriptor {
    private Method readMethod;
    private Method writeMethod;
    private Class<?> propertyType;
    private Class<?> propertyEditorClass;

    public SimplePropertyDescriptor(PropertyDescriptor original) throws IntrospectionException {
        this(original.getName(), original.getReadMethod(), original.getWriteMethod());
        PropertyDescriptorUtils.copyNonMethodProperties(original, this);
    }

    public SimplePropertyDescriptor(String propertyName, Method readMethod, Method writeMethod) throws IntrospectionException {
        super(propertyName, null, null);
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.propertyType = PropertyDescriptorUtils.findPropertyType(readMethod, writeMethod);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    @Override
    public Class<?> getPropertyType() {
        if (this.propertyType == null) {
            try {
                this.propertyType = PropertyDescriptorUtils.findPropertyType(this.readMethod, this.writeMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return this.propertyType;
    }

    @Override
    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    @Override
    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof PropertyDescriptor && PropertyDescriptorUtils.equals(this, (PropertyDescriptor)other);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.getReadMethod()) * 29 + ObjectUtils.nullSafeHashCode(this.getWriteMethod());
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s, propertyType=%s, readMethod=%s, writeMethod=%s]", this.getClass().getSimpleName(), this.getName(), this.getPropertyType(), this.readMethod, this.writeMethod);
    }
}

