/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import org.accidia.echo.protobuf.Protobufs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoSqls {
    private static final Logger logger = LoggerFactory.getLogger(EchoSqls.class);

    public static String getSqlSelectFieldsForMessage(Message message, List<String> fields) {
        logger.debug("getSqlSelectFieldsForMessage(message,fields,tableName)");
        Preconditions.checkArgument(message != null, "null message");
        Preconditions.checkArgument(fields != null && !fields.isEmpty(), "null/empty fields");
        List<String> allFields = Protobufs.getAllFieldNamesToUpperCase(message);
        for (String field : fields) {
            Preconditions.checkArgument(allFields.contains(field.toUpperCase()), "invalid field: " + field);
        }
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("SELECT ").append(Joiner.on(",").join(fields));
        String sql = sqlStringBuilder.toString();
        logger.debug("sql: {}", (Object)sql);
        return sql;
    }

    public static String getSqlCreateTableForMessage(Message message) {
        return null;
    }

    public static String getSqlReplaceIntoForMessage(Message message) {
        return null;
    }
}

