/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.format;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.format.DataFormatMatcher;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class DataFormatDetector {
    public static final int DEFAULT_MAX_INPUT_LOOKAHEAD = 64;
    protected final JsonFactory[] _detectors;
    protected final MatchStrength _optimalMatch;
    protected final MatchStrength _minimalMatch;
    protected final int _maxInputLookahead;

    public DataFormatDetector(JsonFactory ... jsonFactoryArray) {
        this(jsonFactoryArray, MatchStrength.SOLID_MATCH, MatchStrength.WEAK_MATCH, 64);
    }

    public DataFormatDetector(Collection<JsonFactory> collection) {
        this(collection.toArray(new JsonFactory[collection.size()]));
    }

    public DataFormatDetector withOptimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._optimalMatch) {
            return this;
        }
        return new DataFormatDetector(this._detectors, matchStrength, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatDetector withMinimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._minimalMatch) {
            return this;
        }
        return new DataFormatDetector(this._detectors, this._optimalMatch, matchStrength, this._maxInputLookahead);
    }

    public DataFormatDetector withMaxInputLookahead(int n) {
        if (n == this._maxInputLookahead) {
            return this;
        }
        return new DataFormatDetector(this._detectors, this._optimalMatch, this._minimalMatch, n);
    }

    private DataFormatDetector(JsonFactory[] jsonFactoryArray, MatchStrength matchStrength, MatchStrength matchStrength2, int n) {
        this._detectors = jsonFactoryArray;
        this._optimalMatch = matchStrength;
        this._minimalMatch = matchStrength2;
        this._maxInputLookahead = n;
    }

    public DataFormatMatcher findFormat(InputStream inputStream) throws IOException {
        return this._findFormat(new InputAccessor.Std(inputStream, new byte[this._maxInputLookahead]));
    }

    public DataFormatMatcher findFormat(byte[] byArray) throws IOException {
        return this._findFormat(new InputAccessor.Std(byArray));
    }

    public DataFormatMatcher findFormat(byte[] byArray, int n, int n2) throws IOException {
        return this._findFormat(new InputAccessor.Std(byArray, n, n2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this._detectors.length;
        if (n > 0) {
            stringBuilder.append(this._detectors[0].getFormatName());
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(this._detectors[i].getFormatName());
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private DataFormatMatcher _findFormat(InputAccessor.Std std) throws IOException {
        JsonFactory jsonFactory = null;
        Enum enum_ = null;
        for (JsonFactory jsonFactory2 : this._detectors) {
            std.reset();
            MatchStrength matchStrength = jsonFactory2.hasFormat(std);
            if (matchStrength == null || matchStrength.ordinal() < this._minimalMatch.ordinal() || jsonFactory != null && enum_.ordinal() >= matchStrength.ordinal()) continue;
            jsonFactory = jsonFactory2;
            enum_ = matchStrength;
            if (matchStrength.ordinal() >= this._optimalMatch.ordinal()) break;
        }
        return std.createMatcher(jsonFactory, (MatchStrength)enum_);
    }
}

