/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.MessageUtils;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public final class FormDataParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    private static final Set<Class<?>> TYPES = FormDataParamValueFactoryProvider.initializeTypes();

    private static Set<Class<?>> initializeTypes() {
        HashSet newSet = new HashSet();
        newSet.add(Byte.class);
        newSet.add(Byte.TYPE);
        newSet.add(Short.class);
        newSet.add(Short.TYPE);
        newSet.add(Integer.class);
        newSet.add(Integer.TYPE);
        newSet.add(Long.class);
        newSet.add(Long.TYPE);
        newSet.add(Float.class);
        newSet.add(Float.TYPE);
        newSet.add(Double.class);
        newSet.add(Double.TYPE);
        newSet.add(Boolean.class);
        newSet.add(Boolean.TYPE);
        newSet.add(Character.class);
        newSet.add(Character.TYPE);
        return newSet;
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return TYPES.contains(type);
    }

    @Inject
    public FormDataParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
        super(mpep, locator, Parameter.Source.ENTITY, Parameter.Source.UNKNOWN);
    }

    @Override
    protected Factory<?> createValueFactory(Parameter parameter) {
        Class<?> parameterRawType = parameter.getRawType();
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (FormDataMultiPart.class.isAssignableFrom(parameterRawType)) {
                return new FormDataMultiPartValueFactory();
            }
            return null;
        }
        if (parameter.getSourceAnnotation().annotationType() == FormDataParam.class) {
            String parameterName = parameter.getSourceName();
            if (parameterName == null || parameterName.isEmpty()) {
                return null;
            }
            if (Collection.class == parameterRawType || List.class == parameterRawType) {
                Class<?> clazz = ReflectionHelper.getGenericTypeArgumentClasses(parameter.getType()).get(0);
                if (FormDataBodyPart.class == clazz) {
                    return new ListFormDataBodyPartValueFactory(parameter.getSourceName());
                }
                if (FormDataContentDisposition.class == clazz) {
                    return new ListFormDataContentDispositionValueFactory(parameter.getSourceName());
                }
                return new FormDataParamValueFactory(parameter, this.get(parameter));
            }
            if (FormDataBodyPart.class == parameterRawType) {
                return new FormDataBodyPartValueFactory(parameter.getSourceName());
            }
            if (FormDataContentDisposition.class == parameterRawType) {
                return new FormDataContentDispositionMultiPartInjectable(parameter.getSourceName());
            }
            return new FormDataParamValueFactory(parameter, this.get(parameter));
        }
        return null;
    }

    private FormDataMultiPart getEntity(ContainerRequest request) {
        if (request.getProperty(FormDataMultiPart.class.getName()) == null) {
            FormDataMultiPart formDataMultiPart = request.readEntity(FormDataMultiPart.class);
            request.setProperty(FormDataMultiPart.class.getName(), formDataMultiPart);
        }
        return (FormDataMultiPart)request.getProperty(FormDataMultiPart.class.getName());
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.HIGH;
    }

    private final class FormDataMultiPartValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private FormDataMultiPartValueFactory() {
        }

        @Override
        public Object provide() {
            return FormDataParamValueFactoryProvider.this.getEntity(this.getContainerRequest());
        }
    }

    private final class FormDataParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final Parameter parameter;

        public FormDataParamValueFactory(Parameter parameter, MultivaluedParameterExtractor<?> extractor) {
            this.parameter = parameter;
            this.extractor = extractor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object provide() {
            ContainerRequest request = this.getContainerRequest();
            FormDataMultiPart formDataMultiPart = FormDataParamValueFactoryProvider.this.getEntity(request);
            List<FormDataBodyPart> formDataBodyParts = formDataMultiPart.getFields(this.parameter.getSourceName());
            FormDataBodyPart formDataBodyPart = formDataBodyParts != null ? formDataBodyParts.get(0) : null;
            MediaType mediaType = formDataBodyPart != null ? formDataBodyPart.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
            MessageBodyWorkers messageBodyWorkers = request.getWorkers();
            MessageBodyReader<?> messageBodyReader = messageBodyWorkers.getMessageBodyReader(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType);
            if (messageBodyReader != null && !FormDataParamValueFactoryProvider.isPrimitiveType(this.parameter.getRawType())) {
                InputStream in;
                if (formDataBodyPart == null) {
                    if (this.parameter.getDefaultValue() == null) return null;
                    in = new ByteArrayInputStream(this.parameter.getDefaultValue().getBytes(MessageUtils.getCharset(mediaType)));
                } else {
                    in = ((BodyPartEntity)formDataBodyPart.getEntity()).getInputStream();
                }
                try {
                    return messageBodyReader.readFrom(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType, request.getHeaders(), in);
                }
                catch (IOException e) {
                    throw new FormDataParamException(e, this.parameter.getSourceName(), this.parameter.getDefaultValue());
                }
            }
            if (this.extractor == null) return null;
            MultivaluedStringMap map = new MultivaluedStringMap();
            try {
                if (formDataBodyPart == null) return this.extractor.extract(map);
                for (FormDataBodyPart p : formDataBodyParts) {
                    mediaType = p.getMediaType();
                    MessageBodyReader<String> messageBodyReader2 = messageBodyWorkers.getMessageBodyReader(String.class, (Type)((Object)String.class), this.parameter.getAnnotations(), mediaType);
                    String value = messageBodyReader2.readFrom(String.class, (Type)((Object)String.class), this.parameter.getAnnotations(), mediaType, request.getHeaders(), ((BodyPartEntity)p.getEntity()).getInputStream());
                    map.add(this.parameter.getSourceName(), value);
                }
                return this.extractor.extract(map);
            }
            catch (IOException | ExtractorException ex) {
                throw new FormDataParamException(ex, this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    private final class FormDataContentDispositionMultiPartInjectable
    extends AbstractContainerRequestValueFactory<FormDataContentDisposition> {
        private final String name;

        public FormDataContentDispositionMultiPartInjectable(String name) {
            this.name = name;
        }

        @Override
        public FormDataContentDisposition provide() {
            FormDataMultiPart formDataMultiPart = FormDataParamValueFactoryProvider.this.getEntity(this.getContainerRequest());
            FormDataBodyPart formDataBodyPart = formDataMultiPart.getField(this.name);
            if (formDataBodyPart == null) {
                return null;
            }
            return formDataMultiPart.getField(this.name).getFormDataContentDisposition();
        }
    }

    private final class FormDataBodyPartValueFactory
    extends AbstractContainerRequestValueFactory<FormDataBodyPart> {
        private final String name;

        public FormDataBodyPartValueFactory(String name) {
            this.name = name;
        }

        @Override
        public FormDataBodyPart provide() {
            return FormDataParamValueFactoryProvider.this.getEntity(this.getContainerRequest()).getField(this.name);
        }
    }

    private final class ListFormDataContentDispositionValueFactory
    extends AbstractContainerRequestValueFactory<List<FormDataContentDisposition>> {
        private final String name;

        public ListFormDataContentDispositionValueFactory(String name) {
            this.name = name;
        }

        @Override
        public List<FormDataContentDisposition> provide() {
            FormDataMultiPart formDataMultiPart = FormDataParamValueFactoryProvider.this.getEntity(this.getContainerRequest());
            List<FormDataBodyPart> formDataBodyParts = formDataMultiPart.getFields(this.name);
            if (formDataBodyParts == null) {
                return null;
            }
            ArrayList<FormDataContentDisposition> list = new ArrayList<FormDataContentDisposition>(formDataBodyParts.size());
            for (FormDataBodyPart formDataBodyPart : formDataBodyParts) {
                list.add(formDataBodyPart.getFormDataContentDisposition());
            }
            return list;
        }
    }

    private final class ListFormDataBodyPartValueFactory
    extends AbstractContainerRequestValueFactory<List<FormDataBodyPart>> {
        private final String name;

        public ListFormDataBodyPartValueFactory(String name) {
            this.name = name;
        }

        @Override
        public List<FormDataBodyPart> provide() {
            return FormDataParamValueFactoryProvider.this.getEntity(this.getContainerRequest()).getFields(this.name);
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<FormDataParam> {
        public InjectionResolver() {
            super(FormDataParamValueFactoryProvider.class);
        }
    }

    private static final class FormDataParamException
    extends ParamException {
        protected FormDataParamException(Throwable cause, String name, String defaultStringValue) {
            super(cause, Response.Status.BAD_REQUEST, FormDataParam.class, name, defaultStringValue);
        }
    }
}

