/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import redis.clients.jedis.HostAndPort;
import redis.clients.util.ClusterNodeInformation;

public class ClusterNodeInformationParser {
    private static final String SLOT_IMPORT_IDENTIFIER = "-<-";
    private static final String SLOT_IN_TRANSITION_IDENTIFIER = "[";
    public static final int SLOT_INFORMATIONS_START_INDEX = 8;
    public static final int HOST_AND_PORT_INDEX = 1;

    public ClusterNodeInformation parse(String nodeInfo, HostAndPort current) {
        String[] nodeInfoPartArray = nodeInfo.split(" ");
        HostAndPort node = this.getHostAndPortFromNodeLine(nodeInfoPartArray, current);
        ClusterNodeInformation info = new ClusterNodeInformation(node);
        if (nodeInfoPartArray.length >= 8) {
            String[] slotInfoPartArray = this.extractSlotParts(nodeInfoPartArray);
            this.fillSlotInformation(slotInfoPartArray, info);
        }
        return info;
    }

    private String[] extractSlotParts(String[] nodeInfoPartArray) {
        String[] slotInfoPartArray = new String[nodeInfoPartArray.length - 8];
        for (int i = 8; i < nodeInfoPartArray.length; ++i) {
            slotInfoPartArray[i - 8] = nodeInfoPartArray[i];
        }
        return slotInfoPartArray;
    }

    public HostAndPort getHostAndPortFromNodeLine(String[] nodeInfoPartArray, HostAndPort current) {
        String stringHostAndPort = nodeInfoPartArray[1];
        String[] arrayHostAndPort = stringHostAndPort.split(":");
        return new HostAndPort(arrayHostAndPort[0].isEmpty() ? current.getHost() : arrayHostAndPort[0], arrayHostAndPort[1].isEmpty() ? current.getPort() : Integer.valueOf(arrayHostAndPort[1]).intValue());
    }

    private void fillSlotInformation(String[] slotInfoPartArray, ClusterNodeInformation info) {
        for (String slotRange : slotInfoPartArray) {
            this.fillSlotInformationFromSlotRange(slotRange, info);
        }
    }

    private void fillSlotInformationFromSlotRange(String slotRange, ClusterNodeInformation info) {
        if (slotRange.startsWith(SLOT_IN_TRANSITION_IDENTIFIER)) {
            int slot = Integer.parseInt(slotRange.substring(1).split("-")[0]);
            if (slotRange.contains(SLOT_IMPORT_IDENTIFIER)) {
                info.addSlotBeingImported(slot);
            } else {
                info.addSlotBeingMigrated(slot);
            }
        } else if (slotRange.contains("-")) {
            String[] slotRangePart = slotRange.split("-");
            for (int slot = Integer.valueOf(slotRangePart[0]).intValue(); slot <= Integer.valueOf(slotRangePart[1]); ++slot) {
                info.addAvailableSlot(slot);
            }
        } else {
            info.addAvailableSlot(Integer.valueOf(slotRange));
        }
    }
}

