/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;

public final class JettyHttpContainer
extends AbstractHandler
implements Container {
    private static final ExtendedLogger LOGGER = new ExtendedLogger(Logger.getLogger(JettyHttpContainer.class.getName()), Level.FINEST);
    private static final Type REQUEST_TYPE = new TypeLiteral<Ref<Request>>(){}.getType();
    private static final Type RESPONSE_TYPE = new TypeLiteral<Ref<Response>>(){}.getType();
    private static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private boolean configSetStatusOverSendError;
    private volatile ApplicationHandler appHandler;
    private volatile ContainerLifecycleListener containerListener;

    @Override
    public void handle(String target, final Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        final Response response = Response.getResponse(httpServletResponse);
        ResponseWriter responseWriter = new ResponseWriter(request, response, this.configSetStatusOverSendError);
        URI baseUri = this.getBaseUri(request);
        String originalQuery = request.getUri().getQuery();
        String encodedQuery = ContainerUtils.encodeUnsafeCharacters(originalQuery);
        String uriString = originalQuery == null || originalQuery.isEmpty() || originalQuery.equals(encodedQuery) ? request.getUri().toString() : request.getUri().toString().replace(originalQuery, encodedQuery);
        URI requestUri = baseUri.resolve(uriString);
        try {
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), new MapPropertiesDelegate());
            requestContext.setEntityStream(request.getInputStream());
            Enumeration<String> headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                requestContext.headers(headerName, request.getHeader(headerName));
            }
            requestContext.setWriter(responseWriter);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                @Override
                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(REQUEST_TYPE, new Annotation[0])).set(request);
                    ((Ref)locator.getService(RESPONSE_TYPE, new Annotation[0])).set(response);
                }
            });
            request.setHandled(true);
            this.appHandler.handle(requestContext);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            @Override
            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    @Override
    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    @Override
    public void reload() {
        this.reload(this.getConfiguration());
    }

    @Override
    public void reload(ResourceConfig configuration) {
        this.containerListener.onShutdown(this);
        this.appHandler = new ApplicationHandler(configuration.register(new JettyBinder()));
        this.containerListener = ConfigHelper.getContainerLifecycleListener(this.appHandler);
        this.containerListener.onReload(this);
        this.containerListener.onStartup(this);
        this.cacheConfigSetStatusOverSendError();
    }

    @Override
    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.containerListener.onStartup(this);
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.containerListener.onShutdown(this);
        this.appHandler = null;
    }

    JettyHttpContainer(Application application, ServiceLocator parentLocator) {
        this.appHandler = new ApplicationHandler(application, new JettyBinder(), parentLocator);
        this.containerListener = ConfigHelper.getContainerLifecycleListener(this.appHandler);
    }

    JettyHttpContainer(Application application) {
        this.appHandler = new ApplicationHandler(application, new JettyBinder());
        this.containerListener = ConfigHelper.getContainerLifecycleListener(this.appHandler);
        this.cacheConfigSetStatusOverSendError();
    }

    private void cacheConfigSetStatusOverSendError() {
        this.configSetStatusOverSendError = ServerProperties.getValue(this.getConfiguration().getProperties(), "jersey.config.server.response.setStatusOverSendError", false, Boolean.class);
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final Response response;
        private final Continuation continuation;
        private final boolean configSetStatusOverSendError;

        ResponseWriter(Request request, Response response, boolean configSetStatusOverSendError) {
            this.response = response;
            this.continuation = ContinuationSupport.getContinuation(request);
            this.configSetStatusOverSendError = configSetStatusOverSendError;
        }

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            Response.StatusType statusInfo = context.getStatusInfo();
            int code = statusInfo.getStatusCode();
            String reason = statusInfo.getReasonPhrase() == null ? HttpStatus.getMessage(code) : statusInfo.getReasonPhrase();
            this.response.setStatusWithReason(code, reason);
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            for (Map.Entry e : context.getStringHeaders().entrySet()) {
                for (String value : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), value);
                }
            }
            try {
                return this.response.getOutputStream();
            }
            catch (IOException ioe) {
                throw new ContainerException("Error during writing out the response headers.", ioe);
            }
        }

        @Override
        public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                if (timeOut > 0L) {
                    long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
                    this.continuation.setTimeout(timeoutMillis);
                }
                this.continuation.addContinuationListener(new ContinuationListener(){

                    @Override
                    public void onComplete(Continuation continuation) {
                    }

                    @Override
                    public void onTimeout(Continuation continuation) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout(ResponseWriter.this);
                        }
                    }
                });
                this.continuation.suspend(this.response);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Override
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            if (timeOut > 0L) {
                long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
                this.continuation.setTimeout(timeoutMillis);
            }
        }

        @Override
        public void commit() {
            try {
                this.response.closeOutput();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LocalizationMessages.UNABLE_TO_CLOSE_RESPONSE(), e);
            }
            finally {
                if (this.continuation.isSuspended()) {
                    this.continuation.complete();
                }
                LOGGER.log(Level.FINEST, "commit() called");
            }
        }

        @Override
        public void failure(Throwable error) {
            block8: {
                try {
                    if (this.response.isCommitted()) break block8;
                    try {
                        if (this.configSetStatusOverSendError) {
                            this.response.reset();
                            this.response.setStatus(INTERNAL_SERVER_ERROR, "Request failed.");
                        } else {
                            this.response.sendError(INTERNAL_SERVER_ERROR, "Request failed.");
                        }
                    }
                    catch (IllegalStateException ex) {
                        LOGGER.log(Level.FINER, "Unable to reset failed response.", ex);
                    }
                    catch (IOException ex) {
                        throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(INTERNAL_SERVER_ERROR, "Request failed."), ex);
                    }
                }
                finally {
                    LOGGER.log(Level.FINEST, "failure(...) called");
                    this.commit();
                    this.rethrow(error);
                }
            }
        }

        @Override
        public boolean enableResponseBuffering() {
            return false;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class JettyBinder
    extends AbstractBinder {
        private JettyBinder() {
        }

        @Override
        protected void configure() {
            this.bindFactory(JettyRequestReferencingFactory.class).to(Request.class).proxy(false).in(RequestScoped.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Request>>(){}).in(RequestScoped.class);
            this.bindFactory(JettyResponseReferencingFactory.class).to(Response.class).proxy(false).in(RequestScoped.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Response>>(){}).in(RequestScoped.class);
        }
    }

    private static class JettyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public JettyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class JettyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public JettyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

