/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoConfig {
    private static final Logger logger = LoggerFactory.getLogger(EchoConfig.class);
    private final Config config;
    private final String bind;
    private final int timeoutInSeconds;

    private EchoConfig(Config config) {
        logger.debug("EchoConfig()");
        this.config = config;
        this.bind = Preconditions.checkNotNull(this.getConfig().getString("echo.bind"), "missing config: echo.bind");
        this.timeoutInSeconds = Preconditions.checkNotNull(this.getConfig().getInt("echo.timeout_in_seconds"), "missing config: echo.timeout_in_seconds");
    }

    public static EchoConfig newInstanceForConfig(Config config) {
        logger.debug("newInstanceForConfig(config)");
        Preconditions.checkArgument(config != null, "null config");
        return new EchoConfig(config);
    }

    public String getBind() {
        logger.debug("getBind()");
        return this.bind;
    }

    public int getTimeoutInSeconds() {
        logger.debug("getTimeoutInSeconds()");
        return this.timeoutInSeconds;
    }

    public List<Protos.Tenant> getDefaultTenants() {
        logger.debug("getDefaultTenants()");
        ArrayList<Protos.Tenant> protobufTypeMetaList = new ArrayList<Protos.Tenant>();
        for (ConfigObject configObject : this.getConfig().getObjectList("echo.tenants")) {
            String tenantName = configObject.toConfig().getString("name");
            String dataSourceName = configObject.toConfig().getString("datasource_name");
            String namespace = configObject.toConfig().getString("namespace");
            String protobufMessage = configObject.toConfig().getString("protobuf_message");
            Protos.Tenant tenant = Protos.Tenant.newBuilder().setName(tenantName).setDatasourceName(dataSourceName).setNamespace(namespace).setProtobufMessage(protobufMessage).build();
            logger.info("adding tenant: {}", (Object)tenant);
            protobufTypeMetaList.add(tenant);
        }
        return protobufTypeMetaList;
    }

    public List<Protos.DataSource> getDefaultDataSources() {
        logger.debug("getDefaultDataSources()");
        ArrayList<Protos.DataSource> defaultDataSources = new ArrayList<Protos.DataSource>();
        for (ConfigObject configObject : this.getConfig().getObjectList("echo.data_sources")) {
            String dataSourceName = configObject.toConfig().getString("name");
            String storageType = configObject.toConfig().getString("storage_type");
            boolean isReadOnly = configObject.toConfig().getBoolean("is_readonly");
            Protos.DataSource.Builder dataSourceBuilder = Protos.DataSource.newBuilder().setName(dataSourceName).setStorageType(Protos.DataSource.StorageType.valueOf(storageType.toUpperCase())).setReadonly(isReadOnly);
            ConfigObject metaConfigObject = configObject.toConfig().getObject("meta");
            for (Map.Entry entry : metaConfigObject.entrySet()) {
                dataSourceBuilder.addMetadata(Protos.DataSource.MetaData.newBuilder().setName((String)entry.getKey()).setValue(String.valueOf(((ConfigValue)entry.getValue()).unwrapped())).build());
            }
            Protos.DataSource dataSource = dataSourceBuilder.build();
            logger.info("adding datasource: {}", (Object)dataSource);
            defaultDataSources.add(dataSource);
        }
        return defaultDataSources;
    }

    public Config getConfig() {
        logger.debug("getConfig()");
        return this.config;
    }
}

