/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.memcache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.accidia.echo.memcache.MemcacheDataSource;

public class MemcacheAccessor {
    private static final Map<MemcacheDataSource, MemcacheAccessor> instanceMap = new ConcurrentHashMap<MemcacheDataSource, MemcacheAccessor>();
    private final MemcacheDataSource memcacheDataSource;

    protected MemcacheAccessor(MemcacheDataSource memcacheDataSource) {
        this.memcacheDataSource = memcacheDataSource;
    }

    public static synchronized MemcacheAccessor getInstance(MemcacheDataSource memcacheDataSource) {
        Preconditions.checkArgument(memcacheDataSource != null, "null datasource");
        if (!instanceMap.containsKey(memcacheDataSource)) {
            MemcacheAccessor instance = new MemcacheAccessor(memcacheDataSource);
            instanceMap.put(memcacheDataSource, instance);
        }
        return instanceMap.get(memcacheDataSource);
    }

    public Message get(String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return (Message)this.memcacheDataSource.getMemcachedClient().get(key);
    }

    public void set(String key, int expiry, Message value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Preconditions.checkArgument(value != null, "null value");
        this.memcacheDataSource.getMemcachedClient().set(key, expiry, value);
    }

    public void delete(String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        this.memcacheDataSource.getMemcachedClient().delete(key);
    }
}

