/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.ExceptionMeteredInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

class ExceptionMeteredListener
implements TypeListener {
    private final MetricRegistry metricRegistry;

    ExceptionMeteredListener(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        Class<T> klass = literal.getRawType();
        for (Method method : klass.getDeclaredMethods()) {
            MethodInterceptor interceptor = ExceptionMeteredInterceptor.forMethod(this.metricRegistry, klass, method);
            if (interceptor == null) continue;
            encounter.bindInterceptor(Matchers.only(method), interceptor);
        }
    }
}

