/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.accidia.echo.EchoConfig;
import org.accidia.echo.dao.StorageInitFailed;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.services.IDataSourceService;
import org.accidia.echo.services.ITenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EchoContext {
    INSTANCE;

    private static final Logger logger;
    private ListeningExecutorService executorService;
    private EchoConfig configuration;
    private Injector injector;

    public void init() throws ReflectiveOperationException, StorageInitFailed {
        logger.info("initializing configurations...");
        this.initConfigurations();
        logger.info("initializing executor service...");
        this.initExecutorService();
        logger.info("initializing injector...");
        this.initInjector();
        logger.info("initializing default datasources...");
        this.initDefaultDataSources();
        logger.info("initializing default tenants...");
        this.initDefaultTenants();
        logger.info("initializing registered datasources...");
        this.initRegisteredDataSources();
        logger.info("initializing registered tenants...");
        this.initRegisteredTenants();
    }

    public void reloadConfigurations(String userConfigurationPath) {
        logger.debug("reloadConfigurations()");
    }

    public Injector getInjector() {
        logger.debug("getInjector()");
        return this.injector;
    }

    public EchoConfig getConfiguration() {
        logger.debug("getConfiguration()");
        return this.configuration;
    }

    public ListeningExecutorService getExecutorService() {
        logger.debug("getExecutorService()");
        return this.executorService;
    }

    protected void initConfigurations() {
        this.configuration = EchoConfig.newInstanceForConfig(ConfigFactory.load("echo.conf"));
    }

    protected void initExecutorService() {
        this.executorService = MoreExecutors.listeningDecorator(new ThreadPoolExecutor(0, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>()));
    }

    protected void initInjector() throws ReflectiveOperationException {
        Preconditions.checkState(this.configuration != null, "null configuration");
        List<String> moduleNames = this.getConfiguration().getConfig().getStringList("echo.modules");
        Preconditions.checkArgument(moduleNames != null && !moduleNames.isEmpty(), "null/empty storage modules");
        ArrayList modules = new ArrayList(moduleNames.size() + 1);
        for (String moduleName : moduleNames) {
            logger.info("adding module: {}", (Object)moduleName);
            modules.add(Class.forName(moduleName).newInstance());
        }
        logger.info("creating guice injector");
        this.injector = Guice.createInjector(modules);
    }

    protected void initDefaultTenants() throws StorageInitFailed {
        List<Protos.Tenant> defaultTenants = this.getConfiguration().getDefaultTenants();
        this.doRegisterTenants(defaultTenants);
    }

    protected void initDefaultDataSources() throws StorageInitFailed {
        Collection<Protos.DataSource> defaultDataSources = this.getInjector().getInstance(IDataSourceService.class).getDefaultDataSources();
        this.doRegisterDataSources(defaultDataSources);
    }

    protected void initRegisteredTenants() throws StorageInitFailed {
    }

    protected void doRegisterTenants(List<Protos.Tenant> tenants) {
        if (tenants == null || tenants.isEmpty()) {
            logger.info("no tenant to register -> ignoring");
            return;
        }
        ITenantService tenantService = this.getInjector().getInstance(ITenantService.class);
        for (Protos.Tenant tenant : tenants) {
            logger.info("registering tenant: {}", (Object)tenant.getName());
            try {
                tenantService.registerTenant(tenant);
            }
            catch (Exception e) {
                logger.error("unable to register tenant -> rethrowing as runtime exception", e);
                throw new RuntimeException("cannot register tenant", e);
            }
        }
    }

    protected void initRegisteredDataSources() throws StorageInitFailed {
        IDataSourceService dataSourceService = this.getInjector().getInstance(IDataSourceService.class);
        Collection<Protos.DataSource> registeredDataSources = dataSourceService.getRegisteredDataSources();
        this.doRegisterDataSources(registeredDataSources);
    }

    protected void doRegisterDataSources(Collection<Protos.DataSource> dataSources) {
    }

    static {
        logger = LoggerFactory.getLogger(EchoContext.class);
    }
}

