/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.google.inject.AbstractModule;
import com.palominolabs.metrics.guice.MetricsInstrumentationModule;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(MetricsModule.class);
    private MetricRegistry registry;
    private JmxReporter jmxReporter;
    private Slf4jReporter slf4jReporter;

    @Override
    protected void configure() {
        logger.debug("configure()");
        this.registry = new MetricRegistry();
        this.jmxReporter = JmxReporter.forRegistry(this.registry).build();
        this.jmxReporter.start();
        this.slf4jReporter = Slf4jReporter.forRegistry(this.registry).build();
        this.slf4jReporter.start(30L, TimeUnit.SECONDS);
        logger.info("binding metric registry...");
        this.bind(MetricRegistry.class).toInstance(this.registry);
        logger.info("installing metrics module...");
        this.install(new MetricsInstrumentationModule(this.registry));
    }
}

