/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.accidia.echo.EchoContext;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.protoserver.misc.AsyncResponses;
import org.accidia.echo.services.ITenantService;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/tenant/")
public class TenantResource {
    private static final Logger logger = LoggerFactory.getLogger(TenantResource.class);
    private final ITenantService tenantService = EchoContext.INSTANCE.getInjector().getInstance(ITenantService.class);
    private long requestTimeoutInSeconds = EchoContext.INSTANCE.getConfiguration().getConfig().getLong("echo.timeout_in_seconds");

    @GET
    @Metered
    @ExceptionMetered
    @Path(value="/")
    @Produces(value={"application/x-protobuf;qs=0.5", "application/json"})
    @ManagedAsync
    public void getTenantes(@Suspended AsyncResponse asyncResponse) {
        logger.debug("getDefaultTenants()");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        this.doGetTenants(asyncResponse);
    }

    @POST
    @Metered
    @ExceptionMetered
    @Path(value="/")
    @Consumes(value={"application/json"})
    @ManagedAsync
    public void postTenant(@Suspended AsyncResponse asyncResponse, String tenantJson) {
        logger.debug("postTenant()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tenantJson), "null/empty tenantJson");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
    }

    protected void doGetTenants(AsyncResponse asyncResponse) {
        List<Protos.Tenant> allTenants = this.tenantService.getAllTenants();
        asyncResponse.resume(allTenants);
    }
}

