package org.accidia.echo.services.impl;

import org.accidia.echo.EchoContext;
import org.accidia.echo.services.IDataSourceService;
import org.accidia.echo.protos.Protos;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataSourceService implements IDataSourceService {
    private final Map<String, Protos.DataSource> defaultDataSources = new ConcurrentHashMap<>();
    private final Map<String, Protos.DataSource> registeredDataSources = new ConcurrentHashMap<>();

    public DataSourceService() {
        for (final Protos.DataSource defaulDataSource : EchoContext.INSTANCE.getConfiguration().getDefaultDataSources()) {
            this.defaultDataSources.put(defaulDataSource.getName(), defaulDataSource);
        }
    }

    @Override
    public Protos.DataSource getDataSource(final String datasourceName) {
        final Protos.DataSource dataSource = this.defaultDataSources.get(datasourceName);
        if (dataSource != null) {
            return dataSource;
        }
        // TODO
        return null;
    }

    @Override
    public void register(final Protos.DataSource dataSource) {
        // TODO validate
        this.registeredDataSources.put(dataSource.getName(), dataSource);
    }

    @Override
    public Collection<Protos.DataSource> getDefaultDataSources() {
        return this.defaultDataSources.values();
    }

    @Override
    public Collection<Protos.DataSource> getRegisteredDataSources() {
        return this.registeredDataSources.values();
    }
}
