/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.client.impl;

import com.google.common.net.HostAndPort;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.accidia.echo.client.IEchoClient;

public class EchoSyncClient
implements IEchoClient {
    private final HostAndPort serverHostAndPort;
    private final String serverBaseUrl;
    private final Client client;

    public static EchoSyncClient newInstance(HostAndPort serverHostAndPort) {
        return new EchoSyncClient(serverHostAndPort);
    }

    protected EchoSyncClient(HostAndPort serverHostAndPort) {
        this.serverHostAndPort = serverHostAndPort;
        this.serverBaseUrl = "http://" + serverHostAndPort.toString() + "/v1/";
        this.client = ClientBuilder.newClient();
    }

    @Override
    public <ProtobufType extends Message> ProtobufType getObject(String tenantName, String key, Message.Builder builder) {
        byte[] buffer = this.client.target(this.serverBaseUrl).path("object").path(tenantName).path(key).request().header("accept", "application/x-protobuf").get(byte[].class);
        try {
            return (ProtobufType)((Message)((Object)builder.mergeFrom(buffer)));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ProtobufType extends Message> List<ProtobufType> getList(String tenantName, String key, Message.Builder builder) {
        return null;
    }
}

