/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.memcache;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheDataSource {
    private static final Logger logger = LoggerFactory.getLogger(MemcacheDataSource.class);
    private static Map<Protos.DataSource, MemcacheDataSource> instaces = new HashMap<Protos.DataSource, MemcacheDataSource>();
    private final Protos.DataSource datasource;
    private final MemcachedClient memcachedClient;

    public static synchronized MemcacheDataSource getInstance(Protos.DataSource datasource) throws IOException {
        if (!instaces.containsKey(datasource)) {
            instaces.put(datasource, MemcacheDataSource.newInstance(datasource));
        }
        return instaces.get(datasource);
    }

    public static MemcacheDataSource newInstance(Protos.DataSource dataSource) throws IOException {
        return new MemcacheDataSource(dataSource);
    }

    protected MemcacheDataSource(Protos.DataSource datasource) throws IOException {
        logger.debug("MemcacheDataSource(storageMeta)");
        this.datasource = datasource;
        String hostname = this.getMetadataValue(this.datasource.getMetadataList(), "hostname", true);
        int port = Integer.parseInt(this.getMetadataValue(this.datasource.getMetadataList(), "port", true));
        this.memcachedClient = new MemcachedClient(new InetSocketAddress(hostname, port));
    }

    protected String getMetadataValue(List<Protos.DataSource.MetaData> metaData, String metadataName, boolean isRequired) {
        for (Protos.DataSource.MetaData md : metaData) {
            if (!md.getName().equalsIgnoreCase(metadataName)) continue;
            return md.getValue();
        }
        Preconditions.checkArgument(isRequired, "invalid metadata: " + metadataName);
        return null;
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }
}

