/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.accidia.echo.EchoContext;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.protoserver.misc.AsyncResponses;
import org.accidia.echo.services.IObjectsService;
import org.accidia.echo.services.ITenantService;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="v1/object/")
public class ObjectResource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long requestTimeoutInSeconds = EchoContext.INSTANCE.getConfiguration().getConfig().getLong("echo.timeout_in_seconds");
    private final ITenantService tenantService = EchoContext.INSTANCE.getInjector().getInstance(ITenantService.class);
    private final ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();

    @GET
    @Metered
    @ExceptionMetered
    @Path(value="/{tenant}")
    @Produces(value={"application/x-protobuf;qs=.5", "application/json"})
    @ManagedAsync
    public void getObjectList(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @DefaultValue(value="0") @QueryParam(value="start") String startString, @DefaultValue(value="-1") @QueryParam(value="count") String countString) {
        int count;
        int start;
        this.logger.debug("getObjects()");
        this.tenantService.validateTenant(tenant);
        try {
            start = Integer.valueOf(startString);
            count = Integer.valueOf(countString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        Preconditions.checkArgument(count >= -1, "invalid count");
        Preconditions.checkArgument(start >= 0, "invalid start");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        this.doGetObjectList(asyncResponse, tenant, start, count);
    }

    @GET
    @Metered
    @ExceptionMetered
    @Path(value="/{tenant}/{csvkeys}")
    @Produces(value={"application/x-protobuf;qs=.5"})
    @ManagedAsync
    public void getObjectAsProtobuf(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="csvkeys") String csvKeys, @DefaultValue(value="ts") @QueryParam(value="orderby") String orderby, @DefaultValue(value="false") @QueryParam(value="includeArchive") boolean includeArchive) {
        this.logger.debug("getObjectAsProtobuf()");
        this.tenantService.validateTenant(tenant);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(csvKeys.trim()), "null/empty key");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        if (!csvKeys.contains(",")) {
            this.doGetObject(asyncResponse, tenant, csvKeys, includeArchive);
            return;
        }
        this.doGetObjects(asyncResponse, tenant, Arrays.asList(csvKeys.split(",")), includeArchive);
    }

    @GET
    @Metered
    @ExceptionMetered
    @Path(value="/{tenant}/{csvkeys}")
    @Produces(value={"application/json"})
    @ManagedAsync
    public void getObjectAsJson(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="csvkeys") String csvKeys, @DefaultValue(value="false") @QueryParam(value="includeArchive") boolean includeArchive) {
        this.logger.debug("getObjectAsJson()");
        this.tenantService.validateTenant(tenant);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(csvKeys.trim()), "null/empty key");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        if (!csvKeys.contains(",")) {
            this.doGetObject(asyncResponse, tenant, csvKeys, includeArchive);
            return;
        }
        this.doGetObjectsAsJson(asyncResponse, tenant, Arrays.asList(csvKeys.split(",")), includeArchive);
    }

    @GET
    @Metered
    @ExceptionMetered
    @Path(value="/{tenant}/{csvkeys}/{csvfields}")
    @Produces(value={"application/x-protobuf;qs=0.5", "application/json"})
    @ManagedAsync
    public void getPartialObject(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="csvkeys") String csvKeys, @PathParam(value="csvfields") String csvFields, @DefaultValue(value="false") @QueryParam(value="includeArchive") boolean includeArchive) {
        this.logger.debug("getPartialObject()");
        this.tenantService.validateTenant(tenant);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(csvKeys.trim()), "null/empty key");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(csvFields.trim()), "null/empty fields");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        if (!csvKeys.contains(",")) {
            this.doGetPartialObject(asyncResponse, tenant, csvKeys, csvFields, includeArchive);
        }
        this.doGetPartialObjects(asyncResponse, tenant, Arrays.asList(csvKeys.split(",")), csvFields, includeArchive);
    }

    @POST
    @Metered
    @ExceptionMetered
    @Path(value="/{tenant}/{key}")
    @Consumes(value={"application/json"})
    @ManagedAsync
    public void postJsonObject(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="key") String key, String jsonObject) {
        this.logger.debug("postObject()");
        this.tenantService.validateTenant(tenant);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key.trim()), "null/empty key");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(jsonObject.trim()), "null/empty json object");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        this.tenantService.getTenant(tenant);
        Protos.Tenant.Builder builder = Protos.Tenant.getDefaultInstance().newBuilderForType();
        try {
            JsonFormat.merge(jsonObject, this.extensionRegistry, (Message.Builder)builder);
        }
        catch (JsonFormat.ParseException | RuntimeException e) {
            throw new IllegalArgumentException("invalid json", e);
        }
        this.doPostObject(asyncResponse, tenant, key, builder.buildPartial());
    }

    @POST
    @Metered
    @ExceptionMetered
    @Path(value="/{tenant}/{key}")
    @Consumes(value={"application/x-protobuf"})
    @ManagedAsync
    public void postProtobufObject(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="key") String key, byte[] objectBytes) {
        this.logger.debug("postObject()");
        this.tenantService.validateTenant(tenant);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key.trim()), "null/empty key");
        Preconditions.checkArgument(objectBytes != null && objectBytes.length > 0, "null/empty object bytes");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        this.tenantService.getTenant(tenant);
        Protos.Tenant.Builder builder = Protos.Tenant.getDefaultInstance().newBuilderForType();
        try {
            builder.mergeFrom(objectBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("invalid protobuf object", e);
        }
        this.doPostObject(asyncResponse, tenant, key, builder.buildPartial());
    }

    protected IObjectsService getObjectServicesForTenant(String tenant) {
        IObjectsService objectsServices = this.tenantService.getObjectsServicesForTenant(tenant);
        Preconditions.checkArgument(objectsServices != null, "invalid tenant: " + tenant);
        return objectsServices;
    }

    protected void doGetObjectList(AsyncResponse asyncResponse, String tenant, int start, int count) {
        AsyncResponses.addCallbackForListenableFuture(asyncResponse, this.getObjectServicesForTenant(tenant).getObjectList("TODO", start, count));
    }

    protected void doGetObject(AsyncResponse asyncResponse, String tenant, String key, boolean includeArchive) {
        AsyncResponses.addCallbackForListenableFuture(asyncResponse, this.getObjectServicesForTenant(tenant).getObject(key, includeArchive));
    }

    protected void doGetObjects(final AsyncResponse asyncResponse, String tenant, List<String> keys, boolean includeArchive) {
        ListenableFuture<Map<String, Message>> futureResult = this.getObjectServicesForTenant(tenant).getObjects(keys, includeArchive);
        Futures.addCallback(futureResult, new FutureCallback<Map<String, Message>>(){

            @Override
            public void onSuccess(Map<String, Message> result) {
                Preconditions.checkArgument(result != null, "null result");
                Protos.ListResult.Builder listResultBuilder = Protos.ListResult.newBuilder();
                for (Map.Entry<String, Message> entry : result.entrySet()) {
                    listResultBuilder.addObjects(Protos.ObjectResult.newBuilder().setKey(entry.getKey()).setObject(entry.getValue().toByteString()).setClassName(entry.getValue().getClass().getName()));
                }
                asyncResponse.resume(listResultBuilder.build());
            }

            @Override
            public void onFailure(Throwable t) {
                ObjectResource.this.logger.error("get objects failed: ", t);
                asyncResponse.resume(t);
            }
        });
    }

    protected void doGetObjectsAsJson(final AsyncResponse asyncResponse, String tenant, List<String> keys, boolean includeArchive) {
        ListenableFuture<Map<String, Message>> futureResult = this.getObjectServicesForTenant(tenant).getObjects(keys, includeArchive);
        Futures.addCallback(futureResult, new FutureCallback<Map<String, Message>>(){

            @Override
            public void onSuccess(Map<String, Message> result) {
                Preconditions.checkArgument(result != null, "null result");
                asyncResponse.resume(result);
            }

            @Override
            public void onFailure(Throwable t) {
                ObjectResource.this.logger.error("get objects as json failed: ", t);
                asyncResponse.resume(t);
            }
        });
    }

    protected void doGetPartialObject(AsyncResponse asyncResponse, String tenant, String key, String csvFields, boolean includeArchive) {
        AsyncResponses.addCallbackForListenableFuture(asyncResponse, this.getObjectServicesForTenant(tenant).getPartialObject(key, Arrays.asList(csvFields.split(",")), includeArchive));
    }

    protected void doGetPartialObjects(final AsyncResponse asyncResponse, String tenant, List<String> keys, String csvFields, boolean includeArchive) {
        ListenableFuture<Map<String, Message>> futureResult = this.getObjectServicesForTenant(tenant).getPartialObjects(keys, Arrays.asList(csvFields.split(",")), includeArchive);
        Futures.addCallback(futureResult, new FutureCallback<Map<String, Message>>(){

            @Override
            public void onSuccess(Map<String, Message> result) {
                Preconditions.checkArgument(result != null, "null result");
                asyncResponse.resume(result);
            }

            @Override
            public void onFailure(Throwable t) {
                ObjectResource.this.logger.error("get objects fields failed: ", t);
                asyncResponse.resume(t);
            }
        });
    }

    protected void doPostObject(AsyncResponse asyncResponse, String tenant, String key, Message object) {
        AsyncResponses.addCallbackForListenableFuture(asyncResponse, this.getObjectServicesForTenant(tenant).storeObject(key, object));
    }
}

