/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisClusterMaxRedirectionsException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.exceptions.JedisRedirectionException;
import redis.clients.util.JedisClusterCRC16;

public abstract class JedisClusterCommand<T> {
    private JedisClusterConnectionHandler connectionHandler;
    private int commandTimeout;
    private int redirections;

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int timeout, int maxRedirections) {
        this.connectionHandler = connectionHandler;
        this.commandTimeout = timeout;
        this.redirections = maxRedirections;
    }

    public abstract T execute(Jedis var1);

    public T run(String key) {
        if (key == null) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        return this.runWithRetries(key, this.redirections, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T runWithRetries(String key, int redirections, boolean tryRandomNode, boolean asking) {
        if (redirections <= 0) {
            throw new JedisClusterMaxRedirectionsException("Too many Cluster redirections?");
        }
        Jedis connection = null;
        try {
            connection = tryRandomNode ? this.connectionHandler.getConnection() : this.connectionHandler.getConnectionFromSlot(JedisClusterCRC16.getSlot(key));
            if (asking) {
                connection.asking();
                asking = false;
            }
            T t = this.execute(connection);
            return t;
        }
        catch (JedisConnectionException jce) {
            if (tryRandomNode) {
                throw jce;
            }
            this.releaseConnection(connection, true);
            connection = null;
            T t = this.runWithRetries(key, redirections--, true, asking);
            return t;
        }
        catch (JedisRedirectionException jre) {
            if (jre instanceof JedisAskDataException) {
                asking = true;
                this.connectionHandler.assignSlotToNode(jre.getSlot(), jre.getTargetNode());
            } else if (jre instanceof JedisMovedDataException) {
                this.connectionHandler.renewSlotCache();
            } else {
                throw new JedisClusterException(jre);
            }
            this.releaseConnection(connection, false);
            connection = null;
            T t = this.runWithRetries(key, redirections - 1, false, asking);
            return t;
        }
        finally {
            this.releaseConnection(connection, false);
        }
    }

    private void releaseConnection(Jedis connection, boolean broken) {
        if (connection != null) {
            if (broken) {
                this.connectionHandler.returnBrokenConnection(connection);
            } else {
                this.connectionHandler.returnConnection(connection);
            }
        }
    }
}

