/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.spi.InjectionListener;
import java.lang.reflect.Method;

class GaugeInjectionListener<I>
implements InjectionListener<I> {
    private final MetricRegistry metricRegistry;
    private final String metricName;
    private final Method method;

    GaugeInjectionListener(MetricRegistry metricRegistry, String metricName, Method method) {
        this.metricRegistry = metricRegistry;
        this.metricName = metricName;
        this.method = method;
    }

    @Override
    public void afterInjection(final I i) {
        this.metricRegistry.register(this.metricName, new Gauge<Object>(){

            @Override
            public Object getValue() {
                try {
                    return GaugeInjectionListener.this.method.invoke(i, new Object[0]);
                }
                catch (Exception e) {
                    return new RuntimeException(e);
                }
            }
        });
    }
}

