package org.accidia.echo;

import org.accidia.echo.resources.ProtoServerApplication;
import org.accidia.echo.protoserver.misc.ProtoServerException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * Echo executable starts from this class.  It reads configurations and sets up
 * the context for the ProtoServerApplication to start.
 */
public class EchoApplication {
    private static final Logger logger = LoggerFactory.getLogger(EchoApplication.class);

    private ProtoServerApplication protoServerApplication;

    public static void main(final String[] agrs)
            throws ProtoServerException, IOException, ReflectiveOperationException {

        printTheStuff();

        final EchoApplication application = new EchoApplication();
        logger.info("*** initializing context...");
        application.initializeContext();
        logger.info("*** initializing http server...");
        application.initializeProtoServerApplication();
        logger.info("*** starting http server...");
        application.protoServerApplication.startServer();
        logger.info("*** wait on server...");
        application.protoServerApplication.joinOnServer();
        logger.info("*** imma go now... pooof!");
    }

    protected static void printTheStuff() {
        logger.info("  ────────────┌─    ┌─┐╔═╗┬ ┬┌─┐    ─┐────────────  ");
        logger.info("  ────────────│     ├┤ ║  ├─┤│ │     │────────────  ");
        logger.info("  ────────────└─    └─┘╚═╝┴ ┴└─┘    ─┘────────────  ");
    }

    protected void initializeContext() throws IOException, ReflectiveOperationException {
        // TODO pass in the user specified configuration file
        EchoContext.INSTANCE.init();
    }

    protected void initializeProtoServerApplication() {
        this.protoServerApplication = new ProtoServerApplication();
        this.protoServerApplication.getServer().setServer(
                new Server(new ExecutorThreadPool(EchoContext.INSTANCE.getExecutorService())));
    }
}

