/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.smile.SmileFactory;
import org.codehaus.jackson.smile.SmileGenerator;
import org.codehaus.jackson.smile.SmileParser;

public class SmileFormat {
    private static SmileFactory smileFactory = new SmileFactory();
    private static final Pattern DIGITS = Pattern.compile("[0-9]", 2);

    public static void print(Message message, OutputStream output) throws IOException {
        JsonGenerator generator = SmileFormat.createGenerator(output);
        SmileFormat.print(message, generator);
        generator.close();
    }

    public static void print(Message message, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        SmileFormat.printMessage(message, generator);
        generator.writeEndObject();
        generator.flush();
    }

    public static void print(UnknownFieldSet fields, OutputStream output) throws IOException {
        JsonGenerator generator = SmileFormat.createGenerator(output);
        generator.writeStartObject();
        SmileFormat.printUnknownFields(fields, generator);
        generator.writeEndObject();
        generator.close();
    }

    public static void merge(InputStream input, Message.Builder builder) throws IOException {
        SmileFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(InputStream input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        SmileParser parser = smileFactory.createJsonParser(input);
        SmileFormat.merge((JsonParser)parser, extensionRegistry, builder);
    }

    public static void merge(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        JsonToken token = parser.nextToken();
        if (token.equals((Object)JsonToken.START_OBJECT)) {
            token = parser.nextToken();
        }
        while (token != null && !token.equals((Object)JsonToken.END_OBJECT)) {
            SmileFormat.mergeField(parser, extensionRegistry, builder);
            token = parser.nextToken();
        }
        if (parser.nextToken() != null) {
            throw new RuntimeException("Expecting the end of the stream, but there seems to be more data!  Check the input for a valid JSON format.");
        }
    }

    protected static JsonGenerator createGenerator(OutputStream output) throws IOException {
        SmileGenerator generator = smileFactory.createJsonGenerator(output);
        generator.enable(SmileGenerator.Feature.WRITE_HEADER);
        generator.enable(SmileGenerator.Feature.WRITE_END_MARKER);
        return generator;
    }

    protected static void printMessage(Message message, JsonGenerator generator) throws IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
            SmileFormat.printField(field.getKey(), field.getValue(), generator);
        }
        SmileFormat.printUnknownFields(message.getUnknownFields(), generator);
    }

    public static void printField(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        SmileFormat.printSingleField(field, value, generator);
    }

    private static void printSingleField(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        if (field.isExtension()) {
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.writeFieldName(field.getMessageType().getFullName());
            } else {
                generator.writeFieldName(field.getFullName());
            }
        } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            generator.writeFieldName(field.getMessageType().getName());
        } else {
            generator.writeFieldName(field.getName());
        }
        if (field.isRepeated()) {
            generator.writeStartArray();
            Iterator iter = ((List)value).iterator();
            while (iter.hasNext()) {
                SmileFormat.printFieldValue(field, iter.next(), generator);
            }
            generator.writeEndArray();
        } else {
            SmileFormat.printFieldValue(field, value, generator);
        }
    }

    private static void printFieldValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                generator.writeNumber(((Integer)value).intValue());
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                generator.writeNumber(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber(((Double)value).doubleValue());
                break;
            }
            case BOOL: {
                generator.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.writeNumber(SmileFormat.unsignedInt((Integer)value).intValue());
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.writeNumber(SmileFormat.unsignedLong((Long)value).longValue());
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case BYTES: {
                generator.writeBinary(((ByteString)value).toByteArray());
                break;
            }
            case ENUM: {
                generator.writeString(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                generator.writeStartObject();
                SmileFormat.printMessage((Message)value, generator);
                generator.writeEndObject();
            }
        }
    }

    protected static void printUnknownFields(UnknownFieldSet unknownFields, JsonGenerator generator) throws IOException {
        for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = entry.getValue();
            generator.writeArrayFieldStart(entry.getKey().toString());
            Iterator<Object> i$ = field.getVarintList().iterator();
            while (i$.hasNext()) {
                long value = i$.next();
                generator.writeNumber(value);
            }
            i$ = field.getFixed32List().iterator();
            while (i$.hasNext()) {
                int value = (Integer)i$.next();
                generator.writeNumber(value);
            }
            i$ = field.getFixed64List().iterator();
            while (i$.hasNext()) {
                long value = (Long)i$.next();
                generator.writeNumber(value);
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                generator.writeBinary(value.toByteArray());
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.writeStartObject();
                SmileFormat.printUnknownFields(value, generator);
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
    }

    protected static void mergeField(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder) throws JsonParseException, IOException {
        Descriptors.FieldDescriptor field = null;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        boolean unknown = false;
        ExtensionRegistry.ExtensionInfo extension = null;
        JsonToken token = parser.getCurrentToken();
        if (token != null) {
            String lowerName;
            String name = parser.getCurrentName();
            if (name.contains(".")) {
                extension = extensionRegistry.findExtensionByName(name);
                if (extension == null) {
                    throw new RuntimeException("Extension \"" + name + "\" not found in the ExtensionRegistry.");
                }
                if (extension.descriptor.getContainingType() != type) {
                    throw new RuntimeException("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
                }
                field = extension.descriptor;
            } else {
                field = type.findFieldByName(name);
            }
            if (field == null && (field = type.findFieldByName(lowerName = name.toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field = null;
            }
            if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name) && !field.getMessageType().getFullName().equalsIgnoreCase(name)) {
                field = null;
            }
            if (field == null && DIGITS.matcher(name).matches()) {
                field = type.findFieldByNumber(Integer.parseInt(name));
                unknown = true;
            }
            if (field == null) {
                UnknownFieldSet.Builder unknownsBuilder = UnknownFieldSet.newBuilder();
                SmileFormat.handleMissingField(name, parser, extensionRegistry, unknownsBuilder);
                builder.setUnknownFields(unknownsBuilder.build());
            }
        }
        if (field != null) {
            token = parser.nextToken();
            boolean array = token.equals((Object)JsonToken.START_ARRAY);
            if (array) {
                token = parser.nextToken();
                while (!token.equals((Object)JsonToken.END_ARRAY)) {
                    SmileFormat.handleValue(parser, extensionRegistry, builder, field, extension, unknown);
                    token = parser.nextToken();
                }
            } else {
                SmileFormat.handleValue(parser, extensionRegistry, builder, field, extension, unknown);
            }
        }
    }

    private static void handleMissingField(String fieldName, JsonParser parser, ExtensionRegistry extensionRegistry, UnknownFieldSet.Builder builder) throws IOException {
        JsonToken token = parser.nextToken();
        if (token.equals((Object)JsonToken.START_OBJECT)) {
            token = parser.nextToken();
            while (token != null && !token.equals((Object)JsonToken.END_OBJECT)) {
                SmileFormat.handleMissingField(fieldName, parser, extensionRegistry, builder);
                token = parser.nextToken();
            }
        } else if (token.equals((Object)JsonToken.START_ARRAY)) {
            do {
                SmileFormat.handleMissingField(fieldName, parser, extensionRegistry, builder);
            } while ((token = parser.getCurrentToken()) != null && !token.equals((Object)JsonToken.END_ARRAY));
        }
    }

    private static void handleValue(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, boolean unknown) throws IOException {
        Object value = null;
        value = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? SmileFormat.handleObject(parser, extensionRegistry, builder, field, extension, unknown) : SmileFormat.handlePrimitive(parser, field);
        if (value != null) {
            if (field.isRepeated()) {
                builder.addRepeatedField(field, value);
            } else {
                builder.setField(field, value);
            }
        }
    }

    private static Object handlePrimitive(JsonParser parser, Descriptors.FieldDescriptor field) throws IOException {
        Object value = null;
        JsonToken token = parser.getCurrentToken();
        if (token.equals((Object)JsonToken.VALUE_NULL)) {
            return value;
        }
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                value = parser.getIntValue();
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                value = parser.getLongValue();
                break;
            }
            case UINT32: 
            case FIXED32: {
                int valueInt = parser.getIntValue();
                if (valueInt < 0) {
                    throw new NumberFormatException("Number must be positive: " + valueInt);
                }
                value = valueInt;
                break;
            }
            case UINT64: 
            case FIXED64: {
                long valueLong = parser.getLongValue();
                if (valueLong < 0L) {
                    throw new NumberFormatException("Number must be positive: " + valueLong);
                }
                value = valueLong;
                break;
            }
            case FLOAT: {
                value = Float.valueOf(parser.getFloatValue());
                break;
            }
            case DOUBLE: {
                value = parser.getDoubleValue();
                break;
            }
            case BOOL: {
                value = parser.getBooleanValue();
                break;
            }
            case STRING: {
                value = parser.getText();
                break;
            }
            case BYTES: {
                value = ByteString.copyFrom(parser.getBinaryValue());
                break;
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                if (token.equals((Object)JsonToken.VALUE_NUMBER_INT)) {
                    int number = parser.getIntValue();
                    value = enumType.findValueByNumber(number);
                    if (value != null) break;
                    throw new RuntimeException("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + ".");
                }
                String id = parser.getText();
                value = enumType.findValueByName(id);
                if (value != null) break;
                throw new RuntimeException("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
            }
            case MESSAGE: 
            case GROUP: {
                throw new RuntimeException("Can't get here.");
            }
        }
        return value;
    }

    private static Object handleObject(JsonParser parser, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, boolean unknown) throws IOException {
        Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
        JsonToken token = parser.getCurrentToken();
        if (unknown) {
            ByteString data = ByteString.copyFrom(parser.getBinaryValue());
            try {
                subBuilder.mergeFrom(data);
                return subBuilder.build();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Failed to build " + field.getFullName() + " from " + data);
            }
        }
        if (token.equals((Object)JsonToken.START_OBJECT)) {
            token = parser.nextToken();
            while (token != null && !token.equals((Object)JsonToken.END_OBJECT)) {
                SmileFormat.mergeField(parser, extensionRegistry, subBuilder);
                token = parser.nextToken();
            }
        }
        return subBuilder.build();
    }

    private static Integer unsignedInt(int value) {
        if (value < 0) {
            return (int)((long)value & 0xFFFFFFFFL);
        }
        return value;
    }

    private static Long unsignedLong(long value) {
        if (value < 0L) {
            return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).longValue();
        }
        return value;
    }
}

